/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

public class JdbcWriter
extends AbstractWriter {
    public static final String OPERATOR_TYPE = "JDBC_WRITER";
    private final JdbcStoragePlugin plugin;
    private final List<String> tableIdentifier;
    private final JdbcSchema inner;

    @JsonCreator
    public JdbcWriter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="tableIdentifier") List<String> tableIdentifier, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JacksonInject JdbcSchema inner, @JacksonInject StoragePluginRegistry engineRegistry) {
        super(child);
        this.plugin = (JdbcStoragePlugin)engineRegistry.resolve(storageConfig, JdbcStoragePlugin.class);
        this.tableIdentifier = tableIdentifier;
        this.inner = inner;
    }

    JdbcWriter(PhysicalOperator child, List<String> tableIdentifier, JdbcSchema inner, JdbcStoragePlugin plugin) {
        super(child);
        this.tableIdentifier = tableIdentifier;
        this.plugin = plugin;
        this.inner = inner;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new JdbcWriter(child, this.tableIdentifier, this.inner, this.plugin);
    }

    public List<String> getTableIdentifier() {
        return this.tableIdentifier;
    }

    public StoragePluginConfig getStorage() {
        return this.plugin.getConfig();
    }

    @JsonIgnore
    public JdbcSchema getInner() {
        return this.inner;
    }

    @JsonIgnore
    public JdbcStoragePlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("tableName", this.tableIdentifier).field("storageStrategy", (Object)this.getStorageStrategy()).toString();
    }
}

