/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.hdfs.BmcProperties;
import com.oracle.bmc.hdfs.store.BmcDataStore;
import com.oracle.bmc.hdfs.store.BmcPropertyAccessor;
import com.oracle.bmc.hdfs.waiter.ResettingExponentialBackoffStrategy;
import com.oracle.bmc.http.ApacheConfigurator;
import com.oracle.bmc.http.ApacheConnectionPoolConfig;
import com.oracle.bmc.http.ApacheConnectionPoolingClientConfigDecorator;
import com.oracle.bmc.http.ApacheConnectorProperties;
import com.oracle.bmc.http.ApacheProxyConfig;
import com.oracle.bmc.http.ApacheProxyConfigDecorator;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.JerseyDefaultConnectorConfigurator;
import com.oracle.bmc.http.JerseyLoggingClientConfigurator;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.ObjectStorageClient;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxTimeTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcDataStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BmcDataStoreFactory.class);
    private static final String OCI_PROPERTIES_FILE_NAME = "oci.properties";
    private final Configuration configuration;
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").build();

    public BmcDataStore createDataStore(String namespace, String bucket, FileSystem.Statistics statistics) {
        this.setConnectorVersion();
        String propertyOverrideSuffix = "." + bucket + "." + namespace;
        BmcPropertyAccessor propertyAccessor = new BmcPropertyAccessor(this.configuration, propertyOverrideSuffix);
        return new BmcDataStore(propertyAccessor, this.createClient(propertyAccessor), namespace, bucket, statistics);
    }

    @VisibleForTesting
    public ObjectStorage createClient(BmcPropertyAccessor propertyAccessor) {
        String customObjectStoreClient = propertyAccessor.asString().get(BmcProperties.OBJECT_STORE_CLIENT_CLASS);
        ObjectStorage objectStorage = customObjectStoreClient != null ? (ObjectStorage)this.createClass(customObjectStoreClient) : this.buildClient(propertyAccessor);
        String endpoint = this.getEndpoint(propertyAccessor.asString());
        LOG.info("Using endpoint {}", (Object)endpoint);
        objectStorage.setEndpoint(endpoint);
        return objectStorage;
    }

    private String getEndpoint(BmcPropertyAccessor.Accessor<String> propertyAccessor) {
        if (propertyAccessor.get(BmcProperties.HOST_NAME) != null) {
            LOG.info("Getting endpoint using {}", (Object)"fs.oci.client.hostname");
            return propertyAccessor.get(BmcProperties.HOST_NAME);
        }
        if (propertyAccessor.get(BmcProperties.REGION_CODE_OR_ID) != null) {
            LOG.info("Getting endpoint using {}", (Object)"fs.oci.client.regionCodeOrId");
            Region region = Region.fromRegionCodeOrId((String)propertyAccessor.get(BmcProperties.REGION_CODE_OR_ID));
            Optional endpoint = region.getEndpoint(SERVICE);
            if (endpoint.isPresent()) {
                return (String)endpoint.get();
            }
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        Region.enableInstanceMetadataService();
        LOG.info("Requesting region code from IMDS at {}", (Object)"http://169.254.169.254/opc/v2/instance/region");
        String regionCode = (String)AbstractFederationClientAuthenticationDetailsProviderBuilder.simpleRetry(base -> {
            String regionCodeUsingImds = (String)base.path("region").request(new String[]{"application/json"}).header("Authorization", (Object)"Bearer Oracle").get(String.class);
            return regionCodeUsingImds;
        }, (String)"http://169.254.169.254/opc/v2/", (String)"region");
        String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionCode);
        LOG.info("Endpoint using Instance Metadata Service is {}", (Object)endpoint);
        return endpoint;
    }

    private ObjectStorage buildClient(BmcPropertyAccessor propertyAccessor) {
        Integer readTimeoutMillis;
        ClientConfiguration.ClientConfigurationBuilder clientConfigurationBuilder = ClientConfiguration.builder();
        Integer connectionTimeoutMillis = propertyAccessor.asInteger().get(BmcProperties.CONNECTION_TIMEOUT_MILLIS);
        if (connectionTimeoutMillis != null) {
            LOG.info("Setting connection timeout to {}", (Object)connectionTimeoutMillis);
            clientConfigurationBuilder.connectionTimeoutMillis(connectionTimeoutMillis);
        }
        if ((readTimeoutMillis = propertyAccessor.asInteger().get(BmcProperties.READ_TIMEOUT_MILLIS)) != null) {
            LOG.info("Setting read timeout to {}", (Object)readTimeoutMillis);
            clientConfigurationBuilder.readTimeoutMillis(readTimeoutMillis);
        }
        long retryTimeoutInSeconds = propertyAccessor.asLong().get(BmcProperties.RETRY_TIMEOUT_IN_SECONDS);
        long resetThresholdInSeconds = propertyAccessor.asLong().get(BmcProperties.RETRY_TIMEOUT_RESET_THRESHOLD_IN_SECONDS);
        LOG.info("Setting retry timeout to {} seconds", (Object)retryTimeoutInSeconds);
        clientConfigurationBuilder.retryConfiguration(RetryConfiguration.builder().terminationStrategy((TerminationStrategy)MaxTimeTerminationStrategy.ofSeconds((long)retryTimeoutInSeconds)).delayStrategy((DelayStrategy)(resetThresholdInSeconds <= 0L ? new ExponentialBackoffDelayStrategy(Duration.ofSeconds(retryTimeoutInSeconds).toMillis()) : new ResettingExponentialBackoffStrategy(resetThresholdInSeconds))).build());
        ClientConfiguration clientConfig = clientConfigurationBuilder.build();
        BasicAuthenticationDetailsProvider authDetailsProvider = this.createAuthenticator(propertyAccessor);
        String httpProxyUri = propertyAccessor.asString().get(BmcProperties.HTTP_PROXY_URI);
        ObjectStorageClient.Builder objectStorageBuilder = (ObjectStorageClient.Builder)ObjectStorageClient.builder().configuration(clientConfig);
        if (propertyAccessor.asBoolean().get(BmcProperties.JERSEY_CLIENT_LOGGING_ENABLED).booleanValue()) {
            objectStorageBuilder.additionalClientConfigurator((ClientConfigurator)new JerseyLoggingClientConfigurator(LoggingFeature.Verbosity.valueOf((String)propertyAccessor.asString().get(BmcProperties.JERSEY_CLIENT_LOGGING_VERBOSITY)), propertyAccessor.asString().get(BmcProperties.JERSEY_CLIENT_LOGGING_LEVEL)));
        }
        Integer apacheMaxConnectionPoolSize = propertyAccessor.asInteger().get(BmcProperties.APACHE_MAX_CONNECTION_POOL_SIZE);
        if (propertyAccessor.asBoolean().get(BmcProperties.JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED).booleanValue()) {
            objectStorageBuilder.clientConfigurator((ClientConfigurator)new JerseyDefaultConnectorConfigurator.NonBuffering());
        } else if (apacheMaxConnectionPoolSize != null && apacheMaxConnectionPoolSize > 0) {
            String apacheConnectionClosingStrategyString = propertyAccessor.asString().get(BmcProperties.APACHE_CONNECTION_CLOSING_STRATEGY);
            Object apacheConnectionClosingStrategy = null;
            apacheConnectionClosingStrategy = apacheConnectionClosingStrategyString.equalsIgnoreCase("GRACEFUL") ? new ApacheConnectionClosingStrategy.GracefulClosingStrategy() : new ApacheConnectionClosingStrategy.ImmediateClosingStrategy();
            ApacheConnectionPoolConfig.newDefault();
            ApacheConnectionPoolConfig apacheConnectionPoolConfig = ApacheConnectionPoolConfig.builder().totalOpenConnections(apacheMaxConnectionPoolSize.intValue()).defaultMaxConnectionsPerRoute(apacheMaxConnectionPoolSize.intValue()).build();
            objectStorageBuilder.clientConfigurator((ClientConfigurator)new ApacheConfigurator.NonBuffering(ApacheConnectorProperties.builder().connectionClosingStrategy((ApacheConnectionClosingStrategy)apacheConnectionClosingStrategy).connectionPoolConfig(apacheConnectionPoolConfig).build()));
        }
        if (!propertyAccessor.asBoolean().get(BmcProperties.OBJECT_AUTO_CLOSE_INPUT_STREAM).booleanValue()) {
            ResponseHelper.shouldAutoCloseResponseInputStream((boolean)false);
        }
        return StringUtils.isBlank((CharSequence)httpProxyUri) ? objectStorageBuilder.build((AbstractAuthenticationDetailsProvider)authDetailsProvider) : this.buildClientWithProxy(authDetailsProvider, clientConfig, propertyAccessor, httpProxyUri);
    }

    private ObjectStorage buildClientWithProxy(BasicAuthenticationDetailsProvider authDetailsProvider, ClientConfiguration clientConfig, BmcPropertyAccessor propertyAccessor, String httpProxyUri) {
        LOG.info("Setting HTTP Proxy URI to {}", (Object)httpProxyUri);
        ClientConfigDecorator poolConfigDecorator = this.newApacheConnectionPoolingClientConfigDecorator(clientConfig);
        ClientConfigDecorator proxyConfigDecorator = this.newApacheProxyConfigDecorator(httpProxyUri, propertyAccessor);
        ArrayList clientConfigDecorators = Lists.newArrayList((Object[])new ClientConfigDecorator[]{poolConfigDecorator, proxyConfigDecorator});
        ApacheConfigurator clientConfigurator = new ApacheConfigurator((List)clientConfigDecorators);
        ObjectStorageClient.Builder objectStorageBuilder = (ObjectStorageClient.Builder)((ObjectStorageClient.Builder)ObjectStorageClient.builder().configuration(clientConfig)).clientConfigurator((ClientConfigurator)clientConfigurator);
        if (propertyAccessor.asBoolean().get(BmcProperties.JERSEY_CLIENT_LOGGING_ENABLED).booleanValue()) {
            objectStorageBuilder.additionalClientConfigurator((ClientConfigurator)new JerseyLoggingClientConfigurator(LoggingFeature.Verbosity.valueOf((String)propertyAccessor.asString().get(BmcProperties.JERSEY_CLIENT_LOGGING_VERBOSITY)), propertyAccessor.asString().get(BmcProperties.JERSEY_CLIENT_LOGGING_LEVEL)));
        }
        return objectStorageBuilder.build((AbstractAuthenticationDetailsProvider)authDetailsProvider);
    }

    private ClientConfigDecorator newApacheConnectionPoolingClientConfigDecorator(ClientConfiguration clientConfig) {
        int maxConns = clientConfig.getMaxAsyncThreads();
        ApacheConnectionPoolConfig poolConfig = ApacheConnectionPoolConfig.builder().defaultMaxConnectionsPerRoute(maxConns).totalOpenConnections(maxConns).ttlInMillis(clientConfig.getConnectionTimeoutMillis()).build();
        return new ApacheConnectionPoolingClientConfigDecorator(poolConfig);
    }

    private ClientConfigDecorator newApacheProxyConfigDecorator(String httpProxyUri, BmcPropertyAccessor propertyAccessor) {
        ApacheProxyConfig proxyConfig = ApacheProxyConfig.builder().uri(httpProxyUri).username(propertyAccessor.asString().get(BmcProperties.HTTP_PROXY_USERNAME)).password(propertyAccessor.asString().get(BmcProperties.HTTP_PROXY_PASSWORD)).build();
        return new ApacheProxyConfigDecorator(proxyConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectorVersion() {
        InputStream propertyStream = null;
        try {
            String connectorVersion;
            propertyStream = this.getClass().getClassLoader().getResourceAsStream("com/oracle/bmc/hdfs/oci.properties");
            Properties properties = new Properties();
            try {
                properties.load(propertyStream);
                connectorVersion = properties.getProperty("connector.version", "0.0.0");
            }
            catch (Exception e) {
                LOG.error("Failed to load oci.properties", (Throwable)e);
                connectorVersion = "0.0.0";
            }
            LOG.info("Using connector version: {}", (Object)connectorVersion);
            ClientRuntime.setClientUserAgent((String)String.format("Oracle-HDFS_Connector/%s", connectorVersion));
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(propertyStream);
            throw throwable;
        }
        StreamUtils.closeQuietly((InputStream)propertyStream);
    }

    @VisibleForTesting
    BasicAuthenticationDetailsProvider createAuthenticator(BmcPropertyAccessor propertyAccessor) {
        String customAuthenticator = propertyAccessor.asString().get(BmcProperties.OBJECT_STORE_AUTHENTICATOR_CLASS);
        if (customAuthenticator != null) {
            return (BasicAuthenticationDetailsProvider)this.createClass(customAuthenticator);
        }
        String tenantId = propertyAccessor.asString().get(BmcProperties.TENANT_ID);
        String userId = propertyAccessor.asString().get(BmcProperties.USER_ID);
        String fingerprint = propertyAccessor.asString().get(BmcProperties.FINGERPRINT);
        if (tenantId == null || userId == null || fingerprint == null) {
            throw new IllegalArgumentException(String.format("Must specify tenantId (%s), userId (%s), and fingerprint (%s) in configuration", tenantId, userId, fingerprint));
        }
        String pemFilePath = propertyAccessor.asString().get(BmcProperties.PEM_FILE_PATH);
        if (pemFilePath == null) {
            throw new IllegalArgumentException("Must specify PEM file path");
        }
        SimplePrivateKeySupplier supplier = new SimplePrivateKeySupplier(pemFilePath);
        char[] passPhrase = propertyAccessor.asPassword().get(BmcProperties.PASS_PHRASE);
        return SimpleAuthenticationDetailsProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).privateKeySupplier((Supplier)supplier).passphraseCharacters(passPhrase).build();
    }

    private <T> T createClass(String className) {
        try {
            Class<?> customClass = Class.forName(className);
            Constructor<?> customClassConstructor = customClass.getConstructor(Configuration.class);
            try {
                return (T)customClassConstructor.newInstance(this.configuration);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to create new custom client instance", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Configured to create custom class '" + className + "', but none exists");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Custom client class does not have the required constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to create new custom client instance", e);
        }
    }

    @ConstructorProperties(value={"configuration"})
    public BmcDataStoreFactory(Configuration configuration) {
        this.configuration = configuration;
    }
}

