/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.objectstorage.model.RenameObjectDetails;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.transfer.ProgressReporter;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RequestBuilder.class);
    private static final String SIZE_AND_TIME_FILDS = "size,timeCreated";
    private final String namespace;
    private final String bucket;

    ListObjectsRequest listObjects(@Nullable String prefix, @Nullable String nextToken, @Nullable String delimiter, @Nullable Integer limit) {
        ListObjectsRequest.Builder builder = ListObjectsRequest.builder().namespaceName(this.namespace).bucketName(this.bucket);
        if (prefix != null && !prefix.isEmpty()) {
            builder.prefix(prefix);
        }
        if (nextToken != null) {
            builder.start(nextToken);
        }
        if (delimiter != null) {
            builder.delimiter(delimiter);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.fields(SIZE_AND_TIME_FILDS).opcClientRequestId(RequestBuilder.createClientRequestId("listObjects")).build();
    }

    GetObjectRequest getObject(String objectName) {
        return this.getObjectBuilder(objectName).build();
    }

    GetObjectRequest.Builder getObjectBuilder(String objectName) {
        return GetObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).opcClientRequestId(RequestBuilder.createClientRequestId("getObject"));
    }

    HeadObjectRequest headObject(String objectName) {
        return HeadObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).opcClientRequestId(RequestBuilder.createClientRequestId("headObject")).build();
    }

    PutObjectRequest putObject(String objectName, InputStream input, long contentLengthInBytes) {
        return PutObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).putObjectBody(input).contentLength(Long.valueOf(contentLengthInBytes)).opcClientRequestId(RequestBuilder.createClientRequestId("putObject")).build();
    }

    PutObjectRequest putObject(String objectName, InputStream input, long contentLengthInBytes, String md5) {
        return PutObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).putObjectBody(input).contentLength(Long.valueOf(contentLengthInBytes)).contentMD5(md5).opcClientRequestId(RequestBuilder.createClientRequestId("putObject")).build();
    }

    RenameObjectRequest renameObject(String sourceName, String newName) {
        return RenameObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).renameObjectDetails(RenameObjectDetails.builder().sourceName(sourceName).newName(newName).build()).opcClientRequestId(RequestBuilder.createClientRequestId("renameObject")).build();
    }

    UploadManager.UploadRequest uploadRequest(String objectName, InputStream input, long contentLengthInBytes, Progressable progressable, boolean allowOverwrite, ExecutorService parallelUploadExecutor) {
        PutObjectRequest putObjectRequest = PutObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).opcClientRequestId(RequestBuilder.createClientRequestId("uploadRequest")).build();
        UploadManager.UploadRequest.UploadRequestBuilder uploadRequestBuilder = UploadManager.UploadRequest.builder((InputStream)input, (long)contentLengthInBytes).parallelUploadExecutorService(parallelUploadExecutor).allowOverwrite(allowOverwrite);
        if (progressable != null) {
            uploadRequestBuilder.progressReporter((ProgressReporter)new HadoopProgressReporter(progressable));
        } else {
            LOG.info("No Progressable passed, not reporting progress.");
        }
        return uploadRequestBuilder.build(putObjectRequest);
    }

    DeleteObjectRequest deleteObject(String objectName) {
        return DeleteObjectRequest.builder().namespaceName(this.namespace).bucketName(this.bucket).objectName(objectName).opcClientRequestId(RequestBuilder.createClientRequestId("deleteObject")).build();
    }

    private static String createClientRequestId(String operation) {
        String uuid = UUID.randomUUID().toString();
        LOG.debug("Using request ID {} for {}", (Object)uuid, (Object)operation);
        return uuid;
    }

    @ConstructorProperties(value={"namespace", "bucket"})
    RequestBuilder(String namespace, String bucket) {
        this.namespace = namespace;
        this.bucket = bucket;
    }

    private static final class HadoopProgressReporter
    implements ProgressReporter {
        private static final Logger LOG = LoggerFactory.getLogger(HadoopProgressReporter.class);
        private static final long NOTIFICATION_THRESHOLD_IN_SECONDS = 10L;
        private final Progressable progressable;
        private final StopWatch stopWatch = new StopWatch();

        public void onProgress(long completed, long total) {
            if (!this.stopWatch.isRunning() || this.stopWatch.now(TimeUnit.SECONDS) >= 10L) {
                this.stopWatch.reset().start();
                LOG.info("Reporting progress to Application Master ({}/{})", (Object)completed, (Object)total);
                this.progressable.progress();
            }
        }

        @ConstructorProperties(value={"progressable"})
        public HadoopProgressReporter(Progressable progressable) {
            this.progressable = progressable;
        }
    }
}

