/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CompactResponse
extends AdminResponse {
    private HashSet<PersistentID> persistentIds;

    public CompactResponse() {
    }

    public CompactResponse(InternalDistributedMember sender, HashSet<PersistentID> persistentIds) {
        this.setRecipient(sender);
        this.persistentIds = persistentIds;
    }

    public HashSet<PersistentID> getPersistentIds() {
        return this.persistentIds;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.persistentIds = DataSerializer.readHashSet(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeHashSet(this.persistentIds, out);
    }

    public CompactResponse(InternalDistributedMember sender) {
        this.setRecipient(sender);
    }

    public int getDSFID() {
        return 2119;
    }
}

