/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CacheDistributionAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private static final int INTEREST_MASK = 1;
    private static final int REPLICATE_MASK = 2;
    private static final int LOADER_MASK = 4;
    private static final int WRITER_MASK = 8;
    private static final int LISTENER_MASK = 16;
    private static final int DIST_ACK_MASK = 32;
    private static final int GLOBAL_MASK = 64;
    private static final int IN_RECOVERY_MASK = 128;
    private static final int PERSISTENT_MASK = 256;
    private static final int PROXY_MASK = 512;
    private static final int PRELOADED_MASK = 1024;
    private static final int IS_PARTITIONED_MASK = 2048;
    private static final int REGION_INITIALIZED_MASK = 4096;
    private static final int IS_GATEWAY_ENABLED_MASK = 8192;
    private static final int PERSISTENT_ID_MASK = 16384;
    protected static final int REQUIRES_NOTIFICATION_MASK = 32768;
    private static final int HAS_CACHE_SERVER_MASK = 65536;
    private static final int REQUIRES_OLD_VALUE_MASK = 131072;
    private static final int PERSISTENCE_INITIALIZED_MASK = 524288;
    private static final int GATEWAY_SENDER_IDS_MASK = 0x200000;
    private static final int ASYNC_EVENT_QUEUE_IDS_MASK = 0x400000;
    private static final int IS_OFF_HEAP_MASK = 0x800000;
    private static final int CACHE_SERVICE_PROFILES_MASK = 0x1000000;
    private Set<InternalDistributedMember> adviseSetforAllEvents = Collections.emptySet();
    private volatile long adviseAllEventsVersion = -1L;
    private Set<InternalDistributedMember> adviseSetforUpdate = Collections.emptySet();
    private volatile long adviseUpdateVersion = -1L;
    private volatile long inRecoveryVersion = 0L;
    private volatile long adviseInRecoveryVersion = -1L;

    public synchronized void incInRecoveryVersion() {
        ++this.inRecoveryVersion;
    }

    protected CacheDistributionAdvisor(CacheDistributionAdvisee region) {
        super(region);
    }

    static CacheDistributionAdvisor createCacheDistributionAdvisor(CacheDistributionAdvisee region) {
        CacheDistributionAdvisor advisor = new CacheDistributionAdvisor(region);
        advisor.initialize();
        return advisor;
    }

    public String toString() {
        return "CacheDistributionAdvisor for region " + this.getAdvisee().getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<InternalDistributedMember> adviseAllEventsOrCached() throws IllegalStateException {
        this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
        long tempProfilesVersion = this.profilesVersion;
        long tempInRecoveryVersion = this.inRecoveryVersion;
        if (this.adviseAllEventsVersion != tempProfilesVersion || this.adviseInRecoveryVersion != tempInRecoveryVersion) {
            Set<InternalDistributedMember> set = this.adviseSetforAllEvents;
            synchronized (set) {
                if (this.adviseAllEventsVersion != tempProfilesVersion || this.adviseInRecoveryVersion != tempInRecoveryVersion) {
                    this.adviseSetforAllEvents = Collections.unmodifiableSet(this.adviseFilter(profile -> {
                        CacheProfile cp = (CacheProfile)profile;
                        if (cp.getInRecovery()) {
                            return false;
                        }
                        return cp.cachedOrAllEventsWithListener();
                    }));
                    this.adviseAllEventsVersion = tempProfilesVersion;
                    this.adviseInRecoveryVersion = tempInRecoveryVersion;
                }
            }
        }
        return this.adviseSetforAllEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<InternalDistributedMember> adviseUpdate(EntryEventImpl event) throws IllegalStateException {
        if (event.hasNewValue() || event.getOperation().isPutAll()) {
            return this.adviseAllEventsOrCached();
        }
        long tempProfilesVersion = this.profilesVersion;
        if (this.adviseUpdateVersion != tempProfilesVersion) {
            Set<InternalDistributedMember> set = this.adviseSetforUpdate;
            synchronized (set) {
                if (this.adviseUpdateVersion != tempProfilesVersion) {
                    this.adviseSetforUpdate = Collections.unmodifiableSet(this.adviseFilter(profile -> {
                        CacheProfile cp = (CacheProfile)profile;
                        DataPolicy dp = cp.getDataPolicy();
                        return dp.withReplication() || cp.allEvents() && (dp.withStorage() || cp.hasCacheListener);
                    }));
                    this.adviseUpdateVersion = tempProfilesVersion;
                }
            }
        }
        return this.adviseSetforUpdate;
    }

    Set<InternalDistributedMember> adviseTX() throws IllegalStateException {
        boolean isMetaDataWithTransactions = this.getAdvisee() instanceof LocalRegion && ((LocalRegion)((Object)this.getAdvisee())).isMetaRegionWithTransactions();
        Set<Object> badList = Collections.emptySet();
        if (!TXManagerImpl.ALLOW_PERSISTENT_TRANSACTIONS && !isMetaDataWithTransactions) {
            badList = this.adviseFilter(profile -> {
                assert (profile instanceof CacheProfile);
                CacheProfile prof = (CacheProfile)profile;
                return prof.isPersistent();
            });
        }
        if (badList.isEmpty()) {
            return this.adviseFilter(profile -> {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.cachedOrAllEvents();
            });
        }
        StringBuilder badIds = new StringBuilder();
        Iterator<Object> biI = badList.iterator();
        while (biI.hasNext()) {
            badIds.append(((InternalDistributedMember)biI.next()).toString());
            if (!biI.hasNext()) continue;
            badIds.append(", ");
        }
        throw new IllegalStateException(String.format("Illegal Region Configuration for members: %s", badIds));
    }

    public Set<InternalDistributedMember> adviseNetLoad() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile prof = (CacheProfile)profile;
            if (!prof.regionInitialized) {
                return false;
            }
            return prof.hasCacheLoader;
        });
    }

    public FilterRoutingInfo adviseFilterRouting(CacheEvent<?, ?> event, Set<InternalDistributedMember> cacheOpRecipients) {
        FilterProfile fp = ((LocalRegion)event.getRegion()).getFilterProfile();
        if (fp != null) {
            return fp.getFilterRoutingInfoPart1(event, this.profiles, cacheOpRecipients);
        }
        return null;
    }

    public Set<InternalDistributedMember> adviseCacheOp() {
        return this.adviseAllEventsOrCached();
    }

    Set<InternalDistributedMember> adviseInvalidateRegion() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return !cp.getInRecovery();
        });
    }

    public Set<InternalDistributedMember> adviseDestroyRegion() {
        return this.adviseGeneric();
    }

    public Set<InternalDistributedMember> adviseNetWrite() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile prof = (CacheProfile)profile;
            if (prof.getInRecovery()) {
                return false;
            }
            return prof.hasCacheWriter;
        });
    }

    public Set<InternalDistributedMember> adviseInitializedReplicates() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.dataPolicy.withReplication() && cp.regionInitialized;
        });
    }

    Set<InternalDistributedMember> adviseNetSearch() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            if (!cp.regionInitialized) {
                return false;
            }
            DataPolicy dp = cp.dataPolicy;
            return dp.withStorage();
        });
    }

    public InitialImageAdvice adviseInitialImage(InitialImageAdvice previousAdvice) {
        return this.adviseInitialImage(previousAdvice, false);
    }

    public InitialImageAdvice adviseInitialImage(InitialImageAdvice previousAdvice, boolean persistent) {
        DistributionAdvisor.Profile[] allProfiles;
        this.initializationGate();
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_ADVISOR_VERBOSE)) {
            this.dumpProfiles("AdviseInitialImage");
        }
        if ((allProfiles = this.profiles).length == 0) {
            return new InitialImageAdvice();
        }
        HashSet<InternalDistributedMember> replicates = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> others = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> preloaded = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> empties = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> uninitialized = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> nonPersistent = new HashSet<InternalDistributedMember>();
        HashMap<InternalDistributedMember, CacheProfile> memberProfiles = new HashMap<InternalDistributedMember, CacheProfile>();
        for (DistributionAdvisor.Profile allProfile : allProfiles) {
            CacheProfile previousProfile;
            CacheProfile profile = (CacheProfile)allProfile;
            if (previousAdvice != null && (previousProfile = (CacheProfile)previousAdvice.memberProfiles.get(profile.getDistributedMember())) != null && previousProfile.getSerialNumber() == profile.getSerialNumber() && previousProfile.getVersion() == profile.getVersion()) continue;
            if (profile.getInRecovery()) {
                uninitialized.add(profile.getDistributedMember());
                continue;
            }
            if (!profile.regionInitialized) {
                uninitialized.add(profile.getDistributedMember());
                continue;
            }
            if (profile.dataPolicy.withReplication()) {
                if (!persistent || profile.dataPolicy.withPersistence()) {
                    replicates.add(profile.getDistributedMember());
                } else {
                    nonPersistent.add(profile.getDistributedMember());
                }
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            if (profile.dataPolicy.isPreloaded()) {
                preloaded.add(profile.getDistributedMember());
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            if (profile.dataPolicy.withStorage()) {
                others.add(profile.getDistributedMember());
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            empties.add(profile.getDistributedMember());
        }
        InitialImageAdvice advice = new InitialImageAdvice(replicates, others, preloaded, empties, uninitialized, nonPersistent, memberProfiles);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)advice);
        }
        return advice;
    }

    Set<InternalDistributedMember> adviseRequiresOldValueInCacheOp() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.requiresOldValueInEvents && !cp.regionInitialized;
        });
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new CacheProfile(memberId, version);
    }

    @Override
    protected boolean evaluateProfiles(DistributionAdvisor.Profile newProfile, DistributionAdvisor.Profile oldProfile) {
        boolean result = super.evaluateProfiles(newProfile, oldProfile);
        if (result) {
            CacheProfile newCP = (CacheProfile)newProfile;
            CacheProfile oldCP = (CacheProfile)oldProfile;
            if ((oldCP == null || !oldCP.regionInitialized) && newCP.regionInitialized) {
                CacheDistributionAdvisee advisee = (CacheDistributionAdvisee)this.getAdvisee();
                advisee.remoteRegionInitialized(newCP);
            }
        }
        return result;
    }

    public Set<InternalDistributedMember> adviseReplicates() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.dataPolicy.withReplication();
        });
    }

    public Set<InternalDistributedMember> advisePreloadeds() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.dataPolicy.withPreloaded();
        });
    }

    Set<InternalDistributedMember> adviseEmptys() {
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.dataPolicy.isEmpty();
        });
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (logger.isDebugEnabled()) {
            logger.debug("CDA: removing profile {}", (Object)profile);
        }
        if (this.getAdvisee() instanceof LocalRegion && profile != null) {
            ((LocalRegion)((Object)this.getAdvisee())).removeCriticalMember(profile.getDistributedMember());
        }
    }

    public Map<InternalDistributedMember, PersistentMemberID> advisePersistentMembers() {
        DistributionAdvisor.Profile[] snapshot;
        this.initializationGate();
        HashMap<InternalDistributedMember, PersistentMemberID> result = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            CacheProfile cp = (CacheProfile)profile;
            if (cp.persistentID == null) continue;
            result.put(cp.getDistributedMember(), cp.persistentID);
        }
        return result;
    }

    public Map<InternalDistributedMember, PersistentMemberID> adviseInitializedPersistentMembers() {
        DistributionAdvisor.Profile[] snapshot;
        this.initializationGate();
        HashMap<InternalDistributedMember, PersistentMemberID> result = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            CacheProfile cp = (CacheProfile)profile;
            if (cp.persistentID == null || !cp.persistenceInitialized) continue;
            result.put(cp.getDistributedMember(), cp.persistentID);
        }
        return result;
    }

    Set<InternalDistributedMember> adviseCacheServers() {
        this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
        return this.adviseFilter(profile -> {
            assert (profile instanceof CacheProfile);
            CacheProfile cp = (CacheProfile)profile;
            return cp.hasCacheServer;
        });
    }

    public void addMembershipAndProxyListener(MembershipListener listener) {
        this.addMembershipListener(listener);
    }

    public void removeMembershipAndProxyListener(MembershipListener listener) {
        this.removeMembershipListener(listener);
    }

    @Override
    public boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        DistributedRegion r;
        boolean isPersistent = false;
        DiskStoreID persistentId = null;
        CacheDistributionAdvisee advisee = (CacheDistributionAdvisee)this.getAdvisee();
        if (advisee.getAttributes().getDataPolicy().withPersistence()) {
            isPersistent = true;
            CacheProfile profile = (CacheProfile)this.getProfile(memberId);
            if (profile != null && profile.persistentID != null) {
                persistentId = ((CacheProfile)this.getProfile((DistributionAdvisor.ProfileId)memberId)).persistentID.getDiskStoreId();
            }
        }
        boolean result = super.removeId(memberId, crashed, destroyed, fromMembershipListener);
        if (advisee instanceof DistributedRegion && !(r = (DistributedRegion)advisee).isInitialized() && !r.isUsedForPartitionedRegionBucket()) {
            if (logger.isDebugEnabled()) {
                logger.debug("recording that {} has left during initialization of {}", (Object)memberId, (Object)r.getName());
            }
            ImageState state = r.getImageState();
            if (isPersistent) {
                if (persistentId != null) {
                    state.addLeftMember(persistentId);
                }
            } else {
                state.addLeftMember((InternalDistributedMember)memberId);
            }
        }
        return result;
    }

    public static class InitialImageAdvice {
        protected final Set<InternalDistributedMember> replicates;
        protected final Set<InternalDistributedMember> preloaded;
        protected Set<InternalDistributedMember> others;
        protected final Set<InternalDistributedMember> empties;
        protected final Set<InternalDistributedMember> uninitialized;
        final Set<InternalDistributedMember> nonPersistent;
        private final Map<InternalDistributedMember, CacheProfile> memberProfiles;

        public Set<InternalDistributedMember> getOthers() {
            return this.others;
        }

        public void setOthers(Set<InternalDistributedMember> others) {
            this.others = others;
        }

        public Set<InternalDistributedMember> getReplicates() {
            return this.replicates;
        }

        public Set<InternalDistributedMember> getNonPersistent() {
            return this.nonPersistent;
        }

        public Set<InternalDistributedMember> getPreloaded() {
            return this.preloaded;
        }

        public Set<InternalDistributedMember> getEmpties() {
            return this.empties;
        }

        public Set<InternalDistributedMember> getUninitialized() {
            return this.uninitialized;
        }

        public InitialImageAdvice(Set<InternalDistributedMember> replicates, Set<InternalDistributedMember> others, Set<InternalDistributedMember> preloaded, Set<InternalDistributedMember> empties, Set<InternalDistributedMember> uninitialized, Set<InternalDistributedMember> nonPersistent, Map<InternalDistributedMember, CacheProfile> memberProfiles) {
            this.replicates = replicates;
            this.others = others;
            this.preloaded = preloaded;
            this.empties = empties;
            this.uninitialized = uninitialized;
            this.nonPersistent = nonPersistent;
            this.memberProfiles = memberProfiles;
        }

        public InitialImageAdvice() {
            this(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
        }

        public String toString() {
            return "InitialImageAdvice(replicates=" + this.replicates + "; others=" + this.others + "; preloaded=" + this.preloaded + "; empty=" + this.empties + "; initializing=" + this.uninitialized + ")";
        }
    }

    public static class CacheProfile
    extends DistributionAdvisor.Profile {
        public DataPolicy dataPolicy = DataPolicy.REPLICATE;
        public InterestPolicy interestPolicy = InterestPolicy.DEFAULT;
        public boolean hasCacheLoader = false;
        public boolean hasCacheWriter = false;
        public boolean hasCacheListener = false;
        public Scope scope = Scope.DISTRIBUTED_NO_ACK;
        private boolean inRecovery = false;
        public Set<String> gatewaySenderIds = Collections.emptySet();
        public Set<String> asyncEventQueueIds = Collections.emptySet();
        public SubscriptionAttributes subscriptionAttributes = null;
        public boolean isPartitioned = false;
        public boolean isGatewayEnabled = false;
        public boolean isPersistent = false;
        public boolean isOffHeap = false;
        public FilterProfile filterProfile;
        boolean requiresOldValueInEvents;
        public boolean regionInitialized;
        public boolean persistenceInitialized;
        public PersistentMemberID persistentID;
        public boolean hasCacheServer = false;
        List<CacheServiceProfile> cacheServiceProfiles = new ArrayList<CacheServiceProfile>();

        public CacheProfile() {
        }

        public CacheProfile(FilterProfile localProfile) {
            this.filterProfile = localProfile;
        }

        public CacheProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public CacheProfile(CacheProfile toCopy) {
            super(toCopy.getDistributedMember(), toCopy.version);
            this.setIntInfo(toCopy.getIntInfo());
        }

        protected int getIntInfo() {
            int s = 0;
            if (this.dataPolicy.withReplication()) {
                s |= 2;
                if (this.dataPolicy.isPersistentReplicate()) {
                    s |= 0x100;
                }
            } else {
                if (this.dataPolicy.isEmpty()) {
                    s |= 0x200;
                }
                if (this.dataPolicy.isPreloaded()) {
                    s |= 0x400;
                }
            }
            if (this.subscriptionAttributes != null && this.subscriptionAttributes.getInterestPolicy().isAll()) {
                s |= 1;
            }
            if (this.hasCacheLoader) {
                s |= 4;
            }
            if (this.hasCacheWriter) {
                s |= 8;
            }
            if (this.hasCacheListener) {
                s |= 0x10;
            }
            if (this.scope.isDistributedAck()) {
                s |= 0x20;
            }
            if (this.scope.isGlobal()) {
                s |= 0x40;
            }
            if (this.inRecovery) {
                s |= 0x80;
            }
            if (this.isPartitioned) {
                s |= 0x800;
            }
            if (this.isGatewayEnabled) {
                s |= 0x2000;
            }
            if (this.isPersistent) {
                s |= 0x100;
            }
            if (this.regionInitialized) {
                s |= 0x1000;
            }
            if (this.persistentID != null) {
                s |= 0x4000;
            }
            if (this.hasCacheServer) {
                s |= 0x10000;
            }
            if (this.requiresOldValueInEvents) {
                s |= 0x20000;
            }
            if (this.persistenceInitialized) {
                s |= 0x80000;
            }
            if (!this.gatewaySenderIds.isEmpty()) {
                s |= 0x200000;
            }
            if (!this.asyncEventQueueIds.isEmpty()) {
                s |= 0x400000;
            }
            if (this.isOffHeap) {
                s |= 0x800000;
            }
            if (!this.cacheServiceProfiles.isEmpty()) {
                s |= 0x1000000;
            }
            Assert.assertTrue(!this.scope.isLocal());
            return s;
        }

        private boolean hasGatewaySenderIds(int bits) {
            return (bits & 0x200000) != 0;
        }

        private boolean hasAsyncEventQueueIds(int bits) {
            return (bits & 0x400000) != 0;
        }

        private boolean hasPersistentID(int bits) {
            return (bits & 0x4000) != 0;
        }

        public boolean isPersistent() {
            return this.dataPolicy.withPersistence();
        }

        public boolean getInRecovery() {
            return this.inRecovery;
        }

        public void setInRecovery(boolean recovery) {
            this.inRecovery = recovery;
        }

        public DataPolicy getDataPolicy() {
            return this.dataPolicy;
        }

        protected void setIntInfo(int s) {
            this.dataPolicy = (s & 2) != 0 ? ((s & 0x100) != 0 ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE) : ((s & 0x200) != 0 ? DataPolicy.EMPTY : ((s & 0x400) != 0 ? DataPolicy.PRELOADED : DataPolicy.NORMAL));
            if ((s & 0x800) != 0) {
                this.dataPolicy = (s & 0x100) != 0 ? DataPolicy.PERSISTENT_PARTITION : DataPolicy.PARTITION;
            }
            this.subscriptionAttributes = (s & 1) != 0 ? new SubscriptionAttributes(InterestPolicy.ALL) : new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT);
            this.hasCacheLoader = (s & 4) != 0;
            this.hasCacheWriter = (s & 8) != 0;
            boolean bl = this.hasCacheListener = (s & 0x10) != 0;
            this.scope = (s & 0x20) != 0 ? Scope.DISTRIBUTED_ACK : ((s & 0x40) != 0 ? Scope.GLOBAL : Scope.DISTRIBUTED_NO_ACK);
            this.inRecovery = (s & 0x80) != 0;
            this.isPartitioned = (s & 0x800) != 0;
            this.isGatewayEnabled = (s & 0x2000) != 0;
            this.isPersistent = (s & 0x100) != 0;
            this.regionInitialized = (s & 0x1000) != 0;
            this.hasCacheServer = (s & 0x10000) != 0;
            this.requiresOldValueInEvents = (s & 0x20000) != 0;
            this.persistenceInitialized = (s & 0x80000) != 0;
            this.isOffHeap = (s & 0x800000) != 0;
        }

        public void setSubscriptionAttributes(SubscriptionAttributes sa) {
            this.subscriptionAttributes = sa;
        }

        boolean cachedOrAllEventsWithListener() {
            return this.cachedOrAllEvents();
        }

        boolean cachedOrAllEvents() {
            return this.dataPolicy.withStorage() || this.allEvents();
        }

        boolean allEvents() {
            return this.subscriptionAttributes.getInterestPolicy().isAll();
        }

        public void addCacheServiceProfile(CacheServiceProfile profile) {
            this.cacheServiceProfiles.add(profile);
        }

        private boolean hasCacheServiceProfiles(int bits) {
            return (bits & 0x1000000) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            block14: {
                try {
                    InternalRegion lclRgn;
                    Assert.assertTrue(adviseePath != null, "adviseePath was null");
                    LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
                    try {
                        InternalCache cache = dm.getCache();
                        lclRgn = cache == null ? null : cache.getInternalRegionByPath(adviseePath);
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                    }
                    if (lclRgn instanceof CacheDistributionAdvisee) {
                        if (lclRgn.isUsedForPartitionedRegionBucket() && !((BucketRegion)lclRgn).isPartitionedRegionOpen()) {
                            return;
                        }
                        this.handleCacheDistributionAdvisee((CacheDistributionAdvisee)((Object)lclRgn), adviseePath, removeProfile, exchangeProfiles, true, replyProfiles);
                    } else if (lclRgn == null) {
                        this.handleCacheDistributionAdvisee(PartitionedRegionHelper.getProxyBucketRegion(dm.getCache(), adviseePath), adviseePath, removeProfile, exchangeProfiles, false, replyProfiles);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("While processing UpdateAttributes message, region has local scope: {}", (Object)adviseePath);
                    }
                }
                catch (PRLocallyDestroyedException fre) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("<Region Locally destroyed> /// {}", (Object)this);
                    }
                }
                catch (RegionDestroyedException e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug("<region destroyed> /// {}", (Object)this);
                }
            }
        }

        @Override
        public void cleanUp() {
            if (this.filterProfile != null) {
                this.filterProfile.cleanUp();
            }
        }

        private void handleCacheDistributionAdvisee(CacheDistributionAdvisee cda, String adviseePath, boolean removeProfile, boolean exchangeProfiles, boolean isRealRegion, List<DistributionAdvisor.Profile> replyProfiles) {
            if (cda != null) {
                this.handleDistributionAdvisee(cda, removeProfile, isRealRegion && exchangeProfiles, replyProfiles);
                if (logger.isDebugEnabled()) {
                    logger.debug("While processing UpdateAttributes message, handled advisee: {}", (Object)cda);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("While processing UpdateAttributes message, region not found: {}", (Object)adviseePath);
            }
        }

        @Override
        public int getDSFID() {
            return 104;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.getIntInfo());
            if (this.persistentID != null) {
                InternalDataSerializer.invokeToData(this.persistentID, out);
            }
            if (!this.gatewaySenderIds.isEmpty()) {
                this.writeSet(this.gatewaySenderIds, out);
            }
            if (!this.asyncEventQueueIds.isEmpty()) {
                this.writeSet(this.asyncEventQueueIds, out);
            }
            DataSerializer.writeObject(this.filterProfile, out);
            if (!this.cacheServiceProfiles.isEmpty()) {
                DataSerializer.writeObject(this.cacheServiceProfiles, out);
            }
        }

        private void writeSet(Set<?> set, DataOutput out) throws IOException {
            out.writeByte(DSCODE.HASH_SET.toByte());
            InternalDataSerializer.writeSet(set, out);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            int bits = in.readInt();
            this.setIntInfo(bits);
            if (this.hasPersistentID(bits)) {
                this.persistentID = new PersistentMemberID();
                InternalDataSerializer.invokeFromData(this.persistentID, in);
            }
            if (this.hasGatewaySenderIds(bits)) {
                this.gatewaySenderIds = (Set)DataSerializer.readObject(in);
            }
            if (this.hasAsyncEventQueueIds(bits)) {
                this.asyncEventQueueIds = (Set)DataSerializer.readObject(in);
            }
            this.filterProfile = (FilterProfile)DataSerializer.readObject(in);
            if (this.hasCacheServiceProfiles(bits)) {
                this.cacheServiceProfiles = (List)DataSerializer.readObject(in);
            }
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("CacheProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; dataPolicy=").append(this.dataPolicy);
            sb.append("; hasCacheLoader=").append(this.hasCacheLoader);
            sb.append("; hasCacheWriter=").append(this.hasCacheWriter);
            sb.append("; hasCacheListener=").append(this.hasCacheListener);
            sb.append("; hasCacheServer=").append(this.hasCacheServer);
            sb.append("; scope=").append(this.scope);
            sb.append("; regionInitialized=").append(this.regionInitialized);
            sb.append("; inRecovery=").append(this.inRecovery);
            sb.append("; subcription=").append(this.subscriptionAttributes);
            sb.append("; isPartitioned=").append(this.isPartitioned);
            sb.append("; isGatewayEnabled=").append(this.isGatewayEnabled);
            sb.append("; isPersistent=").append(this.isPersistent);
            sb.append("; persistentID=").append(this.persistentID);
            if (this.filterProfile != null) {
                sb.append("; ").append(this.filterProfile);
            }
            sb.append("; gatewaySenderIds =").append(this.gatewaySenderIds);
            sb.append("; asyncEventQueueIds =").append(this.asyncEventQueueIds);
            sb.append("; IsOffHeap=").append(this.isOffHeap);
            sb.append("; cacheServiceProfiles=").append(this.cacheServiceProfiles);
        }
    }
}

