/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.OplogSet;
import org.apache.geode.internal.cache.ValidatingDiskRegion;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.DiskStoreFilter;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.OplogType;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PersistentOplogSet
implements OplogSet {
    private static final Logger logger = LogService.getLogger();
    private final AtomicLong oplogEntryId = new AtomicLong(0L);
    private final Map<Long, Oplog> drfOnlyOplogs = new LinkedHashMap<Long, Oplog>();
    private final Map<Long, Oplog> oplogIdToOplog = new LinkedHashMap<Long, Oplog>();
    private final Map<Long, Oplog> inactiveOplogs = new LinkedHashMap<Long, Oplog>(16, 0.75f, true);
    private final DiskStoreImpl parent;
    private final AtomicInteger inactiveOpenCount = new AtomicInteger();
    private final Map<Long, DiskRecoveryStore> pendingRecoveryMap = new HashMap<Long, DiskRecoveryStore>();
    private final Map<Long, DiskRecoveryStore> currentRecoveryMap = new HashMap<Long, DiskRecoveryStore>();
    private final AtomicBoolean alreadyRecoveredOnce = new AtomicBoolean(false);
    private final PrintStream out;
    private volatile Oplog child;
    private volatile long maxRecoveredOplogId;
    private int dirCounter = -1;

    public PersistentOplogSet(DiskStoreImpl parent, PrintStream out) {
        this.parent = parent;
        this.out = out;
    }

    public Oplog getChild() {
        return this.child;
    }

    void setChild(Oplog oplog) {
        this.child = oplog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Oplog[] getAllOplogs() {
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            int i;
            int rollNum = this.getOplogIdToOplog().size();
            int inactiveNum = this.inactiveOplogs.size();
            int drfOnlyNum = this.drfOnlyOplogs.size();
            int num = rollNum + inactiveNum + drfOnlyNum + 1;
            Oplog[] oplogs = new Oplog[num];
            oplogs[0] = this.getChild();
            Iterator<Oplog> oplogIterator = this.getOplogIdToOplog().values().iterator();
            for (i = 1; i <= rollNum; ++i) {
                oplogs[i] = oplogIterator.next();
            }
            oplogIterator = this.inactiveOplogs.values().iterator();
            for (i = 1; i <= inactiveNum; ++i) {
                oplogs[i + rollNum] = oplogIterator.next();
            }
            oplogIterator = this.drfOnlyOplogs.values().iterator();
            for (i = 1; i <= drfOnlyNum; ++i) {
                oplogs[i + rollNum + inactiveNum] = oplogIterator.next();
            }
            if (oplogs.length == 1 && oplogs[0] == null) {
                return new Oplog[0];
            }
            return oplogs;
        }
    }

    private TreeSet<Oplog> getSortedOplogs() {
        TreeSet<Oplog> result = new TreeSet<Oplog>((arg0, arg1) -> Long.signum(((Oplog)arg1).getOplogId() - ((Oplog)arg0).getOplogId()));
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            result.add(oplog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Oplog getChild(long id) {
        Oplog localOplog = this.child;
        if (localOplog != null && id == localOplog.getOplogId()) {
            return localOplog;
        }
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            Oplog result = this.getOplogIdToOplog().get(id);
            if (result == null) {
                result = this.inactiveOplogs.get(id);
            }
            return result;
        }
    }

    @Override
    public void create(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        this.getChild().create(region, entry, value, async);
    }

    @Override
    public void modify(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        this.getChild().modify(region, entry, value, async);
    }

    void offlineModify(DiskRegionView drv, DiskEntry entry, byte[] value, boolean isSerializedObject) {
        this.getChild().offlineModify(drv, entry, value, isSerializedObject);
    }

    @Override
    public void remove(InternalRegion region, DiskEntry entry, boolean async, boolean isClear) {
        this.getChild().remove(region, entry, async, isClear);
    }

    public void forceRoll(DiskRegion dr) {
        Oplog child = this.getChild();
        if (child != null) {
            child.forceRolling(dr);
        }
    }

    Map<File, DirectoryHolder> findFiles(String partialFileName) {
        this.dirCounter = 0;
        HashMap<File, DirectoryHolder> backupFiles = new HashMap<File, DirectoryHolder>();
        FilenameFilter backupFileFilter = this.getFileNameFilter(partialFileName);
        for (DirectoryHolder dh : this.parent.directories) {
            File[] backupList = dh.getDir().listFiles(backupFileFilter);
            if (backupList == null) continue;
            for (File f : backupList) {
                backupFiles.put(f, dh);
            }
        }
        return backupFiles;
    }

    private FilenameFilter getFileNameFilter(String partialFileName) {
        return new DiskStoreFilter(OplogType.BACKUP, false, partialFileName);
    }

    void createOplogs(boolean needsOplogs, Map<File, DirectoryHolder> backupFiles) {
        LongOpenHashSet foundCrfs = new LongOpenHashSet();
        LongOpenHashSet foundDrfs = new LongOpenHashSet();
        for (Map.Entry<File, DirectoryHolder> entry : backupFiles.entrySet()) {
            Oplog oplog;
            File file = entry.getKey();
            String absolutePath = file.getAbsolutePath();
            int underscorePosition = absolutePath.lastIndexOf(95);
            int pointPosition = absolutePath.lastIndexOf(46);
            String oplogIdString = absolutePath.substring(underscorePosition + 1, pointPosition);
            long oplogId = Long.parseLong(oplogIdString);
            this.maxRecoveredOplogId = Math.max(this.maxRecoveredOplogId, oplogId);
            if (Oplog.isCRFFile(file.getName())) {
                if (!this.isCrfOplogIdPresent(oplogId)) {
                    this.deleteFileOnRecovery(file);
                    try {
                        String krfFileName = Oplog.getKRFFilenameFromCRFFilename(file.getAbsolutePath());
                        File krfFile = new File(krfFileName);
                        this.deleteFileOnRecovery(krfFile);
                    }
                    catch (Exception krfFileName) {}
                    continue;
                }
            } else if (Oplog.isDRFFile(file.getName()) && !this.isDrfOplogIdPresent(oplogId)) {
                this.deleteFileOnRecovery(file);
                continue;
            }
            if ((oplog = this.getChild(oplogId)) == null) {
                oplog = new Oplog(oplogId, this);
                this.addRecoveredOplog(oplog);
            }
            if (oplog.addRecoveredFile(file, entry.getValue())) {
                foundCrfs.add(oplogId);
                continue;
            }
            foundDrfs.add(oplogId);
        }
        if (needsOplogs) {
            this.verifyOplogs(foundCrfs, foundDrfs);
        }
    }

    private boolean isDrfOplogIdPresent(long oplogId) {
        return this.parent.getDiskInitFile().isDRFOplogIdPresent(oplogId);
    }

    private boolean isCrfOplogIdPresent(long oplogId) {
        return this.parent.getDiskInitFile().isCRFOplogIdPresent(oplogId);
    }

    private void verifyOplogs(LongOpenHashSet foundCrfs, LongOpenHashSet foundDrfs) {
        this.parent.getDiskInitFile().verifyOplogs(foundCrfs, foundDrfs);
    }

    private void deleteFileOnRecovery(File f) {
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addRecoveredOplog(Oplog oplog) {
        this.basicAddToBeCompacted(oplog);
    }

    void addToBeCompacted(Oplog oplog) {
        this.basicAddToBeCompacted(oplog);
        this.parent.scheduleCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicAddToBeCompacted(Oplog oplog) {
        if (!oplog.isRecovering() && oplog.hasNoLiveValues()) {
            oplog.cancelKrf();
            oplog.close();
            oplog.deleteFiles(oplog.getHasDeletes());
        } else {
            this.parent.getStats().incCompactableOplogs(1);
            Long key = oplog.getOplogId();
            int inactivePromotedCount = 0;
            Map<Long, Oplog> map = this.getOplogIdToOplog();
            synchronized (map) {
                if (this.inactiveOplogs.remove(key) != null) {
                    if (oplog.isRAFOpen()) {
                        this.inactiveOpenCount.decrementAndGet();
                    }
                    ++inactivePromotedCount;
                }
                this.getOplogIdToOplog().put(key, oplog);
            }
            if (inactivePromotedCount > 0) {
                this.parent.getStats().incInactiveOplogs(-inactivePromotedCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverRegionsThatAreReady() {
        AtomicBoolean atomicBoolean = this.getAlreadyRecoveredOnce();
        synchronized (atomicBoolean) {
            Map<Long, DiskRecoveryStore> map = this.pendingRecoveryMap;
            synchronized (map) {
                this.currentRecoveryMap.clear();
                this.currentRecoveryMap.putAll(this.pendingRecoveryMap);
                this.pendingRecoveryMap.clear();
            }
            if (this.currentRecoveryMap.isEmpty() && this.getAlreadyRecoveredOnce().get()) {
                return;
            }
            for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                drs.getDiskRegionView().prepareForRecovery();
            }
            if (!this.getAlreadyRecoveredOnce().get()) {
                this.initOplogEntryId();
                this.updateOplogEntryId(this.parent.getDiskInitFile().getMaxRecoveredClearEntryId());
            }
            long start = this.parent.getStats().startRecovery();
            EntryLogger.setSource(this.parent.getDiskStoreID(), "recovery");
            long byteCount = 0L;
            try {
                byteCount = this.recoverOplogs(byteCount);
            }
            finally {
                HashMap<String, Integer> prSizes = null;
                HashMap<String, Integer> prBuckets = null;
                if (this.parent.isValidating()) {
                    prSizes = new HashMap<String, Integer>();
                    prBuckets = new HashMap<String, Integer>();
                }
                for (DiskRecoveryStore diskRecoveryStore : this.currentRecoveryMap.values()) {
                    for (Oplog oplog : this.getAllOplogs()) {
                        if (oplog == null) continue;
                        oplog.checkForRecoverableRegion(diskRecoveryStore.getDiskRegionView());
                    }
                    if (!this.parent.isValidating() || !(diskRecoveryStore instanceof ValidatingDiskRegion)) continue;
                    ValidatingDiskRegion vdr = (ValidatingDiskRegion)diskRecoveryStore;
                    if (vdr.isBucket()) {
                        String prName = vdr.getPrName();
                        if (prSizes.containsKey(prName)) {
                            int oldSize = (Integer)prSizes.get(prName);
                            prSizes.put(prName, oldSize += vdr.size());
                            int oldBuckets = (Integer)prBuckets.get(prName);
                            prBuckets.put(prName, ++oldBuckets);
                            continue;
                        }
                        prSizes.put(prName, vdr.size());
                        prBuckets.put(prName, 1);
                        continue;
                    }
                    this.parent.incLiveEntryCount(vdr.size());
                    this.out.println(vdr.getName() + ": entryCount=" + vdr.size());
                }
                if (this.parent.isValidating()) {
                    for (Map.Entry entry : prSizes.entrySet()) {
                        this.parent.incLiveEntryCount((Integer)entry.getValue());
                        this.out.println((String)entry.getKey() + " entryCount=" + entry.getValue() + " bucketCount=" + prBuckets.get(entry.getKey()));
                    }
                }
                this.parent.getStats().endRecovery(start, byteCount);
                this.getAlreadyRecoveredOnce().set(true);
                this.currentRecoveryMap.clear();
                EntryLogger.clearSource();
            }
        }
    }

    private long recoverOplogs(long byteCount) {
        DiskStoreImpl.OplogEntryIdSet deletedIds = new DiskStoreImpl.OplogEntryIdSet();
        TreeSet<Oplog> oplogSet = this.getSortedOplogs();
        if (!this.getAlreadyRecoveredOnce().get() && this.getChild() != null && !this.getChild().hasBeenUsed()) {
            oplogSet.remove(this.getChild());
        }
        HashSet<Oplog> oplogsNeedingValueRecovery = new HashSet<Oplog>();
        if (!oplogSet.isEmpty()) {
            long startOpLogRecovery = System.currentTimeMillis();
            boolean latestOplog = true;
            for (Oplog oplog : oplogSet) {
                byteCount += oplog.recoverDrf(deletedIds, this.getAlreadyRecoveredOnce().get(), latestOplog);
                latestOplog = false;
                if (this.getAlreadyRecoveredOnce().get()) continue;
                this.updateOplogEntryId(oplog.getMaxRecoveredOplogEntryId());
            }
            this.parent.incDeadRecordCount(deletedIds.size());
            latestOplog = true;
            for (Oplog oplog : oplogSet) {
                long startOpLogRead = this.parent.getStats().startOplogRead();
                long bytesRead = oplog.recoverCrf(deletedIds, this.recoverValues(), this.recoverValuesSync(), this.getAlreadyRecoveredOnce().get(), oplogsNeedingValueRecovery, latestOplog);
                latestOplog = false;
                if (!this.getAlreadyRecoveredOnce().get()) {
                    this.updateOplogEntryId(oplog.getMaxRecoveredOplogEntryId());
                }
                byteCount += bytesRead;
                this.parent.getStats().endOplogRead(startOpLogRead, bytesRead);
                for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                    drs.getDiskRegionView().oplogRecovered(oplog.oplogId);
                }
            }
            long endOpLogRecovery = System.currentTimeMillis();
            long elapsed = endOpLogRecovery - startOpLogRecovery;
            logger.info("recovery oplog load took {} ms", (Object)elapsed);
        }
        if (!this.parent.isOfflineCompacting()) {
            long startRegionInit = System.currentTimeMillis();
            for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                drs.getDiskRegionView().initRecoveredEntryCount();
            }
            if (!this.getAlreadyRecoveredOnce().get()) {
                for (Oplog oplog : oplogSet) {
                    if (oplog == this.getChild()) continue;
                    oplog.initAfterRecovery(this.parent.isOffline());
                }
                if (this.getChild() == null) {
                    this.setFirstChild(this.getSortedOplogs(), false);
                }
            }
            if (!this.parent.isOffline()) {
                if (this.recoverValues() && !this.recoverValuesSync()) {
                    this.parent.scheduleValueRecovery(oplogsNeedingValueRecovery, this.currentRecoveryMap);
                }
                if (!this.getAlreadyRecoveredOnce().get()) {
                    for (Oplog oplog : oplogSet) {
                        if (!oplog.needsKrf()) continue;
                        oplog.createKrfAsync();
                    }
                    this.parent.scheduleCompaction();
                }
                long endRegionInit = System.currentTimeMillis();
                logger.info("recovery region initialization took {} ms", (Object)(endRegionInit - startRegionInit));
            }
        }
        return byteCount;
    }

    private boolean recoverValuesSync() {
        return this.parent.RECOVER_VALUES_SYNC;
    }

    private boolean recoverValues() {
        return this.parent.RECOVER_VALUES;
    }

    private void setFirstChild(TreeSet<Oplog> oplogSet, boolean force) {
        if (this.parent.isOffline() && !this.parent.isOfflineCompacting() && !this.parent.isOfflineModify()) {
            return;
        }
        if (!oplogSet.isEmpty()) {
            Oplog first = oplogSet.first();
            DirectoryHolder dh = first.getDirectoryHolder();
            this.dirCounter = dh.getArrayIndex();
            ++this.dirCounter;
            this.dirCounter %= this.parent.dirLength;
        }
        if (force || this.maxRecoveredOplogId > 0L) {
            this.setChild(new Oplog(this.maxRecoveredOplogId + 1L, this, this.getNextDir()));
        }
    }

    private void initOplogEntryId() {
        this.oplogEntryId.set(0L);
    }

    private void updateOplogEntryId(long v) {
        long curVal;
        do {
            if ((curVal = this.oplogEntryId.get()) < v) continue;
            return;
        } while (!this.oplogEntryId.compareAndSet(curVal, v));
    }

    long getOplogEntryId() {
        this.parent.initializeIfNeeded();
        return this.oplogEntryId.get();
    }

    long newOplogEntryId() {
        return this.oplogEntryId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryHolder getNextDir(long minAvailableSpace, boolean checkForWarning) {
        if (minAvailableSpace < this.parent.getMaxOplogSizeInBytes() && !DiskStoreImpl.SET_IGNORE_PREALLOCATE) {
            minAvailableSpace = this.parent.getMaxOplogSizeInBytes();
        }
        DirectoryHolder selectedHolder = null;
        DirectoryHolder[] directoryHolderArray = this.parent.getDirectoryHolders();
        synchronized (directoryHolderArray) {
            for (int i = 0; i < this.parent.dirLength; ++i) {
                DirectoryHolder dirHolder = this.parent.directories[this.dirCounter];
                ++this.dirCounter;
                this.dirCounter %= this.parent.dirLength;
                if (dirHolder.getAvailableSpace() < minAvailableSpace) continue;
                if (checkForWarning && !this.parent.isDirectoryUsageNormal(dirHolder)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignoring directory {} due to insufficient disk space", (Object)dirHolder);
                    continue;
                }
                selectedHolder = dirHolder;
                break;
            }
            if (selectedHolder == null) {
                if (checkForWarning) {
                    return this.getNextDir(minAvailableSpace, false);
                }
                if (this.parent.isCompactionEnabled()) {
                    selectedHolder = this.parent.directories[this.dirCounter];
                    ++this.dirCounter;
                    this.dirCounter %= this.parent.dirLength;
                    if (selectedHolder.getAvailableSpace() < minAvailableSpace) {
                        logger.warn("Even though the configured directory size limit has been exceeded a new oplog will be created because compaction is enabled. The configured limit is {}. The current space used in the directory by this disk store is {}.", (Object)selectedHolder.getUsedSpace(), (Object)selectedHolder.getCapacity());
                    }
                } else {
                    throw new DiskAccessException("Disk is full and compaction is disabled. No space can be created", this.parent);
                }
            }
        }
        return selectedHolder;
    }

    DirectoryHolder getNextDir() {
        return this.getNextDir(1024L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDrf(Oplog oplog) {
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            this.drfOnlyOplogs.put(oplog.getOplogId(), oplog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDrf(Oplog oplog) {
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            this.drfOnlyOplogs.remove(oplog.getOplogId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOldestExistingOplog(long id) {
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            for (long otherId : this.getOplogIdToOplog().keySet()) {
                if (id <= otherId) continue;
                return false;
            }
            for (long otherId : this.inactiveOplogs.keySet()) {
                if (id <= otherId) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyOldestReadyToCompact() {
        Object object;
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            if (this.drfOnlyOplogs.isEmpty()) {
                return;
            }
        }
        Oplog oldestLiveOplog = this.getOldestLiveOplog();
        ArrayList<Oplog> toDestroy = new ArrayList<Oplog>();
        if (oldestLiveOplog == null) {
            object = this.getOplogIdToOplog();
            synchronized (object) {
                toDestroy.addAll(this.drfOnlyOplogs.values());
            }
        }
        object = this.getOplogIdToOplog();
        synchronized (object) {
            for (Oplog oplog : this.drfOnlyOplogs.values()) {
                if (oplog.getOplogId() >= oldestLiveOplog.getOplogId()) continue;
                toDestroy.add(oplog);
            }
        }
        for (Oplog oplog : toDestroy) {
            oplog.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Oplog getOldestLiveOplog() {
        Oplog result = null;
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            for (Oplog oplog : this.getOplogIdToOplog().values()) {
                if (result != null && oplog.getOplogId() >= result.getOplogId()) continue;
                result = oplog;
            }
            for (Oplog oplog : this.inactiveOplogs.values()) {
                if (result != null && oplog.getOplogId() >= result.getOplogId()) continue;
                result = oplog;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inactiveAccessed(Oplog oplog) {
        Long key = oplog.getOplogId();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            this.inactiveOplogs.get(key);
        }
    }

    void inactiveReopened(Oplog oplog) {
        this.addInactive(oplog, true);
    }

    void addInactive(Oplog oplog) {
        this.addInactive(oplog, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInactive(Oplog oplog, boolean reopen) {
        Long key = oplog.getOplogId();
        ArrayList<Oplog> openlist = null;
        Object object = this.getOplogIdToOplog();
        synchronized (object) {
            boolean isInactive = true;
            if (reopen) {
                isInactive = this.inactiveOplogs.get(key) != null;
            } else {
                this.inactiveOplogs.put(key, oplog);
            }
            if ((reopen && isInactive || oplog.isRAFOpen()) && this.inactiveOpenCount.incrementAndGet() > DiskStoreImpl.MAX_OPEN_INACTIVE_OPLOGS) {
                openlist = new ArrayList<Oplog>();
                for (Oplog inactiveOplog : this.inactiveOplogs.values()) {
                    if (!inactiveOplog.isRAFOpen()) continue;
                    openlist.add(inactiveOplog);
                }
            }
        }
        if (openlist != null) {
            Oplog openOplog;
            object = openlist.iterator();
            while (object.hasNext() && (!(openOplog = (Oplog)object.next()).closeRAF() || this.inactiveOpenCount.decrementAndGet() > DiskStoreImpl.MAX_OPEN_INACTIVE_OPLOGS)) {
            }
        }
        if (!reopen) {
            this.parent.getStats().incInactiveOplogs(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(DiskRegion diskRegion, RegionVersionVector<DiskStoreID> regionVersionVector) {
        ArrayList<Oplog> oplogsToClear = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            oplogsToClear.addAll(this.getOplogIdToOplog().values());
            oplogsToClear.addAll(this.inactiveOplogs.values());
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToClear.add(child);
            }
        }
        for (Oplog oplog : oplogsToClear) {
            oplog.clear(diskRegion, regionVersionVector);
        }
        if (regionVersionVector != null) {
            this.parent.getDiskInitFile().clearRegion(diskRegion, regionVersionVector);
        } else {
            long clearedOplogEntryId = this.getOplogEntryId();
            this.parent.getDiskInitFile().clearRegion((DiskRegionView)diskRegion, clearedOplogEntryId);
        }
    }

    public RuntimeException close() {
        RuntimeException firstRuntimeException;
        block8: {
            firstRuntimeException = null;
            try {
                this.closeOtherOplogs();
            }
            catch (RuntimeException e) {
                firstRuntimeException = e;
            }
            if (this.child != null) {
                block7: {
                    try {
                        this.child.finishKrf();
                    }
                    catch (RuntimeException e) {
                        if (firstRuntimeException == null) break block7;
                        firstRuntimeException = e;
                    }
                }
                try {
                    this.child.close();
                }
                catch (RuntimeException e) {
                    if (firstRuntimeException == null) break block8;
                    firstRuntimeException = e;
                }
            }
        }
        return firstRuntimeException;
    }

    private void closeOtherOplogs() {
        Oplog[] oplogs = this.getAllOplogs();
        for (int i = 1; i < oplogs.length; ++i) {
            oplogs[i].finishKrf();
            oplogs[i].close();
            this.removeOplog(oplogs[i].getOplogId());
        }
    }

    Oplog removeOplog(long id) {
        return this.removeOplog(id, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Oplog removeOplog(long id, boolean deleting, Oplog olgToAddToDrfOnly) {
        Oplog oplog;
        boolean drfOnly = false;
        boolean inactive = false;
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            Long key = id;
            oplog = this.getOplogIdToOplog().remove(key);
            if (oplog == null) {
                oplog = this.inactiveOplogs.remove(key);
                if (oplog != null) {
                    if (oplog.isRAFOpen()) {
                        this.inactiveOpenCount.decrementAndGet();
                    }
                    inactive = true;
                } else {
                    oplog = this.drfOnlyOplogs.remove(key);
                    if (oplog != null) {
                        drfOnly = true;
                    }
                }
            }
            if (olgToAddToDrfOnly != null) {
                this.addDrf(olgToAddToDrfOnly);
            }
        }
        if (oplog != null) {
            if (!drfOnly) {
                if (inactive) {
                    this.parent.getStats().incInactiveOplogs(-1);
                } else {
                    this.parent.getStats().incCompactableOplogs(-1);
                }
            }
            if (!deleting && !oplog.isOplogEmpty()) {
                this.parent.undeletedOplogSize.addAndGet(oplog.getOplogSize());
            }
        }
        return oplog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicClose(DiskRegion dr) {
        ArrayList<Oplog> oplogsToClose = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            oplogsToClose.addAll(this.getOplogIdToOplog().values());
            oplogsToClose.addAll(this.inactiveOplogs.values());
            oplogsToClose.addAll(this.drfOnlyOplogs.values());
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToClose.add(child);
            }
        }
        for (Oplog oplog : oplogsToClose) {
            oplog.close(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForClose() {
        ArrayList<Oplog> oplogsToPrepare = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            oplogsToPrepare.addAll(this.getOplogIdToOplog().values());
            oplogsToPrepare.addAll(this.inactiveOplogs.values());
        }
        boolean childPreparedForClose = false;
        long childOplogId = this.getChild() == null ? -1L : this.getChild().oplogId;
        for (Oplog oplog : oplogsToPrepare) {
            oplog.prepareForClose();
            if (childOplogId == -1L || oplog.oplogId != childOplogId) continue;
            childPreparedForClose = true;
        }
        if (!childPreparedForClose && this.getChild() != null) {
            this.getChild().prepareForClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicDestroy(DiskRegion diskRegion) {
        ArrayList<Oplog> oplogsToDestroy = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            oplogsToDestroy.addAll(this.getOplogIdToOplog().values());
            oplogsToDestroy.addAll(this.inactiveOplogs.values());
            oplogsToDestroy.addAll(this.drfOnlyOplogs.values());
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToDestroy.add(child);
            }
        }
        for (Oplog oplog : oplogsToDestroy) {
            oplog.destroy(diskRegion);
        }
    }

    void destroyAllOplogs() {
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            oplog.destroy();
            this.removeOplog(oplog.getOplogId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getCompactableOplogs(List<CompactableOplog> compactableOplogs, int max) {
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            for (Oplog oplog : this.getOplogIdToOplog().values()) {
                if (compactableOplogs.size() >= max) {
                    return;
                }
                if (!oplog.needsCompaction()) continue;
                compactableOplogs.add(oplog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleForRecovery(DiskRecoveryStore diskRecoveryStore) {
        DiskRegionView diskRegionView = diskRecoveryStore.getDiskRegionView();
        if (diskRegionView.isRecreated() && (diskRegionView.getMyPersistentID() != null || diskRegionView.getMyInitializingID() != null)) {
            Map<Long, DiskRecoveryStore> map = this.pendingRecoveryMap;
            synchronized (map) {
                this.pendingRecoveryMap.put(diskRegionView.getId(), diskRecoveryStore);
            }
        }
    }

    DiskRecoveryStore getCurrentlyRecovering(long drId) {
        return this.currentRecoveryMap.get(drId);
    }

    void initChild() {
        if (this.getChild() == null) {
            this.setFirstChild(this.getSortedOplogs(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offlineCompact() {
        if (this.getChild() != null) {
            this.getChild().krfClose();
            if (this.getChild().isOplogEmpty()) {
                this.getChild().destroy();
            }
        }
        ArrayList<Oplog> oplogsToDestroy = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.getOplogIdToOplog();
        synchronized (map) {
            for (Oplog oplog : this.getOplogIdToOplog().values()) {
                if (!oplog.isDrfOnly()) continue;
                oplogsToDestroy.add(oplog);
            }
        }
        for (Oplog oplog : oplogsToDestroy) {
            oplog.destroy();
        }
        this.destroyOldestReadyToCompact();
    }

    public DiskStoreImpl getParent() {
        return this.parent;
    }

    void updateDiskRegion(AbstractDiskRegion diskRegion) {
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            oplog.updateDiskRegion(diskRegion);
        }
    }

    void flushChild() {
        Oplog oplog = this.getChild();
        if (oplog != null) {
            oplog.flushAll();
        }
    }

    public String getPrefix() {
        return OplogType.BACKUP.getPrefix();
    }

    void crfCreate(long oplogId) {
        this.getParent().getDiskInitFile().crfCreate(oplogId);
    }

    void drfCreate(long oplogId) {
        this.getParent().getDiskInitFile().drfCreate(oplogId);
    }

    void crfDelete(long oplogId) {
        this.getParent().getDiskInitFile().crfDelete(oplogId);
    }

    void drfDelete(long oplogId) {
        this.getParent().getDiskInitFile().drfDelete(oplogId);
    }

    boolean couldHaveKrf() {
        return this.getParent().couldHaveKrf();
    }

    public boolean isCompactionPossible() {
        return this.getParent().isCompactionPossible();
    }

    Map<Long, Oplog> getOplogIdToOplog() {
        return this.oplogIdToOplog;
    }

    AtomicBoolean getAlreadyRecoveredOnce() {
        return this.alreadyRecoveredOnce;
    }

    @VisibleForTesting
    Map<Long, DiskRecoveryStore> getPendingRecoveryMap() {
        return this.pendingRecoveryMap;
    }
}

