/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.function.BiFunction;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionFunctionStreamingMessage;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegionFunctionStreamingMessage msg;
    private final DistributionManager dm;
    private final PartitionedRegion pr;
    private final long time;
    private final boolean forwardExceptions;
    private final ResultCollector rc;
    private final ServerToClientFunctionResultSender serverSender;
    private boolean localLastResultReceived = false;
    private final boolean onlyLocal;
    private final boolean onlyRemote;
    private boolean completelyDoneFromRemote = false;
    private final Function function;
    private boolean enableOrderedResultStreming;
    private final int[] bucketArray;
    private BucketMovedException bme;
    private BiFunction<String, InternalDistributedSystem, FunctionStats> functionStatsFunctionProvider;

    public KnownVersion getClientVersion() {
        if (this.serverSender != null && this.serverSender.sc != null) {
            return this.serverSender.sc.getClientVersion();
        }
        return null;
    }

    public PartitionedRegionFunctionResultSender(DistributionManager dm, PartitionedRegion pr, long time, PartitionedRegionFunctionStreamingMessage msg, Function function, int[] bucketArray) {
        this(dm, pr, time, null, null, false, false, false, function, bucketArray, msg, (x, y) -> FunctionStatsManager.getFunctionStats((String)x, (InternalDistributedSystem)y));
    }

    public PartitionedRegionFunctionResultSender(DistributionManager dm, PartitionedRegion partitionedRegion, long time, ResultCollector rc, ServerToClientFunctionResultSender sender, boolean onlyLocal, boolean onlyRemote, boolean forwardExceptions, Function function, int[] bucketArray) {
        this(dm, partitionedRegion, time, rc, sender, onlyLocal, onlyRemote, forwardExceptions, function, bucketArray, null, (x, y) -> FunctionStatsManager.getFunctionStats((String)x, (InternalDistributedSystem)y));
    }

    PartitionedRegionFunctionResultSender(DistributionManager dm, PartitionedRegion partitionedRegion, long time, ResultCollector rc, ServerToClientFunctionResultSender sender, boolean onlyLocal, boolean onlyRemote, boolean forwardExceptions, Function function, int[] bucketArray, PartitionedRegionFunctionStreamingMessage msg, BiFunction functionStatsFunctionProvider) {
        this.dm = dm;
        this.pr = partitionedRegion;
        this.time = time;
        this.rc = rc;
        this.msg = msg;
        this.serverSender = sender;
        this.onlyLocal = onlyLocal;
        this.onlyRemote = onlyRemote;
        this.forwardExceptions = forwardExceptions;
        this.function = function;
        this.bucketArray = bucketArray;
        this.functionStatsFunctionProvider = functionStatsFunctionProvider;
    }

    private void checkForBucketMovement(Object oneResult) {
        if (!(this.forwardExceptions && oneResult instanceof Throwable || this.pr.getDataStore().areAllBucketsHosted(this.bucketArray))) {
            this.bme = new BucketMovedException("Bucket migrated to another node. Please retry.");
            if (this.function.isHA()) {
                throw this.bme;
            }
        }
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        if (this.serverSender != null) {
            if (this.localLastResultReceived) {
                return;
            }
            if (this.onlyLocal) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    this.clientSend(oneResult, this.dm.getDistributionManagerId());
                    this.lastClientSend(this.dm.getDistributionManagerId(), this.bme);
                } else {
                    this.lastClientSend(this.dm.getDistributionManagerId(), oneResult);
                }
                this.rc.endResults();
                this.localLastResultReceived = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
            }
        } else {
            if (this.msg != null) {
                this.checkForBucketMovement(oneResult);
                try {
                    if (this.bme != null) {
                        this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, false, this.enableOrderedResultStreming);
                        throw this.bme;
                    }
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                if (this.localLastResultReceived) {
                    return;
                }
                if (this.onlyLocal) {
                    this.checkForBucketMovement(oneResult);
                    if (this.bme != null) {
                        this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                        this.rc.addResult(this.dm.getDistributionManagerId(), this.bme);
                    } else {
                        this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                    }
                    this.rc.endResults();
                    this.localLastResultReceived = true;
                } else {
                    this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
                }
                this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private synchronized void lastResult(Object oneResult, ResultCollector collector, boolean lastRemoteResult, boolean lastLocalResult, DistributedMember memberID) {
        boolean completedLocal;
        boolean bl = completedLocal = lastLocalResult || this.localLastResultReceived;
        if (lastRemoteResult) {
            this.completelyDoneFromRemote = true;
        }
        if (this.serverSender != null) {
            if (this.completelyDoneFromRemote && completedLocal) {
                if (lastLocalResult) {
                    this.checkForBucketMovement(oneResult);
                    if (this.bme != null) {
                        this.clientSend(oneResult, this.dm.getDistributionManagerId());
                        this.lastClientSend(this.dm.getDistributionManagerId(), this.bme);
                    } else {
                        this.lastClientSend(memberID, oneResult);
                    }
                } else {
                    this.lastClientSend(memberID, oneResult);
                }
                collector.endResults();
            } else if (lastLocalResult) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    this.clientSend(oneResult, memberID);
                    this.clientSend(this.bme, memberID);
                } else {
                    this.clientSend(oneResult, memberID);
                }
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else if (this.completelyDoneFromRemote && completedLocal) {
            if (lastLocalResult) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    collector.addResult(memberID, oneResult);
                    collector.addResult(memberID, this.bme);
                } else {
                    collector.addResult(memberID, oneResult);
                }
            } else {
                collector.addResult(memberID, oneResult);
            }
            collector.endResults();
        } else if (lastLocalResult) {
            this.checkForBucketMovement(oneResult);
            if (this.bme != null) {
                collector.addResult(memberID, oneResult);
                collector.addResult(memberID, this.bme);
            } else {
                collector.addResult(memberID, oneResult);
            }
        } else {
            collector.addResult(memberID, oneResult);
        }
        if (lastLocalResult) {
            this.localLastResultReceived = true;
        }
    }

    public synchronized void lastResult(Object oneResult, boolean completelyDoneFromRemote, ResultCollector reply, DistributedMember memberID) {
        logger.debug("PartitionedRegionFunctionResultSender Sending lastResult {}", oneResult);
        if (this.serverSender != null) {
            if (completelyDoneFromRemote) {
                if (this.onlyRemote) {
                    this.lastClientSend(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else {
            if (completelyDoneFromRemote) {
                if (this.onlyRemote) {
                    reply.addResult(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                reply.addResult(memberID, oneResult);
            }
            if (this.dm == null) {
                FunctionStatsManager.getFunctionStats(this.function.getId()).incResultsReceived();
            } else {
                this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
        }
        if (this.dm == null) {
            FunctionStatsManager.getFunctionStats(this.function.getId()).incResultsReturned();
        } else {
            this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public void sendResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(String.format("Cannot %s result as the Function#hasResult() is false", "send"));
        }
        if (this.serverSender != null) {
            logger.debug("PartitionedRegionFunctionResultSender sending result from local node to client {}", oneResult);
            this.clientSend(oneResult, this.dm.getDistributionManagerId());
        } else {
            if (this.msg != null) {
                try {
                    logger.debug("PartitionedRegionFunctionResultSender sending result from remote node {}", oneResult);
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                logger.debug("PartitionedRegionFunctionResultSender adding result to ResultCollector on local node {}", oneResult);
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            this.functionStatsFunctionProvider.apply(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private void clientSend(Object oneResult, DistributedMember memberID) {
        try {
            this.serverSender.sendResult(oneResult, memberID);
        }
        catch (FunctionException e) {
            logger.warn("Exception when sending result to client", (Throwable)e);
            this.setException(e);
        }
    }

    private void lastClientSend(DistributedMember memberID, Object lastResult) {
        try {
            this.serverSender.lastResult(lastResult, memberID);
        }
        catch (FunctionException e) {
            logger.warn("Exception when sending last result to client", (Throwable)e);
            this.setException(e);
        }
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultReceived = true;
    }

    @Override
    public void setException(Throwable exception) {
        if (this.serverSender != null) {
            this.serverSender.setException(exception);
        } else {
            ((LocalResultCollector)this.rc).setException(exception);
            logger.info("Unexpected exception during function execution on local node Partitioned Region", exception);
        }
        this.rc.endResults();
        this.localLastResultReceived = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultReceived;
    }
}

