/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BecomePrimaryBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean isRebalance;

    public BecomePrimaryBucketMessage() {
    }

    private BecomePrimaryBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, boolean isRebalance) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.isRebalance = isRebalance;
    }

    public static BecomePrimaryBucketResponse send(InternalDistributedMember recipient, PartitionedRegion pr, int bid, boolean isRebalance) {
        Assert.assertTrue(recipient != null, "BecomePrimaryBucketMessage NULL recipient");
        BecomePrimaryBucketResponse response = new BecomePrimaryBucketResponse(pr.getSystem(), recipient, pr);
        BecomePrimaryBucketMessage msg = new BecomePrimaryBucketMessage(recipient, pr.getPRId(), response, bid, isRebalance);
        msg.setTransactionDistributed(pr.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = pr.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        pr.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public BecomePrimaryBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        byte responseCode = 0;
        BucketAdvisor bucketAdvisor = region.getRegionAdvisor().getBucketAdvisor(this.bucketId);
        if (bucketAdvisor.isHosting() && bucketAdvisor.becomePrimary(this.isRebalance)) {
            responseCode = 1;
        }
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        BecomePrimaryBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, null, responseCode);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; isRebalance=").append(this.isRebalance);
    }

    public int getDSFID() {
        return 132;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
        this.isRebalance = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.isRebalance);
    }

    public static class BecomePrimaryBucketResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean success;

        public BecomePrimaryBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof BecomePrimaryBucketReplyMessage) {
                    BecomePrimaryBucketReplyMessage reply = (BecomePrimaryBucketReplyMessage)msg;
                    this.success = reply.isSuccess();
                    if (reply.isSuccess()) {
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "BecomePrimaryBucketResponse return OK");
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "BecomePrimaryBucketResponse return NOT_PRIMARY");
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected synchronized void processException(ReplyException ex) {
            logger.debug("BecomePrimaryBucketMessage ignoring exception {}", (Object)ex.getMessage(), (Object)ex);
        }

        public boolean waitForResponse() {
            this.waitForRepliesUninterruptibly();
            return this.success;
        }
    }

    public static class BecomePrimaryBucketReplyMessage
    extends ReplyMessage {
        static final byte NOT_SECONDARY = 0;
        static final byte OK = 1;
        private byte responseCode = 0;

        public BecomePrimaryBucketReplyMessage() {
        }

        public BecomePrimaryBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
        }

        private BecomePrimaryBucketReplyMessage(int processorId, ReplyException re, byte responseCode) {
            this.setProcessorId(processorId);
            this.setException(re);
            this.responseCode = responseCode;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, ReplyException re, byte responseCode) {
            Assert.assertTrue(recipient != null, "BecomePrimaryBucketReplyMessage NULL recipient");
            BecomePrimaryBucketReplyMessage m = new BecomePrimaryBucketReplyMessage(processorId, re, responseCode);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean isSuccess() {
            return this.responseCode == 1;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "BecomePrimaryBucketReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "BecomePrimaryBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "processed {}", (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeByte(this.responseCode);
        }

        @Override
        public int getDSFID() {
            return 133;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.responseCode = in.readByte();
        }

        @Override
        public String toString() {
            return "BecomePrimaryBucketReplyMessage processorid=" + this.processorId + " reply to sender " + this.getSender() + " returning responseCode=" + this.responseCode;
        }
    }
}

