/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.ClientSession;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.InvalidateOperationContext;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.cache.operations.RegionClearOperationContext;
import org.apache.geode.cache.operations.RegionCreateOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxyStats;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestList;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientMarkerMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientUserAuths;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.cache.tier.sockets.MessageDispatcher;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AccessControl;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;
import org.jetbrains.annotations.NotNull;

public class CacheClientProxy
implements ClientSession {
    private static final Logger logger = LogService.getLogger();
    private static final Logger secureLogger = LogService.getLogger((String)"org.apache.geode.security");
    @Immutable
    @VisibleForTesting
    protected static final CacheClientProxyStatsFactory DEFAULT_CACHECLIENTPROXYSTATSFACTORY = (statisticsFactory, proxyId, remoteHostAddress) -> new CacheClientProxyStats(statisticsFactory, "id_" + proxyId.getDistributedMember().getId() + "_at_" + remoteHostAddress);
    @Immutable
    private static final MessageDispatcherFactory DEFAULT_MESSAGEDISPATCHERFACTORY = MessageDispatcher::new;
    protected Socket _socket;
    private final AtomicBoolean _socketClosed = new AtomicBoolean();
    protected ByteBuffer _commBuffer;
    protected String _remoteHostAddress;
    protected volatile boolean isMarkedForRemoval = false;
    protected final Object isMarkedForRemovalLock = new Object();
    protected ClientProxyMembershipID proxyID;
    protected final InternalCache _cache;
    protected final ClientInterestList[] cils = new ClientInterestList[2];
    protected volatile MessageDispatcher _messageDispatcher;
    protected final CacheClientProxyStats _statistics;
    protected final AtomicReference<SystemTimer.SystemTimerTask> _durableExpirationTask = new AtomicReference();
    protected SystemTimer durableTimer;
    protected volatile boolean _isPaused = true;
    private volatile boolean connected = false;
    private boolean markerEnqueued = false;
    protected static final int MAXIMUM_SHUTDOWN_PEEKS = Integer.getInteger("gemfire.MAXIMUM_SHUTDOWN_PEEKS", 50);
    protected final int _maximumMessageCount;
    protected final int _messageTimeToLive;
    protected final CacheClientNotifier _cacheClientNotifier;
    @MutableForTesting
    public static boolean isSlowStartForTesting = false;
    private boolean isPrimary;
    protected byte clientConflation = 0;
    boolean keepalive = false;
    private AccessControl postAuthzCallback;
    private Subject subject;
    private ClientUserAuths clientUserAuths;
    private final Object clientUserAuthsLock = new Object();
    private KnownVersion clientVersion;
    private final Map<String, Integer> regionsWithEmptyDataPolicy = new HashMap<String, Integer>();
    @MutableForTesting
    public static boolean AFTER_MESSAGE_CREATION_FLAG = false;
    protected static final boolean NOTIFY_REGION_ON_INTEREST = Boolean.getBoolean("gemfire.updateAccessTimeOnClientInterest");
    private final long _acceptorId;
    private final boolean notifyBySubscription;
    private final AtomicInteger pingCounter = new AtomicInteger();
    private Date creationDate;
    private boolean drainLocked = false;
    private final Object drainLock = new Object();
    private int numDrainsInProgress = 0;
    private final Object drainsInProgressLock = new Object();
    private final SecurityService securityService;
    private final StatisticsClock statisticsClock;
    private final MessageDispatcherFactory messageDispatcherFactory;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    @MutableForTesting
    public static TestHook testHook;

    protected CacheClientProxy(CacheClientNotifier ccn, Socket socket, ClientProxyMembershipID proxyID, boolean isPrimary, byte clientConflation, KnownVersion clientVersion, long acceptorId, boolean notifyBySubscription, SecurityService securityService, Subject subject, StatisticsClock statisticsClock) throws CacheException {
        this(ccn.getCache(), ccn, socket, proxyID, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription, securityService, subject, statisticsClock, ccn.getCache().getInternalDistributedSystem().getStatisticsManager(), DEFAULT_CACHECLIENTPROXYSTATSFACTORY, DEFAULT_MESSAGEDISPATCHERFACTORY, ServerConnection.getClientUserAuths(proxyID));
    }

    @VisibleForTesting
    protected CacheClientProxy(InternalCache cache, CacheClientNotifier ccn, Socket socket, ClientProxyMembershipID proxyID, boolean isPrimary, byte clientConflation, KnownVersion clientVersion, long acceptorId, boolean notifyBySubscription, SecurityService securityService, Subject subject, StatisticsClock statisticsClock, StatisticsFactory statisticsFactory, CacheClientProxyStatsFactory cacheClientProxyStatsFactory, MessageDispatcherFactory messageDispatcherFactory, ClientUserAuths clientUserAuths) throws CacheException {
        this.initializeTransientFields(socket, proxyID, isPrimary, clientConflation, clientVersion);
        this._cacheClientNotifier = ccn;
        this._cache = cache;
        this.securityService = securityService;
        this._maximumMessageCount = ccn.getMaximumMessageCount();
        this._messageTimeToLive = ccn.getMessageTimeToLive();
        this._acceptorId = acceptorId;
        this.notifyBySubscription = notifyBySubscription;
        this.statisticsClock = statisticsClock;
        this._statistics = cacheClientProxyStatsFactory.create(statisticsFactory, proxyID, this._remoteHostAddress);
        this.subject = subject;
        this.cils[0] = new ClientInterestList(this, this.proxyID);
        this.cils[1] = new ClientInterestList(this, this.getDurableId());
        this.postAuthzCallback = null;
        this._cacheClientNotifier.getAcceptorStats().incCurrentQueueConnections();
        this.creationDate = new Date();
        this.messageDispatcherFactory = messageDispatcherFactory;
        this.clientUserAuths = clientUserAuths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitializeClientAuths() {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            ClientUserAuths newClientAuth = ServerConnection.getClientUserAuths(this.proxyID);
            newClientAuth.fillPreviousCQAuth(this.clientUserAuths);
            this.clientUserAuths = newClientAuth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostAuthzCallback(AccessControl authzCallback) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.postAuthzCallback != null) {
                this.postAuthzCallback.close();
            }
            this.postAuthzCallback = authzCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubject(Subject subject) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            this.subject = subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject getSubject(String cqName) {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            return this.clientUserAuths.getSubject(cqName);
        }
    }

    public void setCQVsUserAuth(String cqName, long uniqueId, boolean isDurable) {
        this.clientUserAuths.setUserAuthAttributesForCq(cqName, uniqueId, isDurable);
    }

    private void initializeTransientFields(Socket socket, ClientProxyMembershipID pid, boolean ip, byte cc, KnownVersion vers) {
        this._socket = socket;
        this.proxyID = pid;
        this.connected = true;
        int bufSize = 1024;
        try {
            bufSize = this._socket.getSendBufferSize();
            if (bufSize < 1024) {
                bufSize = 1024;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this._commBuffer = ServerConnection.allocateCommBuffer(bufSize, socket);
        this._remoteHostAddress = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        this.isPrimary = ip;
        this.clientConflation = cc;
        this.clientVersion = vers;
    }

    public boolean isMarkerEnqueued() {
        return this.markerEnqueued;
    }

    public void setMarkerEnqueued(boolean bool) {
        this.markerEnqueued = bool;
    }

    public long getAcceptorId() {
        return this._acceptorId;
    }

    public boolean isNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyID;
    }

    protected boolean isMember(ClientProxyMembershipID memberId) {
        return this.proxyID.equals(memberId);
    }

    protected void setKeepAlive(boolean option) {
        this.keepalive = option;
    }

    protected Socket getSocket() {
        return this._socket;
    }

    public String getSocketHost() {
        return this._socket.getInetAddress().getHostAddress();
    }

    protected ByteBuffer getCommBuffer() {
        return this._commBuffer;
    }

    protected String getRemoteHostAddress() {
        return this._remoteHostAddress;
    }

    public int getRemotePort() {
        return this._socket.getPort();
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startRemoval() {
        boolean result;
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            result = this.isMarkedForRemoval;
            this.isMarkedForRemoval = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitRemoval() {
        boolean result;
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            result = this.isMarkedForRemoval;
            boolean interrupted = false;
            try {
                while (this.isMarkedForRemoval) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for CacheClientProxy removal: {}", (Object)this);
                    }
                    try {
                        this.isMarkedForRemovalLock.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this._cache.getCancelCriterion().checkCancelInProgress(e);
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoval() {
        Object object = this.isMarkedForRemovalLock;
        synchronized (object) {
            this.isMarkedForRemoval = false;
            this.isMarkedForRemovalLock.notifyAll();
        }
    }

    public InternalCache getCache() {
        return this._cache;
    }

    public Set<String> getInterestRegisteredRegions() {
        HashSet<String> regions = new HashSet<String>();
        for (ClientInterestList cil : this.cils) {
            if (cil.regions.isEmpty()) continue;
            regions.addAll(cil.regions);
        }
        return regions;
    }

    public CacheClientProxyStats getStatistics() {
        return this._statistics;
    }

    protected CacheClientNotifier getCacheClientNotifier() {
        return this._cacheClientNotifier;
    }

    public int getQueueSize() {
        return this._messageDispatcher == null ? 0 : this._messageDispatcher.getQueueSize();
    }

    public int getQueueSizeStat() {
        return this._messageDispatcher == null ? 0 : this._messageDispatcher.getQueueSizeStat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainInProgress() {
        Object object = this.drainsInProgressLock;
        synchronized (object) {
            return this.numDrainsInProgress > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockDrain() {
        Object object = this.drainsInProgressLock;
        synchronized (object) {
            if (!this.drainInProgress()) {
                Object object2 = this.drainLock;
                synchronized (object2) {
                    if (testHook != null) {
                        testHook.doTestHook("PRE_ACQUIRE_DRAIN_LOCK_UNDER_SYNC");
                    }
                    if (!this.drainLocked) {
                        this.drainLocked = true;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockDrain() {
        if (testHook != null) {
            testHook.doTestHook("PRE_RELEASE_DRAIN_LOCK");
        }
        Object object = this.drainLock;
        synchronized (object) {
            this.drainLocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeClientCq(String clientCQName) throws CqException {
        block18: {
            if (testHook != null) {
                testHook.doTestHook("PRE_DRAIN_IN_PROGRESS");
            }
            Object object = this.drainsInProgressLock;
            synchronized (object) {
                ++this.numDrainsInProgress;
            }
            if (testHook != null) {
                testHook.doTestHook("DRAIN_IN_PROGRESS_BEFORE_DRAIN_LOCK_CHECK");
            }
            try {
                String msg;
                if (this.drainLocked) {
                    msg = String.format("CacheClientProxy: Could not drain cq %s due to client proxy id %s reconnecting.", clientCQName, this.proxyID.getDurableId());
                    logger.info(msg);
                    throw new CqException(msg);
                }
                if (this.isPaused() && !this.isConnected()) {
                    CqService cqService = this.getCache().getCqService();
                    if (cqService == null) break block18;
                    InternalCqQuery cqToClose = cqService.getCq(cqService.constructServerCqName(clientCQName, this.proxyID));
                    if (cqToClose != null) {
                        cqService.closeCq(clientCQName, this.proxyID);
                        this._messageDispatcher.drainClientCqEvents(this.proxyID, cqToClose);
                        break block18;
                    }
                    String msg2 = String.format("CQ Not found, Failed to close the specified CQ %s", clientCQName);
                    logger.info(msg2);
                    throw new CqException(msg2);
                }
                msg = String.format("CacheClientProxy: Could not drain cq %s because client proxy id %s is connected.", clientCQName, this.proxyID.getDurableId());
                logger.info(msg);
                throw new CqException(msg);
            }
            finally {
                object = this.drainsInProgressLock;
                synchronized (object) {
                    --this.numDrainsInProgress;
                }
                if (testHook != null) {
                    testHook.doTestHook("DRAIN_COMPLETE");
                }
            }
        }
        return true;
    }

    protected boolean isAlive() {
        if (this._messageDispatcher == null) {
            return false;
        }
        return !this._messageDispatcher.isStopped();
    }

    public boolean isWaitingForReAuthentication() {
        if (this._messageDispatcher == null) {
            return false;
        }
        return this._messageDispatcher.isWaitingForReAuthentication();
    }

    public void notifyReAuthentication() {
        if (this._messageDispatcher == null) {
            return;
        }
        ExecutorService threadPool = this._cache.getDistributionManager().getExecutors().getWaitingThreadPool();
        threadPool.submit(() -> this._messageDispatcher.notifyReAuthentication());
    }

    public boolean isPaused() {
        return this._isPaused;
    }

    protected void setPaused(boolean isPaused) {
        this._isPaused = isPaused;
    }

    protected void close() {
        this.close(true, false);
    }

    protected boolean close(boolean checkQueue, boolean stoppedNormally) {
        boolean pauseDurable = this.isDurable() && (!stoppedNormally || this.getDurableKeepAlive() && stoppedNormally);
        boolean keepProxy = false;
        if (pauseDurable) {
            this.pauseDispatching();
            keepProxy = true;
        } else {
            this.terminateDispatching(checkQueue);
            this.closeTransientFields();
        }
        this.connected = false;
        try {
            if (!pauseDurable) {
                this.cleanClientAuths();
            }
        }
        catch (Exception ex) {
            logger.warn("{}", (Object)this, (Object)ex);
        }
        return keepProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanClientAuths() {
        Object object = this.clientUserAuthsLock;
        synchronized (object) {
            if (this.postAuthzCallback != null) {
                this.postAuthzCallback.close();
                this.postAuthzCallback = null;
            } else if (this.subject != null) {
                secureLogger.debug("CacheClientProxy.close, logging out {}. ", this.subject.getPrincipal());
                this.subject.logout();
                this.subject = null;
            } else if (this.clientUserAuths != null) {
                secureLogger.debug("CacheClientProxy.close, cleanup all client subjects. ");
                this.clientUserAuths.cleanup(true);
                this.clientUserAuths = null;
            }
        }
    }

    protected void pauseDispatching() {
        if (this._messageDispatcher == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pausing processing", (Object)this);
        }
        if (!this.testAndSetPaused(true) && this.isPrimary && this._messageDispatcher != Thread.currentThread()) {
            this._messageDispatcher.interrupt();
        }
        try {
            this.closeTransientFields();
        }
        finally {
            this.scheduleDurableExpirationTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAndSetPaused(boolean newValue) {
        Object object = this._messageDispatcher._pausedLock;
        synchronized (object) {
            if (this._isPaused != newValue) {
                this._isPaused = newValue;
                this._messageDispatcher._pausedLock.notifyAll();
                return !this._isPaused;
            }
            this._messageDispatcher._pausedLock.notifyAll();
            return this._isPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateDispatching(boolean checkQueue) {
        block19: {
            if (this._messageDispatcher == null) {
                return;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Terminating processing", (Object)this);
                }
                if (this._messageDispatcher == Thread.currentThread()) {
                    this._messageDispatcher.stopDispatching(checkQueue);
                    this.cils[0].clearClientInterestList();
                    this.cils[1].clearClientInterestList();
                    this.destroyRQ();
                    return;
                }
                if (!this.closing.compareAndSet(false, true)) {
                    return;
                }
                this.cils[0].clearClientInterestList();
                this.cils[1].clearClientInterestList();
                if (this.testAndSetPaused(false)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Paused but terminating processing", (Object)this);
                    }
                    this.cancelDurableExpirationTask(false);
                }
                boolean alreadyDestroyed = false;
                boolean gotInterrupt = Thread.interrupted();
                try {
                    this._messageDispatcher.stopDispatching(checkQueue);
                    gotInterrupt |= Thread.interrupted();
                    if (!this._messageDispatcher.isAlive()) break block19;
                    this.closeSocket();
                    this.destroyRQ();
                    alreadyDestroyed = true;
                    this._messageDispatcher.interrupt();
                    if (!this._messageDispatcher.isAlive()) break block19;
                    try {
                        this._messageDispatcher.join(1000L);
                    }
                    catch (InterruptedException ex) {
                        gotInterrupt = true;
                    }
                    if (this._messageDispatcher.isAlive()) {
                        logger.warn("{}: Could not stop message dispatcher thread.", (Object)this);
                    }
                }
                finally {
                    if (gotInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                    if (!alreadyDestroyed) {
                        this.destroyRQ();
                    }
                }
            }
            finally {
                this._statistics.close();
                this.closeTransientFields();
            }
        }
    }

    private boolean closeSocket() {
        String remoteHostAddress = this._remoteHostAddress;
        if (this._socketClosed.compareAndSet(false, true) && remoteHostAddress != null) {
            this._cacheClientNotifier.getSocketCloser().asyncClose(this._socket, remoteHostAddress, () -> {});
            this.getCacheClientNotifier().getAcceptorStats().decCurrentQueueConnections();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected void closeTransientFields() {
        if (!this.closeSocket()) {
            return;
        }
        this.releaseCommBuffer();
        String remoteHostAddress = this._remoteHostAddress;
        if (remoteHostAddress != null) {
            this._cacheClientNotifier.getSocketCloser().releaseResourcesForAddress(remoteHostAddress);
            this._remoteHostAddress = null;
        }
        try {
            this.cils[0].clearClientInterestList();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        this.closeNonDurableCqs();
    }

    private void releaseCommBuffer() {
        ByteBuffer bb = this._commBuffer;
        if (bb != null) {
            this._commBuffer = null;
            ServerConnection.releaseCommBuffer(bb);
        }
    }

    private void closeNonDurableCqs() {
        CqService cqService = this.getCache().getCqService();
        if (cqService != null) {
            try {
                cqService.closeNonDurableClientCqs(this.getProxyID());
            }
            catch (CqException ex) {
                logger.warn("CqException while closing non durable Cqs. {}", (Object)ex.getLocalizedMessage());
            }
        }
    }

    private void destroyRQ() {
        if (this._messageDispatcher == null) {
            return;
        }
        try {
            HARegionQueue rq = this._messageDispatcher._messageQueue;
            rq.destroy();
        }
        catch (CancelException | RegionDestroyedException rq) {
        }
        catch (Exception warning) {
            logger.warn(String.format("%s: Exception in closing the underlying HARegion of the HARegionQueue", this), (Throwable)warning);
        }
    }

    @Override
    public void registerInterestRegex(String regionName, String regex, boolean isDurable) {
        this.registerInterestRegex(regionName, regex, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regionName, String regex, boolean isDurable, boolean receiveValues) {
        if (!this.isPrimary) {
            throw new IllegalStateException("This process is not the primary server for the given client");
        }
        this.notifySecondariesAndClient(regionName, regex, InterestResultPolicy.NONE, isDurable, receiveValues, InterestType.REGULAR_EXPRESSION);
    }

    @Override
    public void registerInterest(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterest(regionName, keyOfInterest, policy, isDurable, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerInterest(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        if (keyOfInterest instanceof String && keyOfInterest.equals("ALL_KEYS")) {
            this.registerInterestRegex(regionName, ".*", isDurable, receiveValues);
            return;
        } else if (keyOfInterest instanceof List) {
            if (!this.isPrimary) throw new IllegalStateException("This process is not the primary server for the given client");
            this.notifySecondariesAndClient(regionName, keyOfInterest, policy, isDurable, receiveValues, InterestType.KEY);
            return;
        } else {
            if (!this.isPrimary) throw new IllegalStateException("This process is not the primary server for the given client");
            this.notifySecondariesAndClient(regionName, keyOfInterest, policy, isDurable, receiveValues, InterestType.KEY);
            if (policy != InterestResultPolicy.KEYS_VALUES) return;
            this.enqueueInitialValue(null, regionName, keyOfInterest);
        }
    }

    private void notifySecondariesAndClient(String regionName, Object keyOfInterest, InterestResultPolicy policy, boolean isDurable, boolean receiveValues, @NotNull InterestType interestType2) {
        ClientInterestMessageImpl message = new ClientInterestMessageImpl(new EventID(this._cache.getDistributedSystem()), regionName, keyOfInterest, interestType2, policy.getOrdinal(), isDurable, !receiveValues, 0);
        this.notifySecondariesOfInterestChange(message);
        if (keyOfInterest instanceof List) {
            this.registerClientInterestList(regionName, (List)keyOfInterest, isDurable, !receiveValues, true);
        } else {
            this.registerClientInterest(regionName, keyOfInterest, interestType2, isDurable, !receiveValues, true);
        }
        this.enqueueInterestRegistrationMessage(message);
    }

    private void enqueueInitialValue(ClientInterestMessageImpl clientInterestMessage, String regionName, Object keyOfInterest) {
        Get70 request = (Get70)Get70.getCommand();
        LocalRegion lr = (LocalRegion)this._cache.getRegion(regionName);
        Get70.Entry entry = request.getValueAndIsObject(lr, keyOfInterest, null, null);
        boolean isObject = entry.isObject;
        byte[] value = null;
        if (entry.value != null) {
            if (entry.value instanceof byte[]) {
                value = (byte[])entry.value;
            } else {
                try {
                    value = CacheServerHelper.serialize(entry.value);
                }
                catch (IOException e) {
                    logger.warn(String.format("The following exception occurred while attempting to serialize %s", entry.value), (Throwable)e);
                }
            }
            VersionTag<?> tag = entry.versionTag;
            EventID eventId = clientInterestMessage == null ? new EventID(this._cache.getDistributedSystem()) : new EventID(clientInterestMessage.getEventId(), 1);
            ClientUpdateMessageImpl updateMessage = new ClientUpdateMessageImpl(EnumListenerEvent.AFTER_CREATE, lr, keyOfInterest, value, null, isObject ? (byte)1 : 0, null, this.proxyID, eventId, tag);
            CacheClientNotifier.routeSingleClientMessage(updateMessage, this.proxyID);
        }
    }

    private void enqueueInterestRegistrationMessage(ClientInterestMessageImpl message) {
        this._messageDispatcher.enqueueMessage(message);
    }

    @Override
    public void unregisterInterestRegex(String regionName, String regex, boolean isDurable) {
        this.unregisterInterestRegex(regionName, regex, isDurable, true);
    }

    @Override
    public void unregisterInterestRegex(String regionName, String regex, boolean isDurable, boolean receiveValues) {
        if (!this.isPrimary) {
            throw new IllegalStateException("This process is not the primary server for the given client");
        }
        this.notifySecondariesAndClient(regionName, regex, isDurable, receiveValues, InterestType.REGULAR_EXPRESSION);
    }

    @Override
    public void unregisterInterest(String regionName, Object keyOfInterest, boolean isDurable) {
        this.unregisterInterest(regionName, keyOfInterest, isDurable, true);
    }

    @Override
    public void unregisterInterest(String regionName, Object keyOfInterest, boolean isDurable, boolean receiveValues) {
        if (keyOfInterest instanceof String && keyOfInterest.equals("ALL_KEYS")) {
            this.unregisterInterestRegex(regionName, ".*", isDurable, receiveValues);
        } else if (this.isPrimary) {
            this.notifySecondariesAndClient(regionName, keyOfInterest, isDurable, receiveValues, InterestType.KEY);
        } else {
            throw new IllegalStateException("This process is not the primary server for the given client");
        }
    }

    private void notifySecondariesAndClient(String regionName, Object keyOfInterest, boolean isDurable, boolean receiveValues, @NotNull InterestType interestType2) {
        ClientInterestMessageImpl message = new ClientInterestMessageImpl(new EventID(this._cache.getDistributedSystem()), regionName, keyOfInterest, interestType2, 0, isDurable, !receiveValues, 1);
        this.notifySecondariesOfInterestChange(message);
        if (keyOfInterest instanceof List) {
            this.unregisterClientInterest(regionName, (List)keyOfInterest, false);
        } else {
            this.unregisterClientInterest(regionName, keyOfInterest, interestType2, false);
        }
        this.enqueueInterestRegistrationMessage(message);
    }

    protected void notifySecondariesOfInterestChange(ClientInterestMessageImpl message) {
        if (logger.isDebugEnabled()) {
            StringBuilder subBuffer = new StringBuilder();
            if (message.isRegister()) {
                subBuffer.append("register ").append(message.getIsDurable() ? "" : "non-").append("durable interest in ");
            } else {
                subBuffer.append("unregister interest in ");
            }
            String buffer = this + ": Notifying secondary proxies to " + subBuffer + message.getRegionName() + "->" + message.getKeyOfInterest() + "->" + InterestType.getString(message.getInterestType());
            logger.debug(buffer);
        }
        this._cacheClientNotifier.deliverInterestChange(this.proxyID, message);
    }

    protected void registerClientInterest(String regionName, Object keyOfInterest, @NotNull InterestType interestType2, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean flushState) {
        HARegionQueue queue;
        ClientInterestList cil = this.cils[RegisterInterestTracker.getInterestLookupIndex(isDurable, false)];
        cil.registerClientInterest(regionName, keyOfInterest, interestType2, sendUpdatesAsInvalidates);
        if (flushState) {
            this.flushForInterestRegistration(regionName, this._cache.getDistributedSystem().getDistributedMember());
        }
        if ((queue = this.getHARegionQueue()) != null) {
            queue.setHasRegisteredInterest(true);
        }
    }

    public void flushForInterestRegistration(String regionName, DistributedMember target) {
        Region r = this._cache.getRegion(regionName);
        if (r == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to find region '{}' to flush for interest registration", (Object)regionName);
            }
        } else if (r.getAttributes().getScope().isDistributed()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing region '{}' for interest registration", (Object)regionName);
            }
            CacheDistributionAdvisee cd = (CacheDistributionAdvisee)((Object)r);
            StateFlushOperation sfo = r instanceof PartitionedRegion ? new StateFlushOperation(this._cache.getInternalDistributedSystem().getDistributionManager()) : new StateFlushOperation((DistributedRegion)r);
            try {
                CacheDistributionAdvisor.InitialImageAdvice advice = cd.getCacheDistributionAdvisor().adviseInitialImage(null);
                HashSet<InternalDistributedMember> recips = new HashSet<InternalDistributedMember>(advice.getReplicates());
                recips.addAll(advice.getUninitialized());
                recips.addAll(advice.getEmpties());
                recips.addAll(advice.getPreloaded());
                recips.addAll(advice.getOthers());
                sfo.flush(recips, target, 75, true);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void unregisterClientInterest(String regionName, Object keyOfInterest, @NotNull InterestType interestType2, boolean isClosing) {
        if (!isClosing || !this.getDurableKeepAlive()) {
            this.cils[1].unregisterClientInterest(regionName, keyOfInterest, interestType2);
        }
        this.cils[0].unregisterClientInterest(regionName, keyOfInterest, interestType2);
    }

    protected void registerClientInterestList(String regionName, List<?> keysOfInterest, boolean isDurable, boolean sendUpdatesAsInvalidates, boolean flushState) {
        ClientInterestList cil = this.cils[RegisterInterestTracker.getInterestLookupIndex(isDurable, false)];
        cil.registerClientInterestList(regionName, keysOfInterest, sendUpdatesAsInvalidates);
        if (this.getHARegionQueue() != null) {
            if (flushState) {
                this.flushForInterestRegistration(regionName, this._cache.getDistributedSystem().getDistributedMember());
            }
            this.getHARegionQueue().setHasRegisteredInterest(true);
        }
    }

    protected void unregisterClientInterest(String regionName, List<?> keysOfInterest, boolean isClosing) {
        if (!isClosing || !this.getDurableKeepAlive()) {
            this.cils[1].unregisterClientInterestList(regionName, keysOfInterest);
        }
        this.cils[0].unregisterClientInterestList(regionName, keysOfInterest);
    }

    protected void processInterestMessage(ClientInterestMessageImpl message) {
        @NotNull InterestType interestType2 = message.getInterestType();
        String regionName = message.getRegionName();
        Object key = message.getKeyOfInterest();
        if (message.isRegister()) {
            if (key instanceof List) {
                this.registerClientInterestList(regionName, (List)key, message.getIsDurable(), message.getForUpdatesAsInvalidates(), true);
            } else {
                this.registerClientInterest(regionName, key, interestType2, message.getIsDurable(), message.getForUpdatesAsInvalidates(), true);
            }
            if (logger.isDebugEnabled()) {
                String buffer = this + ": Interest listener registered " + (message.getIsDurable() ? "" : "non-") + "durable interest in " + message.getRegionName() + "->" + message.getKeyOfInterest() + "->" + InterestType.getString(message.getInterestType());
                logger.debug(buffer);
            }
        } else {
            if (key instanceof List) {
                this.unregisterClientInterest(regionName, (List)key, false);
            } else {
                this.unregisterClientInterest(regionName, key, interestType2, false);
            }
            if (logger.isDebugEnabled()) {
                String buffer = this + ": Interest listener unregistered interest in " + message.getRegionName() + "->" + message.getKeyOfInterest() + "->" + InterestType.getString(message.getInterestType());
                logger.debug(buffer);
            }
        }
        this.enqueueInterestRegistrationMessage(message);
        if (message.isRegister() && message.getInterestType() == InterestType.KEY && !(key instanceof List) && InterestResultPolicy.fromOrdinal(message.getInterestResultPolicy()) == InterestResultPolicy.KEYS_VALUES) {
            this.enqueueInitialValue(message, regionName, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postDeliverAuthCheckPassed(ClientUpdateMessage clientMessage) {
        if (AcceptorImpl.isAuthenticationRequired() && this.postAuthzCallback == null && AcceptorImpl.isPostAuthzCallbackPresent()) {
            ClientUpdateMessageImpl cumi = (ClientUpdateMessageImpl)clientMessage;
            ClientUpdateMessageImpl.CqNameToOp clientCq = cumi.getClientCq(this.proxyID);
            if (clientCq != null && !clientCq.isEmpty()) {
                String[] regionNameHolder;
                OperationContext opctxt;
                if (logger.isDebugEnabled()) {
                    logger.debug("CCP clientCq size before processing auth {}", (Object)clientCq.size());
                }
                if ((opctxt = this.getOperationContext(clientMessage, regionNameHolder = new String[1])) == null) {
                    logger.warn("{}: Not Adding message to queue: {} because the operation context object could not be obtained for this client message.", (Object)this, (Object)clientMessage);
                    return false;
                }
                String[] cqNames = clientCq.getNames();
                if (logger.isDebugEnabled()) {
                    logger.debug("CCP clientCq names array size {}", (Object)cqNames.length);
                }
                for (String cqName : cqNames) {
                    try {
                        AuthorizeRequestPP postAuthCallback;
                        if (logger.isDebugEnabled()) {
                            logger.debug("CCP clientCq name {}", (Object)cqName);
                        }
                        boolean isAuthorized = false;
                        if (this.proxyID.isDurable() && this.getDurableKeepAlive() && this._isPaused) {
                            Object object = this.clientUserAuthsLock;
                            synchronized (object) {
                                postAuthCallback = this.clientUserAuths.getUserAuthAttributes(cqName).getPostAuthzRequest();
                                if (logger.isDebugEnabled() && postAuthCallback == null) {
                                    logger.debug("CCP clientCq post callback is null");
                                }
                                if (postAuthCallback != null && postAuthCallback.getPostAuthzCallback().authorizeOperation(regionNameHolder[0], opctxt)) {
                                    isAuthorized = true;
                                }
                            }
                        } else {
                            UserAuthAttributes userAuthAttributes = this.clientUserAuths.getUserAuthAttributes(cqName);
                            postAuthCallback = userAuthAttributes.getPostAuthzRequest();
                            if (postAuthCallback == null && logger.isDebugEnabled()) {
                                logger.debug("CCP clientCq post callback is null");
                            }
                            if (postAuthCallback != null && postAuthCallback.getPostAuthzCallback().authorizeOperation(regionNameHolder[0], opctxt)) {
                                isAuthorized = true;
                            }
                        }
                        if (!isAuthorized) {
                            logger.warn("{}: Not Adding CQ message to queue {} because authorization failed.", (Object)this, (Object)clientMessage);
                            clientCq.delete(cqName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("CCP clientCq size after processing auth {}", (Object)clientCq.size());
                }
                if (!clientMessage.hasCqs(this.proxyID)) {
                    this._statistics.incMessagesNotQueuedNotInterested();
                    if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
                        logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "{}: Not adding message to queue. It is not interested in this region and key: {}", (Object)this, (Object)clientMessage);
                    }
                    return false;
                }
            }
        } else if (this.postAuthzCallback != null) {
            boolean isAuthorize;
            String[] regionNameHolder = new String[1];
            OperationContext opctxt = this.getOperationContext(clientMessage, regionNameHolder);
            if (opctxt == null) {
                logger.warn("{}: Not Adding message to queue: {} because the operation context object could not be obtained for this client message.", (Object)this, (Object)clientMessage);
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Invoking authorizeOperation for message: {}", (Object)this, (Object)clientMessage);
            }
            if (this.proxyID.isDurable() && this.getDurableKeepAlive() && this._isPaused) {
                Object object = this.clientUserAuthsLock;
                synchronized (object) {
                    isAuthorize = this.postAuthzCallback.authorizeOperation(regionNameHolder[0], opctxt);
                }
            } else {
                isAuthorize = this.postAuthzCallback.authorizeOperation(regionNameHolder[0], opctxt);
            }
            if (!isAuthorize) {
                logger.warn("{}: Not Adding message to queue {} because authorization failed.", (Object)this, (Object)clientMessage);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverMessage(Conflatable conflatable) {
        ClientUpdateMessage clientMessage = conflatable instanceof HAEventWrapper ? ((HAEventWrapper)conflatable).getClientUpdateMessage() : (ClientUpdateMessage)conflatable;
        this._statistics.incMessagesReceived();
        if (this.subject != null) {
            ThreadState state = this.securityService.bindSubject(this.subject);
            try {
                if (this.securityService.needPostProcess()) {
                    Object oldValue = clientMessage.getValue();
                    Object newValue = this.securityService.postProcess(clientMessage.getRegionName(), clientMessage.getKeyOfInterest(), oldValue, clientMessage.valueIsObject());
                    clientMessage.setLatestValue(newValue);
                }
            }
            finally {
                if (state != null) {
                    state.clear();
                }
            }
        }
        if (clientMessage.needsNoAuthorizationCheck() || this.postDeliverAuthCheckPassed(clientMessage)) {
            if (this._messageDispatcher != null) {
                this._messageDispatcher.enqueueMessage(conflatable);
            } else {
                this._statistics.incMessagesFailedQueued();
                if (logger.isDebugEnabled()) {
                    logger.debug("Message was not added to the queue. Message dispatcher was null for proxy: " + this + ". Event ID hash code: " + conflatable.hashCode() + "; System ID hash code: " + System.identityHashCode(conflatable) + "; Conflatable details: " + conflatable);
                }
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Message was not added to the queue. Event ID hash code: " + conflatable.hashCode() + "; System ID hash code: " + System.identityHashCode(conflatable) + "; Conflatable details: " + conflatable);
            }
            this._statistics.incMessagesFailedQueued();
        }
    }

    protected void sendMessageDirectly(ClientMessage message) {
        if (logger.isDebugEnabled()) {
            logger.debug("About to send message directly to {}", (Object)this);
        }
        if (this._messageDispatcher != null && this._socket != null && !this._socket.isClosed()) {
            this._messageDispatcher.sendMessageDirectly(message);
            if (logger.isDebugEnabled()) {
                logger.debug("Sent message directly to {}", (Object)this);
            }
        } else {
            this.resetPingCounter();
            if (logger.isDebugEnabled()) {
                logger.debug("Skipped sending message directly to {}", (Object)this);
            }
        }
    }

    private OperationContext getOperationContext(ClientMessage cmsg, String[] regionNameHolder) {
        String regionName;
        ClientUpdateMessageImpl cmsgimpl = (ClientUpdateMessageImpl)cmsg;
        OperationContext opctxt = null;
        regionNameHolder[0] = regionName = cmsgimpl.getRegionName();
        if (cmsgimpl.isCreate()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionCreateOperationContext(true);
            } else {
                PutOperationContext tmp = new PutOperationContext(cmsgimpl.getKeyOfInterest(), cmsgimpl.getValue(), cmsgimpl.valueIsObject(), 1, true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isUpdate()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionCreateOperationContext(true);
            } else {
                PutOperationContext tmp = new PutOperationContext(cmsgimpl.getKeyOfInterest(), cmsgimpl.getValue(), cmsgimpl.valueIsObject(), 2, true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isDestroy()) {
            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                regionNameHolder[0] = (String)cmsgimpl.getKeyOfInterest();
                opctxt = new RegionDestroyOperationContext(true);
            } else {
                DestroyOperationContext tmp = new DestroyOperationContext(cmsgimpl.getKeyOfInterest(), true);
                tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
                opctxt = tmp;
            }
        } else if (cmsgimpl.isDestroyRegion()) {
            opctxt = new RegionDestroyOperationContext(true);
        } else if (cmsgimpl.isInvalidate()) {
            InvalidateOperationContext tmp = new InvalidateOperationContext(cmsgimpl.getKeyOfInterest(), true);
            tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
            opctxt = tmp;
        } else if (cmsgimpl.isClearRegion()) {
            RegionClearOperationContext tmp = new RegionClearOperationContext(true);
            tmp.setCallbackArg(cmsgimpl.getCallbackArgument());
            opctxt = tmp;
        }
        return opctxt;
    }

    public void initializeMessageDispatcher() throws CacheException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initializing message dispatcher with capacity of {} entries", (Object)this, (Object)this._maximumMessageCount);
            }
            String name = "Client Message Dispatcher for " + this.getProxyID().getDistributedMember() + (this.isDurable() ? " (" + this.getDurableId() + ")" : "");
            this._messageDispatcher = this.createMessageDispatcher(name);
        }
        catch (Exception ex) {
            this._statistics.close();
            throw ex;
        }
    }

    MessageDispatcher createMessageDispatcher(String name) {
        return this.messageDispatcherFactory.create(this, name, this.statisticsClock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startOrResumeMessageDispatcher(boolean sendMarkerDirectly) {
        if (this.isPrimary) {
            EventID eventId = new EventID(this._cache.getDistributedSystem());
            ClientMarkerMessageImpl clientMarkerMessage = new ClientMarkerMessageImpl(eventId);
            if (sendMarkerDirectly) {
                this.sendMessageDirectly(clientMarkerMessage);
            } else {
                this._messageDispatcher.enqueueMarker(clientMarkerMessage);
            }
            this._messageDispatcher._messageQueue.setPrimary(true);
            Object object = this._messageDispatcher._pausedLock;
            synchronized (object) {
                if (this.isPaused()) {
                    this.setPaused(false);
                    if (this._messageDispatcher.isStopped()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Starting dispatcher", (Object)this);
                        }
                        this._messageDispatcher.start();
                    } else {
                        this._messageDispatcher.initializeTransients();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Resuming dispatcher", (Object)this);
                        }
                        this._messageDispatcher.resumeDispatching();
                    }
                } else if (!this._messageDispatcher.isAlive()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Starting dispatcher", (Object)this);
                    }
                    this._messageDispatcher.start();
                }
            }
        }
    }

    protected boolean hasRegisteredInterested() {
        return this.cils[0].hasInterest() || this.cils[1].hasInterest();
    }

    public String toString() {
        return "CacheClientProxy[" + this.proxyID + "; port=" + this._socket.getPort() + "; primary=" + this.isPrimary + "; version=" + this.clientVersion + "]";
    }

    public String getState() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CacheClientProxy[").append(this.proxyID).append("; port=").append(this._socket.getPort()).append("; primary=").append(this.isPrimary).append("; version=").append(this.clientVersion).append("; paused=").append(this.isPaused()).append("; alive=").append(this.isAlive()).append("; connected=").append(this.isConnected()).append("; isMarkedForRemoval=").append(this.isMarkedForRemoval).append("]");
        if (this._messageDispatcher != null && this.isAlive()) {
            buffer.append((CharSequence)LogWriterImpl.getStackTrace((Thread)((Object)this._messageDispatcher)));
        }
        return buffer.toString();
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    protected void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public HARegionQueue getHARegionQueue() {
        if (this._messageDispatcher != null) {
            return this._messageDispatcher._messageQueue;
        }
        return null;
    }

    protected void reinitialize(Socket socket, ClientProxyMembershipID proxyId, boolean ip, byte cc, KnownVersion ver) {
        this.initializeTransientFields(socket, proxyId, ip, cc, ver);
        this.getCacheClientNotifier().getAcceptorStats().incCurrentQueueConnections();
        this.cancelDurableExpirationTask(true);
        this._messageDispatcher._messageQueue.setPrimary(ip);
        this._messageDispatcher._messageQueue.setClientConflation(cc);
        this._socketClosed.compareAndSet(true, false);
        this.reinitializeClientAuths();
        this.creationDate = new Date();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Has been reinitialized", (Object)this);
        }
    }

    protected boolean isDurable() {
        return this.getProxyID().isDurable();
    }

    protected String getDurableId() {
        return this.getProxyID().getDurableId();
    }

    protected int getDurableTimeout() {
        return this.getProxyID().getDurableTimeout();
    }

    private boolean getDurableKeepAlive() {
        return this.keepalive;
    }

    protected String getHARegionName() {
        return this.getProxyID().getHARegionName();
    }

    public Region<?, ?> getHARegion() {
        return this._messageDispatcher._messageQueue.getRegion();
    }

    public KnownVersion getVersion() {
        return this.clientVersion;
    }

    @VisibleForTesting
    protected Subject getSubject() {
        return this.subject;
    }

    protected void scheduleDurableExpirationTask() {
        SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

            @Override
            public void run2() {
                CacheClientProxy.this._durableExpirationTask.compareAndSet(this, null);
                logger.warn("{} : The expiration task has fired, so this proxy is being terminated.", (Object)CacheClientProxy.this);
                CacheClientProxy.this.getCacheClientNotifier().removeClientProxy(CacheClientProxy.this);
                CacheClientProxy.this.getCacheClientNotifier().durableClientTimedOut(CacheClientProxy.this.proxyID);
                CacheClientProxy.this.terminateDispatching(false);
                CacheClientProxy.this._cacheClientNotifier.statistics.incQueueDroppedCount();
                SystemTimer.SystemTimerTask task = CacheClientProxy.this._durableExpirationTask.getAndSet(null);
                if (task != null && task.cancel()) {
                    CacheClientProxy.this._cache.purgeCCPTimer();
                }
            }
        };
        if (this._durableExpirationTask.compareAndSet(null, task)) {
            this._cache.getCCPTimer().schedule(task, (long)this.getDurableTimeout() * 1000L);
        }
    }

    protected void cancelDurableExpirationTask(boolean logMessage) {
        SystemTimer.SystemTimerTask task = this._durableExpirationTask.getAndSet(null);
        if (task != null) {
            if (logMessage) {
                logger.info("{}: Cancelling expiration task since the client has reconnected.", (Object)this);
            }
            if (task.cancel()) {
                this._cache.purgeCCPTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            this._statistics.incCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decCqCount() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            this._statistics.decCqCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOneCq() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount() == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNoCq() {
        CacheClientProxy cacheClientProxy = this;
        synchronized (cacheClientProxy) {
            return this._statistics.getCqCount() == 0;
        }
    }

    public Map<String, Integer> getRegionsWithEmptyDataPolicy() {
        return this.regionsWithEmptyDataPolicy;
    }

    public int incrementAndGetPingCounter() {
        return this.pingCounter.incrementAndGet();
    }

    public void resetPingCounter() {
        this.pingCounter.set(0);
    }

    public long getUpTime() {
        return (System.currentTimeMillis() - this.creationDate.getTime()) / 1000L;
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface MessageDispatcherFactory {
        public MessageDispatcher create(CacheClientProxy var1, String var2, StatisticsClock var3);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface CacheClientProxyStatsFactory {
        public CacheClientProxyStats create(StatisticsFactory var1, ClientProxyMembershipID var2, String var3);
    }

    public static interface TestHook {
        public void doTestHook(String var1);
    }
}

