/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import java.util.Properties;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.Encryptor;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.EncryptorImpl;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeFactory;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataInputStream;
import org.apache.geode.internal.serialization.VersionedDataOutputStream;
import org.apache.geode.internal.serialization.VersionedDataStream;
import org.apache.geode.internal.serialization.VersioningIO;
import org.apache.geode.pdx.internal.PeerTypeRegistration;
import org.apache.geode.security.AuthenticationRequiredException;

public class ServerSideHandshakeImpl
extends Handshake
implements ServerSideHandshake {
    @Immutable
    private static final KnownVersion currentServerVersion = ServerSideHandshakeFactory.currentServerVersion;
    private final KnownVersion clientVersion;
    private final byte replyCode;

    @Override
    protected byte getReplyCode() {
        return this.replyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSideHandshakeImpl(Socket sock, int timeout, DistributedSystem sys, KnownVersion clientVersion, CommunicationMode communicationMode, SecurityService securityService) throws IOException, AuthenticationRequiredException {
        this.clientVersion = clientVersion;
        this.system = sys;
        this.securityService = securityService;
        this.encryptor = new EncryptorImpl(sys.getSecurityLogWriter());
        int soTimeout = -1;
        try {
            soTimeout = sock.getSoTimeout();
            sock.setSoTimeout(timeout);
            InputStream inputStream = sock.getInputStream();
            int valRead = inputStream.read();
            if (valRead == -1) {
                throw new EOFException("HandShake: EOF reached before client code could be read");
            }
            this.replyCode = (byte)valRead;
            if (this.replyCode != 59) {
                throw new IOException("HandShake reply code is not ok");
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(sock.getOutputStream());
                this.clientReadTimeout = dataInputStream.readInt();
                if (clientVersion.isOlderThan((Version)KnownVersion.CURRENT)) {
                    dataInputStream = new VersionedDataInputStream((InputStream)dataInputStream, clientVersion);
                    dataOutputStream = new VersionedDataOutputStream((OutputStream)dataOutputStream, clientVersion);
                }
                this.id = ClientProxyMembershipID.readCanonicalized(dataInputStream);
                this.setOverrides(new byte[]{dataInputStream.readByte()});
                this.credentials = communicationMode.isWAN() ? ServerSideHandshakeImpl.readCredentials(dataInputStream, dataOutputStream, sys, this.securityService) : this.readCredential(dataInputStream, dataOutputStream, sys);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("ClientProxyMembershipID class could not be found while deserializing the object");
            }
        }
        finally {
            if (soTimeout != -1) {
                try {
                    sock.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public KnownVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public KnownVersion getVersion() {
        return this.clientVersion;
    }

    @Override
    public void handshakeWithClient(OutputStream out, InputStream in, byte endpointType, int queueSize, CommunicationMode communicationMode, Principal principal) throws IOException {
        DataInputStream dis;
        DataOutputStream dos = new DataOutputStream(out);
        if (this.clientVersion.isOlderThan((Version)KnownVersion.CURRENT)) {
            dis = new VersionedDataInputStream(in, this.clientVersion);
            dos = new VersionedDataOutputStream((OutputStream)dos, this.clientVersion);
        } else {
            dis = new DataInputStream(in);
        }
        if (communicationMode.isWAN() && principal != null) {
            dos.writeByte(65);
        } else {
            dos.writeByte(59);
        }
        if (communicationMode.isWAN()) {
            VersioningIO.writeOrdinal((DataOutput)dos, (short)currentServerVersion.ordinal(), (boolean)true);
        }
        dos.writeByte(endpointType);
        dos.writeInt(queueSize);
        DistributedMember member = this.system.getDistributedMember();
        KnownVersion v = KnownVersion.CURRENT;
        if (dos instanceof VersionedDataStream) {
            v = ((VersionedDataStream)dos).getVersion();
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(v);
        DataSerializer.writeObject(member, hdos);
        DataSerializer.writeByteArray(hdos.toByteArray(), dos);
        hdos.close();
        dos.writeUTF("");
        if (!communicationMode.isWAN()) {
            dos.writeBoolean(((InternalDistributedSystem)this.system).getConfig().getDeltaPropagation());
        }
        if (communicationMode.isWAN()) {
            if (principal != null) {
                this.sendCredentialsForWan(dos, dis);
            }
            dos.writeByte(((InternalDistributedSystem)this.system).getDistributionManager().getDistributedSystemId());
            int pdxSize = PeerTypeRegistration.getPdxRegistrySize();
            dos.writeInt(pdxSize);
        }
        dos.flush();
    }

    @Override
    @Deprecated
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    private void sendCredentialsForWan(OutputStream out, InputStream in) {
        try {
            Properties wanCredentials = this.getCredentials(this.id.getDistributedMember());
            DataOutputStream dos = new DataOutputStream(out);
            DataInputStream dis = new DataInputStream(in);
            this.writeCredentials(dos, dis, wanCredentials, false, this.system.getDistributedMember());
        }
        catch (Exception e) {
            this.system.getSecurityLogWriter().severe(String.format("An exception was thrown while sending wan credentials: %s", e.getLocalizedMessage()));
        }
    }

    @Override
    public int getClientReadTimeout() {
        return this.clientReadTimeout;
    }
}

