/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.meters;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.meters.DoubleStatisticBinding;
import org.apache.geode.internal.statistics.meters.LongStatisticBinding;
import org.apache.geode.internal.statistics.meters.StatisticBinding;

public class LegacyStatCounter
implements Counter {
    private final Counter underlyingCounter;
    private final StatisticBinding statisticBinding;

    private LegacyStatCounter(Counter underlyingCounter, StatisticBinding statisticBinding) {
        this.underlyingCounter = underlyingCounter;
        this.statisticBinding = statisticBinding;
    }

    public void increment(double amount) {
        this.underlyingCounter.increment(amount);
        this.statisticBinding.add(amount);
    }

    public double count() {
        return this.statisticBinding.doubleValue();
    }

    public Meter.Id getId() {
        return this.underlyingCounter.getId();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final Counter.Builder builder;
        private StatisticBinding statisticBinding = StatisticBinding.noOp();

        private Builder(String name) {
            this.builder = Counter.builder((String)name);
        }

        public Builder doubleStatistic(Statistics statistics, int statId) {
            this.statisticBinding = new DoubleStatisticBinding(statistics, statId);
            return this;
        }

        public Builder longStatistic(Statistics statistics, int statId) {
            this.statisticBinding = new LongStatisticBinding(statistics, statId);
            return this;
        }

        public Builder baseUnit(String unit) {
            this.builder.baseUnit(unit);
            return this;
        }

        public Builder description(String description) {
            this.builder.description(description);
            return this;
        }

        public Builder tag(String name, String value) {
            this.builder.tag(name, value);
            return this;
        }

        public Builder tags(String ... tags) {
            this.builder.tags(tags);
            return this;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.builder.tags(tags);
            return this;
        }

        public LegacyStatCounter register(MeterRegistry registry) {
            Counter underlyingCounter = this.builder.register(registry);
            return new LegacyStatCounter(underlyingCounter, this.statisticBinding);
        }
    }
}

