/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.geode.internal.GeodeVersion;
import org.apache.geode.internal.version.ComponentVersion;
import org.apache.geode.internal.version.DistributionVersion;
import org.jetbrains.annotations.NotNull;

public class ProductVersionUtil {
    public static final String line = "----------------------------------------";

    @NotNull
    public static DistributionVersion getDistributionVersion() {
        ServiceLoader<DistributionVersion> loader = ServiceLoader.load(DistributionVersion.class);
        Iterator<DistributionVersion> loaderIter = loader.iterator();
        if (loaderIter.hasNext()) {
            return loaderIter.next();
        }
        return new GeodeVersion();
    }

    @NotNull
    public static Iterable<ComponentVersion> getComponentVersions() {
        return ServiceLoader.load(ComponentVersion.class);
    }

    @NotNull
    public static <T extends Appendable> T appendFullVersion(@NotNull T appendable) throws IOException {
        for (ComponentVersion version : ProductVersionUtil.getComponentVersions()) {
            appendable.append(line).append(System.lineSeparator()).append(version.getName()).append(System.lineSeparator()).append(line).append(System.lineSeparator());
            for (Map.Entry entry : version.getDetails().entrySet()) {
                appendable.append((CharSequence)entry.getKey()).append(": ").append((CharSequence)entry.getValue()).append(System.lineSeparator());
            }
        }
        return appendable;
    }

    @NotNull
    public static String getFullVersion() {
        try {
            return ProductVersionUtil.appendFullVersion(new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

