/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.internal.LoggingProviderLoader;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.geode.logging.internal.spi.LogConfigListener;
import org.apache.geode.logging.internal.spi.LogConfigSupplier;
import org.apache.geode.logging.internal.spi.LogLevelUpdateOccurs;
import org.apache.geode.logging.internal.spi.LogLevelUpdateScope;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.geode.logging.internal.spi.LoggingProvider;

public class Configuration
implements LogConfigListener {
    @VisibleForTesting
    public static final int DEFAULT_LOGWRITER_LEVEL = LogWriterLevel.CONFIG.intLevel();
    public static final String STARTUP_CONFIGURATION = "Startup Configuration: ";
    public static final String CLI_CONFIG = "/log4j2-cli.xml";
    public static final String LOG_LEVEL_UPDATE_OCCURS_PROPERTY = "geode.LOG_LEVEL_UPDATE_OCCURS";
    static final String LOG_LEVEL_UPDATE_SCOPE_PROPERTY = "geode.LOG_LEVEL_UPDATE_SCOPE";
    private final LogLevelUpdateOccurs logLevelUpdateOccurs;
    private final LogLevelUpdateScope logLevelUpdateScope;
    private final LoggingProvider loggingProvider;
    private LogConfigSupplier logConfigSupplier;

    public static Configuration create() {
        return Configuration.create(Configuration.getLogLevelUpdateOccurs(), Configuration.getLogLevelUpdateScope(), new LoggingProviderLoader().load());
    }

    @VisibleForTesting
    public static Configuration create(LoggingProvider loggingProvider) {
        return Configuration.create(Configuration.getLogLevelUpdateOccurs(), Configuration.getLogLevelUpdateScope(), loggingProvider);
    }

    @VisibleForTesting
    public static Configuration create(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope) {
        return Configuration.create(logLevelUpdateOccurs, logLevelUpdateScope, new LoggingProviderLoader().load());
    }

    @VisibleForTesting
    public static Configuration create(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope, LoggingProvider loggingProvider) {
        return new Configuration(logLevelUpdateOccurs, logLevelUpdateScope, loggingProvider);
    }

    private Configuration(LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope, LoggingProvider loggingProvider) {
        this.logLevelUpdateOccurs = logLevelUpdateOccurs;
        this.logLevelUpdateScope = logLevelUpdateScope;
        this.loggingProvider = loggingProvider;
    }

    static LogLevelUpdateOccurs getLogLevelUpdateOccurs() {
        try {
            return LogLevelUpdateOccurs.valueOf(System.getProperty(LOG_LEVEL_UPDATE_OCCURS_PROPERTY, LogLevelUpdateOccurs.ONLY_WHEN_USING_DEFAULT_CONFIG.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return LogLevelUpdateOccurs.ONLY_WHEN_USING_DEFAULT_CONFIG;
        }
    }

    static LogLevelUpdateScope getLogLevelUpdateScope() {
        try {
            return LogLevelUpdateScope.valueOf(System.getProperty(LOG_LEVEL_UPDATE_SCOPE_PROPERTY, LogLevelUpdateScope.GEODE_LOGGERS.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return LogLevelUpdateScope.GEODE_LOGGERS;
        }
    }

    public synchronized void initialize(LogConfigSupplier logConfigSupplier) {
        if (logConfigSupplier == null) {
            throw new IllegalArgumentException("LogConfigSupplier must not be null");
        }
        this.logConfigSupplier = logConfigSupplier;
        logConfigSupplier.addLogConfigListener(this);
        this.configChanged();
    }

    @Override
    public synchronized void configChanged() {
        if (this.logConfigSupplier == null) {
            throw new IllegalStateException("LogConfigSupplier must not be null");
        }
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        this.loggingProvider.configure(logConfig, this.logLevelUpdateOccurs, this.logLevelUpdateScope);
    }

    public synchronized void shutdown() {
        if (this.logConfigSupplier != null) {
            this.logConfigSupplier.removeLogConfigListener(this);
            this.logConfigSupplier = null;
        }
        this.loggingProvider.cleanup();
    }

    String getConfigurationInfo() {
        return this.loggingProvider.getConfigurationInfo();
    }

    void enableLoggingToStandardOutput() {
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        if (logConfig.getLogFile().exists()) {
            this.loggingProvider.enableLoggingToStandardOutput();
        }
    }

    void disableLoggingToStandardOutputIfLoggingToFile() {
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        if (logConfig.getLogFile().exists()) {
            this.loggingProvider.disableLoggingToStandardOutput();
        }
    }

    @VisibleForTesting
    synchronized LogConfigSupplier getLogConfigSupplier() {
        return this.logConfigSupplier;
    }
}

