/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class GCStatsMonitor
extends MBeanStatsMonitor {
    private final Map<Long, Number> collections = new HashMap<Long, Number>();
    private final Map<Long, Number> collectionTime = new HashMap<Long, Number>();

    public GCStatsMonitor(String name) {
        this(name, new ValueMonitor());
    }

    @VisibleForTesting
    public GCStatsMonitor(String name, ValueMonitor valueMonitor) {
        super(name, valueMonitor);
    }

    long getCollections() {
        return this.collections.values().stream().mapToLong(Number::longValue).sum();
    }

    long getCollectionTime() {
        return this.collectionTime.values().stream().mapToLong(Number::longValue).sum();
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        StatisticDescriptor[] descriptors;
        this.monitor.addListener(this);
        this.monitor.addStatistics(stats);
        for (StatisticDescriptor d : descriptors = stats.getType().getStatistics()) {
            String name = d.getName();
            Number value = stats.get(d);
            if (value == null) continue;
            if (name.equals("collections")) {
                this.collections.put(stats.getUniqueId(), value);
                continue;
            }
            if (!name.equals("collectionTime")) continue;
            this.collectionTime.put(stats.getUniqueId(), value);
        }
    }

    @Override
    public Number getStatistic(String statName) {
        if (statName.equals("collections")) {
            return this.getCollections();
        }
        if (statName.equals("collectionTime")) {
            return this.getCollectionTime();
        }
        return 0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            if (name.equals("collections")) {
                this.collections.put(statId.getStatistics().getUniqueId(), value);
                continue;
            }
            if (!name.equals("collectionTime")) continue;
            this.collectionTime.put(statId.getStatistics().getUniqueId(), value);
        }
    }
}

