/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.mutators;

import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.PdxType;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.internal.configuration.converters.PdxConverter;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;

public class PdxManager
extends CacheConfigurationManager<Pdx> {
    private final PdxConverter pdxConverter = new PdxConverter();

    public PdxManager(ConfigurationPersistenceService service) {
        super(service);
    }

    @Override
    public void add(Pdx config, CacheConfig existing) {
        existing.setPdx((PdxType)this.pdxConverter.fromConfigObject(config));
    }

    @Override
    public void update(Pdx config, CacheConfig existing) {
        existing.setPdx((PdxType)this.pdxConverter.fromConfigObject(config));
    }

    @Override
    public void delete(Pdx config, CacheConfig existing) {
        existing.setPdx(null);
    }

    @Override
    public List<Pdx> list(Pdx filterConfig, CacheConfig existing) {
        Pdx configuration = (Pdx)this.pdxConverter.fromXmlObject(existing.getPdx());
        if (configuration == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(configuration);
    }

    @Override
    public Pdx get(Pdx config, CacheConfig existing) {
        return (Pdx)this.pdxConverter.fromXmlObject(existing.getPdx());
    }
}

