/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationClassLoader {
    private static File testDir = GenericTestUtils.getTestDir("appclassloader");

    @Before
    public void setUp() {
        FileUtil.fullyDelete((File)testDir);
        testDir.mkdirs();
    }

    @Test
    public void testConstructUrlsFromClasspath() throws Exception {
        File file = new File(testDir, "file");
        Assert.assertTrue((String)"Create file", (boolean)file.createNewFile());
        File dir = new File(testDir, "dir");
        Assert.assertTrue((String)"Make dir", (boolean)dir.mkdir());
        File jarsDir = new File(testDir, "jarsdir");
        Assert.assertTrue((String)"Make jarsDir", (boolean)jarsDir.mkdir());
        File nonJarFile = new File(jarsDir, "nonjar");
        Assert.assertTrue((String)"Create non-jar file", (boolean)nonJarFile.createNewFile());
        File jarFile = new File(jarsDir, "a.jar");
        Assert.assertTrue((String)"Create jar file", (boolean)jarFile.createNewFile());
        File nofile = new File(testDir, "nofile");
        StringBuilder cp = new StringBuilder();
        cp.append(file.getAbsolutePath()).append(File.pathSeparator).append(dir.getAbsolutePath()).append(File.pathSeparator).append(jarsDir.getAbsolutePath() + "/*").append(File.pathSeparator).append(nofile.getAbsolutePath()).append(File.pathSeparator).append(nofile.getAbsolutePath() + "/*").append(File.pathSeparator);
        URL[] urls = ApplicationClassLoader.constructUrlsFromClasspath((String)cp.toString());
        Assert.assertEquals((long)3L, (long)urls.length);
        Assert.assertEquals((Object)file.toURI().toURL(), (Object)urls[0]);
        Assert.assertEquals((Object)dir.toURI().toURL(), (Object)urls[1]);
        Assert.assertEquals((Object)jarFile.toURI().toURL(), (Object)urls[2]);
    }

    @Test
    public void testIsSystemClass() {
        this.testIsSystemClassInternal("");
    }

    @Test
    public void testIsSystemNestedClass() {
        this.testIsSystemClassInternal("$Klass");
    }

    private void testIsSystemClassInternal(String nestedClass) {
        Assert.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), null));
        Assert.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.Foo")));
        Assert.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("/org.example.Foo" + nestedClass), this.classes("org.example.Foo")));
        Assert.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.")));
        Assert.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("net.example.Foo" + nestedClass), this.classes("org.example.,net.example.")));
        Assert.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("-org.example.Foo,org.example.")));
        Assert.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Bar" + nestedClass), this.classes("-org.example.Foo.,org.example.")));
        Assert.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.,-org.example.Foo")));
        Assert.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.Foo,-org.example.Foo")));
    }

    private List<String> classes(String classes) {
        return Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)classes));
    }

    @Test
    public void testGetResource() throws IOException {
        URL testJar = this.makeTestJar().toURI().toURL();
        ClassLoader currentClassLoader = this.getClass().getClassLoader();
        ApplicationClassLoader appClassloader = new ApplicationClassLoader(new URL[]{testJar}, currentClassLoader, null);
        Assert.assertNull((String)"Resource should be null for current classloader", (Object)currentClassLoader.getResourceAsStream("resource.txt"));
        InputStream in = appClassloader.getResourceAsStream("resource.txt");
        Assert.assertNotNull((String)"Resource should not be null for app classloader", (Object)in);
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    private File makeTestJar() throws IOException {
        File jarFile = new File(testDir, "test.jar");
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jarFile));
        ZipEntry entry = new ZipEntry("resource.txt");
        out.putNextEntry(entry);
        out.write("hello".getBytes());
        out.closeEntry();
        out.close();
        return jarFile;
    }
}

