/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.router;

import java.io.File;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.security.MockDelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileImpl;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;

public final class SecurityConfUtil {
    private static String keystoresDir;
    private static String sslConfDir;
    private static final String SPNEGO_USER_NAME = "HTTP";
    private static final String ROUTER_USER_NAME = "router";
    private static final String PREFIX = "hadoop.http.authentication.";
    private static MiniKdc kdc;
    private static File baseDir;
    private static String spnegoPrincipal;
    private static String routerPrincipal;

    private SecurityConfUtil() {
    }

    public static String getRouterUserName() {
        return ROUTER_USER_NAME;
    }

    public static Configuration initSecurity() throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)SecurityConfUtil.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        HdfsConfiguration conf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        File keytabFile = new File(baseDir, "test.keytab");
        String keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        kdc.createPrincipal(keytabFile, new String[]{"HTTP/" + krbInstance, "router/" + krbInstance});
        routerPrincipal = "router/" + krbInstance + "@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        conf.set("dfs.namenode.kerberos.principal", routerPrincipal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", routerPrincipal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.set("hadoop.http.authentication.kerberos.principal", spnegoPrincipal);
        conf.set("hadoop.http.authentication.kerberos.keytab", keytab);
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", "authentication");
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(SecurityConfUtil.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        conf.set("dfs.federation.router.keytab.file", keytab);
        conf.set("dfs.federation.router.kerberos.principal", routerPrincipal);
        conf.set("dfs.federation.router.kerberos.internal.spnego.principal", spnegoPrincipal);
        conf.setClass("dfs.federation.router.store.driver.class", StateStoreFileImpl.class, StateStoreDriver.class);
        conf.set("dfs.federation.router.rpc-bind-host", "localhost");
        conf.set("dfs.federation.router.secret.manager.class", MockDelegationTokenSecretManager.class.getName());
        return conf;
    }

    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
            FileUtil.fullyDelete((File)baseDir);
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
        }
    }
}

