/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextMainOperationsBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHDFSFileContextMainOperations
extends FileContextMainOperationsBaseTest {
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static final HdfsConfiguration CONF;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper("/tmp/TestHDFSFileContextMainOperations");
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        URI uri0 = cluster.getURI(0);
        fc = FileContext.getFileContext((URI)uri0, (Configuration)CONF);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    private static void restartCluster() throws IOException, LoginException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(1).format(false).build();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)CONF);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected Path getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    protected IOException unwrapException(IOException e) {
        if (e instanceof RemoteException) {
            return ((RemoteException)((Object)e)).unwrapRemoteException();
        }
        return e;
    }

    private Path getTestRootPath(FileContext fc, String path) {
        return this.fileContextTestHelper.getTestRootPath(fc, path);
    }

    @Test
    public void testTruncate() throws Exception {
        int repl = 3;
        int blockSize = 1024;
        int numOfBlocks = 2;
        DistributedFileSystem fs = cluster.getFileSystem();
        Path dir = this.getTestRootPath(fc, "test/hadoop");
        Path file = this.getTestRootPath(fc, "test/hadoop/file");
        byte[] data = FileSystemTestHelper.getFileData((int)2, (long)1024L);
        FileSystemTestHelper.createFile((FileSystem)fs, (Path)file, (byte[])data, (int)1024, (short)3);
        int newLength = 1024;
        boolean isReady = fc.truncate(file, 1024L);
        Assert.assertTrue((String)"Recovery is not expected.", (boolean)isReady);
        FileStatus fileStatus = fc.getFileStatus(file);
        Assert.assertEquals((long)fileStatus.getLen(), (long)1024L);
        AppendTestUtil.checkFullFile((FileSystem)fs, file, 1024, data, file.toString());
        ContentSummary cs = fs.getContentSummary(dir);
        Assert.assertEquals((String)"Bad disk space usage", (long)cs.getSpaceConsumed(), (long)3072L);
        Assert.assertTrue((boolean)fs.delete(dir, true));
    }

    @Test
    public void testOldRenameWithQuota() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src1 = this.getTestRootPath(fc, "test/testOldRenameWithQuota/srcdir/src1");
        Path src2 = this.getTestRootPath(fc, "test/testOldRenameWithQuota/srcdir/src2");
        Path dst1 = this.getTestRootPath(fc, "test/testOldRenameWithQuota/dstdir/dst1");
        Path dst2 = this.getTestRootPath(fc, "test/testOldRenameWithQuota/dstdir/dst2");
        this.createFile(src1);
        this.createFile(src2);
        fs.setQuota(src1.getParent(), Long.MAX_VALUE, Long.MAX_VALUE);
        fc.mkdir(dst1.getParent(), FileContext.DEFAULT_PERM, true);
        fs.setQuota(dst1.getParent(), 2L, Long.MAX_VALUE);
        this.oldRename(src1, dst1, true, false);
        this.oldRename(src2, dst2, false, true);
        fs.setQuota(src1.getParent(), 1L, Long.MAX_VALUE);
        this.oldRename(dst1, src1, false, true);
    }

    @Test
    public void testRenameWithQuota() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src1 = this.getTestRootPath(fc, "test/testRenameWithQuota/srcdir/src1");
        Path src2 = this.getTestRootPath(fc, "test/testRenameWithQuota/srcdir/src2");
        Path dst1 = this.getTestRootPath(fc, "test/testRenameWithQuota/dstdir/dst1");
        Path dst2 = this.getTestRootPath(fc, "test/testRenameWithQuota/dstdir/dst2");
        this.createFile(src1);
        this.createFile(src2);
        fs.setQuota(src1.getParent(), Long.MAX_VALUE, Long.MAX_VALUE);
        fc.mkdir(dst1.getParent(), FileContext.DEFAULT_PERM, true);
        fs.setQuota(dst1.getParent(), 2L, Long.MAX_VALUE);
        this.rename(src1, dst1, false, true, new Options.Rename[]{Options.Rename.NONE});
        this.rename(src2, dst1, false, true, new Options.Rename[]{Options.Rename.OVERWRITE});
        this.createFile(src2);
        try {
            this.rename(src2, dst2, true, false, new Options.Rename[]{Options.Rename.NONE});
            Assert.fail((String)"NSQuotaExceededException excepted");
        }
        catch (NSQuotaExceededException nSQuotaExceededException) {
            // empty catch block
        }
        fs.setQuota(src1.getParent(), 1L, Long.MAX_VALUE);
        try {
            this.rename(dst1, src1, true, false, new Options.Rename[]{Options.Rename.NONE});
            Assert.fail((String)"NSQuotaExceededException excepted");
        }
        catch (NSQuotaExceededException nSQuotaExceededException) {
            // empty catch block
        }
        fs.setQuota(src1.getParent(), 100L, Long.MAX_VALUE);
        this.createFile(src1);
        fs.setQuota(src1.getParent(), 1L, Long.MAX_VALUE);
        this.rename(dst1, src1, false, true, new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    @Test(expected=RemoteException.class)
    public void testRenameRoot() throws Exception {
        Path src = this.getTestRootPath(fc, "test/testRenameRoot/srcdir/src1");
        Path dst = new Path("/");
        this.createFile(src);
        this.rename(dst, src, true, true, new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    @Test(expected=RemoteException.class)
    public void testRenameToRoot() throws Exception {
        Path src = this.getTestRootPath(fc, "test/testRenameRoot/srcdir/src1");
        Path dst = new Path("/");
        this.createFile(src);
        this.rename(src, dst, true, true, new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    @Test
    public void testEditsLogOldRename() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src1 = this.getTestRootPath(fc, "testEditsLogOldRename/srcdir/src1");
        Path dst1 = this.getTestRootPath(fc, "testEditsLogOldRename/dstdir/dst1");
        this.createFile(src1);
        fs.mkdirs(dst1.getParent());
        this.createFile(dst1);
        fs.setQuota(dst1.getParent(), 2L, Long.MAX_VALUE);
        fs.delete(dst1, true);
        this.oldRename(src1, dst1, true, false);
        TestHDFSFileContextMainOperations.restartCluster();
        fs = cluster.getFileSystem();
        src1 = this.getTestRootPath(fc, "testEditsLogOldRename/srcdir/src1");
        dst1 = this.getTestRootPath(fc, "testEditsLogOldRename/dstdir/dst1");
        Assert.assertFalse((boolean)fs.exists(src1));
        Assert.assertTrue((boolean)fs.exists(dst1));
    }

    @Test
    public void testEditsLogRename() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src1 = this.getTestRootPath(fc, "testEditsLogRename/srcdir/src1");
        Path dst1 = this.getTestRootPath(fc, "testEditsLogRename/dstdir/dst1");
        this.createFile(src1);
        fs.mkdirs(dst1.getParent());
        this.createFile(dst1);
        fs.setQuota(dst1.getParent(), 2L, Long.MAX_VALUE);
        fs.delete(dst1, true);
        this.rename(src1, dst1, false, true, new Options.Rename[]{Options.Rename.OVERWRITE});
        TestHDFSFileContextMainOperations.restartCluster();
        fs = cluster.getFileSystem();
        src1 = this.getTestRootPath(fc, "testEditsLogRename/srcdir/src1");
        dst1 = this.getTestRootPath(fc, "testEditsLogRename/dstdir/dst1");
        Assert.assertFalse((boolean)fs.exists(src1));
        Assert.assertTrue((boolean)fs.exists(dst1));
    }

    @Test
    public void testIsValidNameInvalidNames() {
        String[] invalidNames;
        for (String invalidName : invalidNames = new String[]{"/foo/../bar", "/foo/./bar", "/foo/:/bar", "/foo:bar"}) {
            Assert.assertFalse((String)(invalidName + " is not valid"), (boolean)fc.getDefaultFileSystem().isValidName(invalidName));
        }
    }

    private void oldRename(Path src, Path dst, boolean renameSucceeds, boolean exception) throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Assert.assertEquals((Object)renameSucceeds, (Object)fs.rename(src, dst));
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)exception);
        }
        Assert.assertEquals((Object)renameSucceeds, (Object)(!FileContextTestHelper.exists((FileContext)fc, (Path)src) ? 1 : 0));
        Assert.assertEquals((Object)renameSucceeds, (Object)FileContextTestHelper.exists((FileContext)fc, (Path)dst));
    }

    protected boolean listCorruptedBlocksSupported() {
        return true;
    }

    @Test
    public void testCrossFileSystemRename() throws IOException {
        try {
            fc.rename(new Path("hdfs://127.0.0.1/aaa/bbb/Foo"), new Path("file://aaa/bbb/Moo"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.fail((String)"IOexception expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        CONF = new HdfsConfiguration();
    }
}

