/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIncrementalBlockReports {
    public static final Logger LOG = LoggerFactory.getLogger(TestIncrementalBlockReports.class);
    private static final short DN_COUNT = 1;
    private static final long DUMMY_BLOCK_ID = 5678L;
    private static final long DUMMY_BLOCK_LENGTH = 0x100000L;
    private static final long DUMMY_BLOCK_GENSTAMP = 1000L;
    private MiniDFSCluster cluster = null;
    private Configuration conf;
    private NameNode singletonNn;
    private DataNode singletonDn;
    private BPOfferService bpos;
    private BPServiceActor actor;
    private String storageUuid;

    @Before
    public void startCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.singletonNn = this.cluster.getNameNode();
        this.singletonDn = this.cluster.getDataNodes().get(0);
        this.bpos = (BPOfferService)this.singletonDn.getAllBpOs().get(0);
        this.actor = (BPServiceActor)this.bpos.getBPServiceActors().get(0);
        try (FsDatasetSpi.FsVolumeReferences volumes = this.singletonDn.getFSDataset().getFsVolumeReferences();){
            this.storageUuid = volumes.get(0).getStorageID();
        }
    }

    private static Block getDummyBlock() {
        return new Block(5678L, 0x100000L, 1000L);
    }

    private void injectBlockReceived() {
        ReceivedDeletedBlockInfo rdbi = new ReceivedDeletedBlockInfo(TestIncrementalBlockReports.getDummyBlock(), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null);
        DatanodeStorage s = this.singletonDn.getFSDataset().getStorage(this.storageUuid);
        this.actor.getIbrManager().notifyNamenodeBlock(rdbi, s, false);
    }

    private void injectBlockDeleted() {
        ReceivedDeletedBlockInfo rdbi = new ReceivedDeletedBlockInfo(TestIncrementalBlockReports.getDummyBlock(), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null);
        this.actor.getIbrManager().addRDBI(rdbi, this.singletonDn.getFSDataset().getStorage(this.storageUuid));
    }

    DatanodeProtocolClientSideTranslatorPB spyOnDnCallsToNn() {
        return InternalDataNodeTestUtils.spyOnBposToNN(this.singletonDn, this.singletonNn);
    }

    @Test(timeout=60000L)
    public void testReportBlockReceived() throws InterruptedException, IOException {
        try {
            DatanodeProtocolClientSideTranslatorPB nnSpy = this.spyOnDnCallsToNn();
            this.injectBlockReceived();
            Thread.sleep(2000L);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.times((int)1))).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
        }
        finally {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReportBlockDeleted() throws InterruptedException, IOException {
        try {
            DataNodeTestUtils.triggerBlockReport(this.singletonDn);
            DatanodeProtocolClientSideTranslatorPB nnSpy = this.spyOnDnCallsToNn();
            this.injectBlockDeleted();
            Thread.sleep(1000L);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.times((int)0))).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
            DataNodeTestUtils.triggerHeartbeat(this.singletonDn);
            int retries = 0;
            while (true) {
                try {
                    ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.atLeastOnce())).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
                }
                catch (MockitoAssertionError e) {
                    if (retries > 7) {
                        throw e;
                    }
                    ++retries;
                    Thread.sleep(2000L);
                    continue;
                }
                break;
            }
        }
        finally {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testReplaceReceivedBlock() throws InterruptedException, IOException {
        try {
            DatanodeProtocolClientSideTranslatorPB nnSpy = this.spyOnDnCallsToNn();
            this.injectBlockReceived();
            this.injectBlockReceived();
            Thread.sleep(2000L);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)nnSpy, (VerificationMode)Mockito.atLeastOnce())).blockReceivedAndDeleted((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageReceivedDeletedBlocks[])ArgumentMatchers.any(StorageReceivedDeletedBlocks[].class));
            Assert.assertFalse((boolean)this.actor.getIbrManager().sendImmediately());
        }
        finally {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }
}

