/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AboutBlock
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final Router router;

    @Inject
    AboutBlock(Router router, View.ViewContext ctx) {
        super(ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        Configuration conf = this.router.getConfig();
        String webAppAddress = WebAppUtils.getRouterWebAppURLWithScheme((Configuration)conf);
        ClusterMetricsInfo metrics = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null, conf);
        boolean isEnabled = conf.getBoolean("yarn.federation.enabled", false);
        this.info("Cluster Status").__("Federation Enabled", (Object)isEnabled).__("Applications Submitted", (Object)metrics.getAppsSubmitted()).__("Applications Pending", (Object)metrics.getAppsPending()).__("Applications Running", (Object)metrics.getAppsRunning()).__("Applications Failed", (Object)metrics.getAppsFailed()).__("Applications Killed", (Object)metrics.getAppsKilled()).__("Applications Completed", (Object)metrics.getAppsCompleted()).__("Containers Allocated", (Object)metrics.getContainersAllocated()).__("Containers Reserved", (Object)metrics.getReservedContainers()).__("Containers Pending", (Object)metrics.getPendingContainers()).__("Available Memory", (Object)StringUtils.byteDesc((long)(metrics.getAvailableMB() * 0x100000L))).__("Allocated Memory", (Object)StringUtils.byteDesc((long)(metrics.getAllocatedMB() * 0x100000L))).__("Reserved Memory", (Object)StringUtils.byteDesc((long)(metrics.getReservedMB() * 0x100000L))).__("Total Memory", (Object)StringUtils.byteDesc((long)(metrics.getTotalMB() * 0x100000L))).__("Available VirtualCores", (Object)metrics.getAvailableVirtualCores()).__("Allocated VirtualCores", (Object)metrics.getAllocatedVirtualCores()).__("Reserved VirtualCores", (Object)metrics.getReservedVirtualCores()).__("Total VirtualCores", (Object)metrics.getTotalVirtualCores()).__("Active Nodes", (Object)metrics.getActiveNodes()).__("Lost Nodes", (Object)metrics.getLostNodes()).__("Available Nodes", (Object)metrics.getDecommissionedNodes()).__("Unhealthy Nodes", (Object)metrics.getUnhealthyNodes()).__("Rebooted Nodes", (Object)metrics.getRebootedNodes()).__("Total Nodes", (Object)metrics.getTotalNodes());
        html.__(InfoBlock.class);
    }
}

