/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.SafeMode;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractBooleanAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.Assertions;
import org.apache.hadoop.shaded.org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public abstract class AbstractContractSafeModeTest
extends AbstractFSContractTestBase {
    @Test
    public void testSafeMode() throws Throwable {
        FileSystem fs = this.getFileSystem();
        SafeMode fsWithSafeMode = this.verifyAndGetSafeModeInstance(fs);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(SafeModeAction.GET)).describedAs("Getting the status of safe mode before entering should be off.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(SafeModeAction.ENTER)).describedAs("Entering Safe mode and safe mode turns on.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(SafeModeAction.GET)).describedAs("Getting the status of safe mode after entering, safe mode should be on.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(SafeModeAction.LEAVE)).describedAs("Leaving safe mode, and safe mode switches off.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(SafeModeAction.FORCE_EXIT)).describedAs("Force exist safe mode at any time, safe mode should always switches off.", new Object[0])).isFalse();
    }

    private SafeMode verifyAndGetSafeModeInstance(FileSystem fs) {
        ((ObjectAssert)Assertions.assertThat((Object)fs).describedAs("File system %s must be an instance of %s", new Object[]{fs, SafeMode.class.getClass()})).isInstanceOf(SafeMode.class);
        return (SafeMode)fs;
    }
}

