/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.decomposition.Bidiagonal;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.Hessenberg;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.Schur;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.decomposition.Tridiagonal;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillConjugated;
import org.ojalgo.matrix.store.operation.FillMatchingBoth;
import org.ojalgo.matrix.store.operation.FillMatchingLeft;
import org.ojalgo.matrix.store.operation.FillMatchingRight;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.FillTransposed;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HermitianRank2Update;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyHermitianAndVector;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.random.Uniform;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class MatrixUtils {
    public static void copy(Access2D<?> source, int rows, int columns, double[][] destination) {
        for (int i = 0; i < rows; ++i) {
            double[] tmpRow = destination[i];
            for (int j = 0; j < columns; ++j) {
                tmpRow[j] = source.doubleValue(i, j);
            }
        }
    }

    public static void copyComplexArgument(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getArgument());
        }
    }

    public static void copyComplexImaginary(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getImaginary());
        }
    }

    public static void copyComplexModulus(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getModulus());
        }
    }

    public static void copyComplexModulusAndArgument(Access2D<ComplexNumber> source, ElementsConsumer<?> modDest, ElementsConsumer<?> argDest) {
        long tmpCount = FunctionUtils.min(source.count(), modDest.count(), argDest.count());
        for (long i = 0L; i < tmpCount; ++i) {
            ComplexNumber tmpComplexNumber = source.get(i);
            modDest.set(i, tmpComplexNumber.getModulus());
            argDest.set(i, tmpComplexNumber.getArgument());
        }
    }

    public static void copyComplexReal(Access2D<ComplexNumber> source, ElementsConsumer<?> destination) {
        long tmpCount = FunctionUtils.min(source.count(), destination.count());
        for (long i = 0L; i < tmpCount; ++i) {
            destination.set(i, source.get(i).getReal());
        }
    }

    public static void copyComplexRealAndImaginary(Access2D<ComplexNumber> source, ElementsConsumer<?> realDest, ElementsConsumer<?> imagDest) {
        long tmpCount = FunctionUtils.min(source.count(), realDest.count(), imagDest.count());
        for (long i = 0L; i < tmpCount; ++i) {
            ComplexNumber tmpComplexNumber = source.get(i);
            realDest.set(i, tmpComplexNumber.getReal());
            imagDest.set(i, tmpComplexNumber.getImaginary());
        }
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Bidiagonal<N> decomposition, NumberContext context) {
        return Bidiagonal.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Cholesky<N> decomposition, NumberContext context) {
        return Cholesky.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Eigenvalue<N> decomposition, NumberContext context) {
        return Eigenvalue.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Hessenberg<N> decomposition, NumberContext context) {
        return Hessenberg.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, LDL<N> decomposition, NumberContext context) {
        return LDL.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, LU<N> decomposition, NumberContext context) {
        return LU.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, QR<N> decomposition, NumberContext context) {
        return QR.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Schur<N> decomposition, NumberContext context) {
        return Schur.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, SingularValue<N> decomposition, NumberContext context) {
        return SingularValue.equals(matrix, decomposition, context);
    }

    @Deprecated
    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Tridiagonal<N> decomposition, NumberContext context) {
        return Tridiagonal.equals(matrix, decomposition, context);
    }

    public static final int firstInColumn(Access1D<?> matrix, int col, int defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max(((MatrixStore)matrix).firstInColumn(col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final long firstInColumn(Access1D<?> matrix, long col, long defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max((long)((MatrixStore)matrix).firstInColumn((int)col), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final int firstInRow(Access1D<?> matrix, int row, int defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max(((MatrixStore)matrix).firstInRow(row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static final long firstInRow(Access1D<?> matrix, long row, long defaultAndMinimum) {
        return matrix instanceof MatrixStore ? Math.max((long)((MatrixStore)matrix).firstInRow((int)row), defaultAndMinimum) : defaultAndMinimum;
    }

    public static PrimitiveDenseStore getComplexArgument(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexArgument(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexImaginary(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexImaginary(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexModulus(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexModulus(arg, retVal);
        return retVal;
    }

    public static PrimitiveDenseStore getComplexReal(Access2D<ComplexNumber> arg) {
        long tmpRows = arg.countRows();
        long tmpColumns = arg.countColumns();
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRows, tmpColumns);
        MatrixUtils.copyComplexReal(arg, retVal);
        return retVal;
    }

    public static <N extends Number> int hashCode(BasicMatrix matrix) {
        return AccessUtils.hashCode(matrix);
    }

    public static <N extends Number> int hashCode(MatrixStore<N> matrix) {
        return AccessUtils.hashCode(matrix);
    }

    public static boolean isHermitian(Access2D<?> matrix) {
        boolean retVal;
        long tmpRowDim = matrix.countRows();
        long tmpColDim = matrix.countColumns();
        Object tmpElement = matrix.get(0L);
        boolean bl = retVal = tmpRowDim == tmpColDim;
        if (tmpElement instanceof ComplexNumber) {
            int j = 0;
            while (retVal && (long)j < tmpColDim) {
                retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, ComplexNumber.valueOf(matrix.get((long)((long)j), (long)((long)j))).i);
                int i = j + 1;
                while (retVal && (long)i < tmpRowDim) {
                    ComplexNumber tmpLowerLeft = ComplexNumber.valueOf(matrix.get(i, j)).conjugate();
                    ComplexNumber tmpUpperRight = ComplexNumber.valueOf(matrix.get(j, i));
                    retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpLowerLeft.subtract(tmpUpperRight).norm());
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (retVal && (long)j < tmpColDim) {
                int i = j + 1;
                while (retVal && (long)i < tmpRowDim) {
                    retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, matrix.doubleValue(i, j) - matrix.doubleValue(j, i));
                    ++i;
                }
                ++j;
            }
        }
        return retVal;
    }

    public static <N extends Number> boolean isNormal(MatrixStore<N> matrix) {
        Object tmpConjugate = matrix.conjugate();
        return tmpConjugate.multiply(matrix).equals(matrix.multiply(tmpConjugate));
    }

    public static final int limitOfColumn(Access1D<?> matrix, int col, int defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min(((MatrixStore)matrix).limitOfColumn(col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final long limitOfColumn(Access1D<?> matrix, long col, long defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min((long)((MatrixStore)matrix).limitOfColumn((int)col), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final int limitOfRow(Access1D<?> matrix, int row, int defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min(((MatrixStore)matrix).limitOfRow(row), defaultAndMaximum) : defaultAndMaximum;
    }

    public static final long limitOfRow(Access1D<?> matrix, long row, long defaultAndMaximum) {
        return matrix instanceof MatrixStore ? Math.min((long)((MatrixStore)matrix).limitOfRow((int)row), defaultAndMaximum) : defaultAndMaximum;
    }

    public static PhysicalStore<ComplexNumber> makeRandomComplexStore(int aRowDim, int aColDim) {
        PhysicalStore retVal = (PhysicalStore)ComplexDenseStore.FACTORY.makeZero(aRowDim, aColDim);
        Uniform tmpArgGen = new Uniform(PrimitiveMath.ZERO, PrimitiveMath.TWO_PI);
        for (int j = 0; j < aColDim; ++j) {
            for (int i = 0; i < aRowDim; ++i) {
                retVal.set((long)i, (long)j, ComplexNumber.makePolar(PrimitiveMath.E, tmpArgGen.doubleValue()).add(PrimitiveMath.PI));
            }
        }
        return retVal;
    }

    public static PrimitiveDenseStore makeSPD(int dim) {
        double[] tmpRandom = new double[dim];
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(dim, dim);
        for (int i = 0; i < dim; ++i) {
            tmpRandom[i] = Math.random();
            for (int j = 0; j < i; ++j) {
                retVal.set((long)i, (long)j, tmpRandom[i] * tmpRandom[j]);
                retVal.set((long)j, (long)i, tmpRandom[j] * tmpRandom[i]);
            }
            retVal.set((long)i, (long)i, tmpRandom[i] + 1.0);
        }
        return retVal;
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Bidiagonal<N> decomposition) {
        return Bidiagonal.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Cholesky<N> decomposition) {
        return Cholesky.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Eigenvalue<N> decomposition) {
        return Eigenvalue.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Hessenberg<N> decomposition) {
        return Hessenberg.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(LDL<N> decomposition) {
        return LDL.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(LU<N> decomposition) {
        return LU.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(QR<N> decomposition) {
        return QR.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Schur<N> decomposition) {
        return Schur.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(SingularValue<N> decomposition) {
        return SingularValue.reconstruct(decomposition);
    }

    @Deprecated
    public static <N extends Number> MatrixStore<N> reconstruct(Tridiagonal<N> decomposition) {
        return Tridiagonal.reconstruct(decomposition);
    }

    public static void setAllOperationThresholds(int value) {
        MatrixUtils.setThresholdsMaxValue(value);
        MatrixUtils.setThresholdsMinValue(value);
    }

    public static void setThresholdsMaxValue(int maxValue) {
        AggregateAll.THRESHOLD = Math.min(maxValue, AggregateAll.THRESHOLD);
        ApplyCholesky.THRESHOLD = Math.min(maxValue, ApplyCholesky.THRESHOLD);
        ApplyLU.THRESHOLD = Math.min(maxValue, ApplyLU.THRESHOLD);
        FillMatchingBoth.THRESHOLD = Math.min(maxValue, FillMatchingBoth.THRESHOLD);
        FillConjugated.THRESHOLD = Math.min(maxValue, FillConjugated.THRESHOLD);
        FillMatchingLeft.THRESHOLD = Math.min(maxValue, FillMatchingLeft.THRESHOLD);
        FillMatchingRight.THRESHOLD = Math.min(maxValue, FillMatchingRight.THRESHOLD);
        FillMatchingSingle.THRESHOLD = Math.min(maxValue, FillMatchingSingle.THRESHOLD);
        FillTransposed.THRESHOLD = Math.min(maxValue, FillTransposed.THRESHOLD);
        GenerateApplyAndCopyHouseholderColumn.THRESHOLD = Math.min(maxValue, GenerateApplyAndCopyHouseholderColumn.THRESHOLD);
        GenerateApplyAndCopyHouseholderRow.THRESHOLD = Math.min(maxValue, GenerateApplyAndCopyHouseholderRow.THRESHOLD);
        HermitianRank2Update.THRESHOLD = Math.min(maxValue, HermitianRank2Update.THRESHOLD);
        HouseholderLeft.THRESHOLD = Math.min(maxValue, HouseholderLeft.THRESHOLD);
        HouseholderRight.THRESHOLD = Math.min(maxValue, HouseholderRight.THRESHOLD);
        AXPY.THRESHOLD = Math.min(maxValue, AXPY.THRESHOLD);
        ModifyAll.THRESHOLD = Math.min(maxValue, ModifyAll.THRESHOLD);
        MultiplyBoth.THRESHOLD = Math.min(maxValue, MultiplyBoth.THRESHOLD);
        MultiplyHermitianAndVector.THRESHOLD = Math.min(maxValue, MultiplyHermitianAndVector.THRESHOLD);
        MultiplyLeft.THRESHOLD = Math.min(maxValue, MultiplyLeft.THRESHOLD);
        MultiplyRight.THRESHOLD = Math.min(maxValue, MultiplyRight.THRESHOLD);
        RotateLeft.THRESHOLD = Math.min(maxValue, RotateLeft.THRESHOLD);
        RotateRight.THRESHOLD = Math.min(maxValue, RotateRight.THRESHOLD);
        SubstituteBackwards.THRESHOLD = Math.min(maxValue, SubstituteBackwards.THRESHOLD);
        SubstituteForwards.THRESHOLD = Math.min(maxValue, SubstituteForwards.THRESHOLD);
    }

    public static void setThresholdsMinValue(int minValue) {
        AggregateAll.THRESHOLD = Math.max(minValue, AggregateAll.THRESHOLD);
        ApplyCholesky.THRESHOLD = Math.max(minValue, ApplyCholesky.THRESHOLD);
        ApplyLU.THRESHOLD = Math.max(minValue, ApplyLU.THRESHOLD);
        FillMatchingBoth.THRESHOLD = Math.max(minValue, FillMatchingBoth.THRESHOLD);
        FillConjugated.THRESHOLD = Math.max(minValue, FillConjugated.THRESHOLD);
        FillMatchingLeft.THRESHOLD = Math.max(minValue, FillMatchingLeft.THRESHOLD);
        FillMatchingRight.THRESHOLD = Math.max(minValue, FillMatchingRight.THRESHOLD);
        FillMatchingSingle.THRESHOLD = Math.max(minValue, FillMatchingSingle.THRESHOLD);
        FillTransposed.THRESHOLD = Math.max(minValue, FillTransposed.THRESHOLD);
        GenerateApplyAndCopyHouseholderColumn.THRESHOLD = Math.max(minValue, GenerateApplyAndCopyHouseholderColumn.THRESHOLD);
        GenerateApplyAndCopyHouseholderRow.THRESHOLD = Math.max(minValue, GenerateApplyAndCopyHouseholderRow.THRESHOLD);
        HermitianRank2Update.THRESHOLD = Math.max(minValue, HermitianRank2Update.THRESHOLD);
        HouseholderLeft.THRESHOLD = Math.max(minValue, HouseholderLeft.THRESHOLD);
        HouseholderRight.THRESHOLD = Math.max(minValue, HouseholderRight.THRESHOLD);
        AXPY.THRESHOLD = Math.max(minValue, AXPY.THRESHOLD);
        ModifyAll.THRESHOLD = Math.max(minValue, ModifyAll.THRESHOLD);
        MultiplyBoth.THRESHOLD = Math.max(minValue, MultiplyBoth.THRESHOLD);
        MultiplyHermitianAndVector.THRESHOLD = Math.max(minValue, MultiplyHermitianAndVector.THRESHOLD);
        MultiplyLeft.THRESHOLD = Math.max(minValue, MultiplyLeft.THRESHOLD);
        MultiplyRight.THRESHOLD = Math.max(minValue, MultiplyRight.THRESHOLD);
        RotateLeft.THRESHOLD = Math.max(minValue, RotateLeft.THRESHOLD);
        RotateRight.THRESHOLD = Math.max(minValue, RotateRight.THRESHOLD);
        SubstituteBackwards.THRESHOLD = Math.max(minValue, SubstituteBackwards.THRESHOLD);
        SubstituteForwards.THRESHOLD = Math.max(minValue, SubstituteForwards.THRESHOLD);
    }

    public static String toString(Access2D<?> matrix) {
        StringBuilder retVal = new StringBuilder();
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        retVal.append(matrix.getClass().getName());
        retVal.append(' ').append('<').append(' ').append(tmpRowDim).append(' ').append('x').append(' ').append(tmpColDim).append(' ').append('>');
        if (tmpRowDim > 0 && tmpColDim > 0 && tmpRowDim <= 50 && tmpColDim <= 50 && tmpRowDim * tmpColDim <= 200) {
            retVal.append("\n{ { ").append(matrix.get(0L, 0L));
            for (int j = 1; j < tmpColDim; ++j) {
                retVal.append(",\t").append(matrix.get(0L, j));
            }
            for (int i = 1; i < tmpRowDim; ++i) {
                retVal.append(" },\n{ ").append(matrix.get(i, 0L));
                for (int j = 1; j < tmpColDim; ++j) {
                    retVal.append(",\t").append(matrix.get(i, j));
                }
            }
            retVal.append(" } }");
        }
        return retVal.toString();
    }

    public static Access2D<BigDecimal> wrapBigAccess2D(final BasicMatrix matrix) {
        return new Access2D<BigDecimal>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public BigDecimal get(long row, long col) {
                return TypeUtils.toBigDecimal(matrix.get((int)row, (int)col));
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    public static Access2D<ComplexNumber> wrapComplexAccess2D(final BasicMatrix matrix) {
        return new Access2D<ComplexNumber>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public ComplexNumber get(long row, long col) {
                return ComplexNumber.valueOf(matrix.get((int)row, (int)col));
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    public static Access2D<Double> wrapPrimitiveAccess2D(final BasicMatrix matrix) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return this.size();
            }

            @Override
            public long countColumns() {
                return matrix.countColumns();
            }

            @Override
            public long countRows() {
                return matrix.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return matrix.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            @Override
            public Double get(long row, long col) {
                return matrix.doubleValue(row, col);
            }

            public int size() {
                return (int)matrix.count();
            }
        };
    }

    private MatrixUtils() {
    }
}

