/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.Normal;
import org.ojalgo.random.SampleSet;

public class LogNormal
extends AbstractContinuous {
    private static final long serialVersionUID = 2175858399667617840L;
    private final Normal myNormal;

    public static LogNormal estimate(Access1D<?> rawSamples) {
        int tmpSize = (int)rawSamples.count();
        Structure1D tmpLogSamples = Array1D.PRIMITIVE64.makeZero(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            ((Array1D)tmpLogSamples).set((long)i, PrimitiveFunction.LOG.invoke(rawSamples.doubleValue(i)));
        }
        SampleSet tmpSampleSet = SampleSet.wrap(tmpLogSamples);
        return new LogNormal(tmpSampleSet.getMean(), tmpSampleSet.getStandardDeviation());
    }

    public static LogNormal make(double aExpected, double aVariance) {
        double tmpVar = PrimitiveFunction.LOG1P.invoke(aVariance / (aExpected * aExpected));
        double tmpMean = PrimitiveFunction.LOG.invoke(aExpected) - PrimitiveMath.HALF * tmpVar;
        double tmpStdDev = PrimitiveFunction.SQRT.invoke(tmpVar);
        return new LogNormal(tmpMean, tmpStdDev);
    }

    public LogNormal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public LogNormal(double aMean, double aStdDev) {
        this.myNormal = new Normal(aMean, aStdDev);
    }

    @Override
    public double getDistribution(double value) {
        return this.myNormal.getDistribution(PrimitiveFunction.LOG.invoke(value));
    }

    @Override
    public double getExpected() {
        return PrimitiveFunction.EXP.invoke(this.myNormal.getExpected() + this.myNormal.getVariance() * PrimitiveMath.HALF);
    }

    public double getGeometricMean() {
        return PrimitiveFunction.EXP.invoke(this.myNormal.getExpected());
    }

    public double getGeometricStandardDeviation() {
        return PrimitiveFunction.EXP.invoke(this.myNormal.getStandardDeviation());
    }

    @Override
    public double getProbability(double value) {
        return this.myNormal.getProbability(PrimitiveFunction.LOG.invoke(value)) / value;
    }

    @Override
    public double getQuantile(double probality) {
        this.checkProbabilty(probality);
        return PrimitiveFunction.EXP.invoke(this.myNormal.getQuantile(probality));
    }

    @Override
    public double getVariance() {
        double tmpVariance = this.myNormal.getVariance();
        return PrimitiveFunction.EXPM1.invoke(tmpVariance) * PrimitiveFunction.EXP.invoke(PrimitiveMath.TWO * this.myNormal.getExpected() + tmpVariance);
    }

    @Override
    protected double generate() {
        return PrimitiveFunction.EXP.invoke(this.myNormal.generate());
    }
}

