/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilter;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class TestProxyUserAuthenticationFilter {
    private String actualUser;

    @Test(timeout=10000L)
    public void testFilter() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("proxyuser.knox.users", "testuser");
        params.put("proxyuser.knox.hosts", "127.0.0.1");
        params.put("type", "simple");
        DummyFilterConfig config = new DummyFilterConfig(params);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) {
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                TestProxyUserAuthenticationFilter.this.actualUser = request.getRemoteUser();
            }
        };
        ProxyUserAuthenticationFilter testFilter = new ProxyUserAuthenticationFilter();
        testFilter.init((FilterConfig)config);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"knox");
        Mockito.when((Object)request.getParameter("doas")).thenReturn((Object)"testuser");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "knox@EXAMPLE.COM";
            }
        });
        HttpServletResponseForTest response = new HttpServletResponseForTest();
        testFilter.doFilter(chain, request, (HttpServletResponse)response);
        Assertions.assertThat((String)this.actualUser).isEqualTo((Object)"testuser");
    }

    private class HttpServletResponseForTest
    implements HttpServletResponse {
        private HttpServletResponseForTest() {
        }

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public int getStatus() {
            return 0;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentLengthLong(long len) {
        }

        public void setContentType(String type) {
        }

        public void setBufferSize(int size) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale loc) {
        }

        public Locale getLocale() {
            return null;
        }
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        private final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String param) {
            return this.map.get(param);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            return context;
        }
    }
}

