/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.fedbalance.DistCpProcedure;
import org.apache.hadoop.tools.fedbalance.FedBalanceConfigs;
import org.apache.hadoop.tools.fedbalance.FedBalanceContext;
import org.apache.hadoop.tools.fedbalance.FedBalanceOptions;
import org.apache.hadoop.tools.fedbalance.TrashProcedure;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceJob;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedureScheduler;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedBalance
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger(FedBalance.class);
    private static final String SUBMIT_COMMAND = "submit";
    private static final String CONTINUE_COMMAND = "continue";
    public static final String NO_MOUNT = "no-mount";
    public static final String DISTCP_PROCEDURE = "distcp-procedure";
    public static final String TRASH_PROCEDURE = "trash-procedure";
    public static final String FED_BALANCE_DEFAULT_XML = "hdfs-fedbalance-default.xml";
    public static final String FED_BALANCE_SITE_XML = "hdfs-fedbalance-site.xml";

    public int run(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        CommandLine command = parser.parse(FedBalanceOptions.CLI_OPTIONS, args, true);
        String[] leftOverArgs = command.getArgs();
        if (leftOverArgs == null || leftOverArgs.length < 1) {
            this.printUsage();
            return -1;
        }
        String cmd = leftOverArgs[0];
        if (cmd.equals(SUBMIT_COMMAND)) {
            if (leftOverArgs.length < 3) {
                this.printUsage();
                return -1;
            }
            String inputSrc = leftOverArgs[1];
            String inputDst = leftOverArgs[2];
            return this.submit(command, inputSrc, inputDst);
        }
        if (cmd.equals(CONTINUE_COMMAND)) {
            return this.continueJob();
        }
        this.printUsage();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int continueJob() throws InterruptedException {
        BalanceProcedureScheduler scheduler = new BalanceProcedureScheduler(this.getConf());
        try {
            scheduler.init(true);
            while (true) {
                Collection<BalanceJob> jobs = scheduler.getAllJobs();
                int unfinished = 0;
                for (BalanceJob job : jobs) {
                    if (!job.isJobDone()) {
                        ++unfinished;
                    }
                    LOG.info(job.toString());
                }
                if (unfinished == 0) {
                    break;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
        }
        catch (IOException e) {
            LOG.error("Continue balance job failed.", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            scheduler.shutDown();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submit(CommandLine command, String inputSrc, String inputDst) throws IOException {
        Builder builder = new Builder(inputSrc, inputDst);
        builder.setForceCloseOpen(command.hasOption(FedBalanceOptions.FORCE_CLOSE_OPEN.getOpt()));
        if (command.hasOption(FedBalanceOptions.MAP.getOpt())) {
            builder.setMap(Integer.parseInt(command.getOptionValue(FedBalanceOptions.MAP.getOpt())));
        }
        if (command.hasOption(FedBalanceOptions.BANDWIDTH.getOpt())) {
            builder.setBandWidth(Integer.parseInt(command.getOptionValue(FedBalanceOptions.BANDWIDTH.getOpt())));
        }
        if (command.hasOption(FedBalanceOptions.DELAY_DURATION.getOpt())) {
            builder.setDelayDuration(Long.parseLong(command.getOptionValue(FedBalanceOptions.DELAY_DURATION.getOpt())));
        }
        if (command.hasOption(FedBalanceOptions.DIFF_THRESHOLD.getOpt())) {
            builder.setDiffThreshold(Integer.parseInt(command.getOptionValue(FedBalanceOptions.DIFF_THRESHOLD.getOpt())));
        }
        if (command.hasOption(FedBalanceOptions.TRASH.getOpt())) {
            String val = command.getOptionValue(FedBalanceOptions.TRASH.getOpt());
            if (val.equalsIgnoreCase("skip")) {
                builder.setTrashOpt(FedBalanceConfigs.TrashOption.SKIP);
            } else if (val.equalsIgnoreCase("trash")) {
                builder.setTrashOpt(FedBalanceConfigs.TrashOption.TRASH);
            } else if (val.equalsIgnoreCase("delete")) {
                builder.setTrashOpt(FedBalanceConfigs.TrashOption.DELETE);
            } else {
                this.printUsage();
                return -1;
            }
        }
        BalanceProcedureScheduler scheduler = new BalanceProcedureScheduler(this.getConf());
        scheduler.init(false);
        try {
            BalanceJob balanceJob = builder.build();
            scheduler.submit(balanceJob);
            scheduler.waitUntilDone(balanceJob);
        }
        catch (IOException e) {
            LOG.error("Submit balance job failed.", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            scheduler.shutDown();
        }
        return 0;
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("fedbalance OPTIONS [submit|continue] <src> <target>\n\nOPTIONS", FedBalanceOptions.CLI_OPTIONS);
    }

    @VisibleForTesting
    static Configuration getDefaultConf() {
        Configuration config = new Configuration();
        config.addResource(FED_BALANCE_DEFAULT_XML);
        config.addResource(FED_BALANCE_SITE_XML);
        return config;
    }

    public static void main(String[] argv) {
        int exitCode;
        Configuration conf = FedBalance.getDefaultConf();
        FedBalance fedBalance = new FedBalance();
        fedBalance.setConf(conf);
        try {
            exitCode = ToolRunner.run((Tool)fedBalance, (String[])argv);
        }
        catch (Exception e) {
            LOG.warn("Couldn't complete FedBalance operation.", (Throwable)e);
            exitCode = -1;
        }
        System.exit(exitCode);
    }

    private final class Builder {
        private boolean forceCloseOpen = false;
        private int map = 10;
        private int bandwidth = 10;
        private FedBalanceConfigs.TrashOption trashOpt = FedBalanceConfigs.TrashOption.TRASH;
        private long delayDuration = TimeUnit.SECONDS.toMillis(1L);
        private int diffThreshold = 0;
        private final String inputSrc;
        private final String inputDst;

        private Builder(String inputSrc, String inputDst) {
            this.inputSrc = inputSrc;
            this.inputDst = inputDst;
        }

        public Builder setForceCloseOpen(boolean value) {
            this.forceCloseOpen = value;
            return this;
        }

        public Builder setMap(int value) {
            this.map = value;
            return this;
        }

        public Builder setBandWidth(int value) {
            this.bandwidth = value;
            return this;
        }

        public Builder setTrashOpt(FedBalanceConfigs.TrashOption value) {
            this.trashOpt = value;
            return this;
        }

        public Builder setDelayDuration(long value) {
            this.delayDuration = value;
            return this;
        }

        public Builder setDiffThreshold(int value) {
            this.diffThreshold = value;
            return this;
        }

        public BalanceJob build() throws IOException {
            Path dst = new Path(this.inputDst);
            if (dst.toUri().getAuthority() == null) {
                throw new IOException("The destination cluster must be specified.");
            }
            Path src = new Path(this.inputSrc);
            if (src.toUri().getAuthority() == null) {
                throw new IOException("The source cluster must be specified.");
            }
            FedBalanceContext context = new FedBalanceContext.Builder(src, dst, FedBalance.NO_MOUNT, FedBalance.this.getConf()).setForceCloseOpenFiles(this.forceCloseOpen).setUseMountReadOnly(false).setMapNum(this.map).setBandwidthLimit(this.bandwidth).setTrash(this.trashOpt).setDiffThreshold(this.diffThreshold).build();
            LOG.info(context.toString());
            BalanceJob.Builder<BalanceProcedure> builder = new BalanceJob.Builder<BalanceProcedure>();
            DistCpProcedure dcp = new DistCpProcedure(FedBalance.DISTCP_PROCEDURE, null, this.delayDuration, context);
            builder.nextProcedure(dcp);
            TrashProcedure tp = new TrashProcedure(FedBalance.TRASH_PROCEDURE, null, this.delayDuration, context);
            builder.nextProcedure(tp);
            return builder.build();
        }
    }
}

