/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceRackFaultTolerantBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestReplicationPolicyExcludeSlowNodes
extends BaseReplicationPolicyTest {
    public TestReplicationPolicyExcludeSlowNodes(String blockPlacementPolicy) {
        this.blockPlacementPolicy = blockPlacementPolicy;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({BlockPlacementPolicyDefault.class.getName()}, {BlockPlacementPolicyWithUpgradeDomain.class.getName()}, {AvailableSpaceBlockPlacementPolicy.class.getName()}, {BlockPlacementPolicyRackFaultTolerant.class.getName()}, {AvailableSpaceRackFaultTolerantBlockPlacementPolicy.class.getName()});
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        conf.setBoolean("dfs.datanode.peer.stats.enabled", true);
        conf.setStrings("dfs.namenode.slowpeer.collect.interval", new String[]{"1s"});
        conf.setBoolean("dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", true);
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3", "/rack4", "/rack5", "/rack6"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetExcludeSlowNodes() throws Exception {
        this.namenode.getNamesystem().writeLock();
        try {
            for (int i = 0; i < this.dataNodes.length; ++i) {
                this.dnManager.addDatanode(this.dataNodes[i]);
            }
            SlowPeerTracker tracker = this.dnManager.getSlowPeerTracker();
            OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.29463));
            tracker.addReport(this.dataNodes[0].getInfoAddr(), this.dataNodes[3].getInfoAddr(), outlierMetrics1);
            OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.9576));
            tracker.addReport(this.dataNodes[0].getInfoAddr(), this.dataNodes[4].getInfoAddr(), outlierMetrics2);
            OutlierMetrics outlierMetrics3 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.59674));
            tracker.addReport(this.dataNodes[1].getInfoAddr(), this.dataNodes[4].getInfoAddr(), outlierMetrics3);
            OutlierMetrics outlierMetrics4 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(4.238456));
            tracker.addReport(this.dataNodes[1].getInfoAddr(), this.dataNodes[5].getInfoAddr(), outlierMetrics4);
            OutlierMetrics outlierMetrics5 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(5.18375));
            tracker.addReport(this.dataNodes[2].getInfoAddr(), this.dataNodes[3].getInfoAddr(), outlierMetrics5);
            OutlierMetrics outlierMetrics6 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(6.39576));
            tracker.addReport(this.dataNodes[2].getInfoAddr(), this.dataNodes[5].getInfoAddr(), outlierMetrics6);
            Thread.sleep(3000L);
            Set slowPeers = this.dnManager.getSlowPeersUuidSet();
            Assert.assertEquals((long)3L, (long)slowPeers.size());
            for (int i = 0; i < slowPeers.size(); ++i) {
                Assert.assertTrue((boolean)slowPeers.contains(this.dataNodes[i].getDatanodeUuid()));
            }
            DatanodeDescriptor writerDn = this.dataNodes[0];
            DatanodeStorageInfo[] targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)3L, (long)targets.length);
            for (int i = 0; i < targets.length; ++i) {
                Assert.assertTrue((!slowPeers.contains(targets[i].getDatanodeDescriptor().getDatanodeUuid()) ? 1 : 0) != 0);
            }
        }
        finally {
            this.namenode.getNamesystem().writeUnlock();
        }
        NameNode.LOG.info("Done working on it");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowPeerTrackerEnabledClearSlowNodes() throws Exception {
        this.namenode.getNamesystem().writeLock();
        try {
            for (DatanodeDescriptor dataNode : this.dataNodes) {
                this.dnManager.addDatanode(dataNode);
            }
            SlowPeerTracker tracker = this.dnManager.getSlowPeerTracker();
            Assert.assertNotNull((Object)tracker);
            OutlierMetrics outlierMetrics = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(5.0));
            tracker.addReport(this.dataNodes[0].getInfoAddr(), this.dataNodes[3].getInfoAddr(), outlierMetrics);
            tracker.addReport(this.dataNodes[1].getInfoAddr(), this.dataNodes[3].getInfoAddr(), outlierMetrics);
            tracker.addReport(this.dataNodes[2].getInfoAddr(), this.dataNodes[3].getInfoAddr(), outlierMetrics);
            Assert.assertFalse((boolean)this.dnManager.isSlowPeerCollectorInitialized());
            GenericTestUtils.waitFor(() -> DatanodeManager.getSlowNodesUuidSet().size() == 3, (long)100L, (long)3000L);
            this.namenode.reconfigureProperty("dfs.datanode.peer.stats.enabled", "false");
            Assert.assertTrue((boolean)this.dnManager.isSlowPeerCollectorInitialized());
            Assert.assertEquals((long)0L, (long)DatanodeManager.getSlowNodesUuidSet().size());
        }
        finally {
            this.namenode.getNamesystem().writeUnlock();
        }
    }
}

