/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.ConfCredentialBasedAccessTokenProvider;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RequestDefinition;

public class TestClientCredentialTimeBasedTokenRefresher {
    public static final Header CONTENT_TYPE_APPLICATION_JSON = new Header("Content-Type", new String[]{"application/json"});
    public static final String CLIENT_ID_FOR_TESTING = "joebob";

    public Configuration buildConf(String credential, String tokenExpires, String clientId, String refreshURL) {
        Configuration conf = new Configuration();
        conf.set("dfs.webhdfs.oauth2.credential", credential);
        conf.set("dfs.webhdfs.oauth2.access.token.provider", ConfCredentialBasedAccessTokenProvider.class.getName());
        conf.set("dfs.webhdfs.oauth2.client.id", clientId);
        conf.set("dfs.webhdfs.oauth2.refresh.url", refreshURL);
        return conf;
    }

    @Test
    public void refreshUrlIsCorrect() throws IOException {
        int PORT = ServerSocketUtil.getPort((int)0, (int)20);
        String REFRESH_ADDRESS = "http://localhost:" + PORT + "/refresh";
        long tokenExpires = 0L;
        Configuration conf = this.buildConf("myreallycoolcredential", Long.toString(tokenExpires), CLIENT_ID_FOR_TESTING, REFRESH_ADDRESS);
        Timer mockTimer = (Timer)Mockito.mock(Timer.class);
        Mockito.when((Object)mockTimer.now()).thenReturn((Object)(tokenExpires + 1000L));
        ConfCredentialBasedAccessTokenProvider credProvider = new ConfCredentialBasedAccessTokenProvider(mockTimer);
        credProvider.setConf(conf);
        ClientAndServer mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{PORT});
        HttpRequest expectedRequest = HttpRequest.request().withMethod("POST").withPath("/refresh").withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"client_secret", (String[])new String[]{"myreallycoolcredential"}), Parameter.param((String)"grant_type", (String[])new String[]{"client_credentials"}), Parameter.param((String)"client_id", (String[])new String[]{CLIENT_ID_FOR_TESTING})}));
        MockServerClient mockServerClient = new MockServerClient("localhost", PORT);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("expires_in", "0987654321");
        map.put("token_type", "bearer");
        map.put("access_token", "new access token");
        ObjectMapper mapper = new ObjectMapper();
        HttpResponse resp = HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeaders(new Header[]{CONTENT_TYPE_APPLICATION_JSON}).withBody(mapper.writeValueAsString(map));
        mockServerClient.when((RequestDefinition)expectedRequest, Times.exactly((int)1)).respond(resp);
        Assert.assertEquals((Object)"new access token", (Object)credProvider.getAccessToken());
        mockServerClient.verify(new RequestDefinition[]{expectedRequest});
        mockServerClient.clear((RequestDefinition)expectedRequest);
        mockServer.stop();
    }
}

