/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.scalar.ComplexNumber;

public interface Householder<N extends Number>
extends Access1D<N> {
    public int first();

    public static final class Primitive
    implements Householder<Double> {
        public double beta;
        public int first;
        public final double[] vector;

        public Primitive(Householder<Double> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Primitive(int aDim) {
            this.vector = new double[aDim];
            this.beta = PrimitiveMath.ZERO;
            this.first = 0;
        }

        private Primitive() {
            this(0);
        }

        public final Primitive copy(Householder<Double> aSource) {
            this.first = aSource.first();
            double[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                double tmpVal = aSource.doubleValue(i);
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpVal;
            }
            this.beta = PrimitiveMath.TWO / tmpVal2;
            return this;
        }

        public final Primitive copy(Householder<Double> aSource, double precalculatedBeta) {
            this.first = aSource.first();
            double[] tmpVector = this.vector;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                tmpVector[i] = aSource.doubleValue(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd];
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public Double get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("{ ");
            int tmpLastIndex = this.vector.length - 1;
            for (int i = 0; i < tmpLastIndex; ++i) {
                retVal.append(this.get(i));
                retVal.append(", ");
            }
            retVal.append(this.get(tmpLastIndex));
            retVal.append(" }");
            return retVal.toString();
        }
    }

    public static final class Complex
    implements Householder<ComplexNumber> {
        public ComplexNumber beta;
        public int first;
        public final ComplexNumber[] vector;

        public Complex(Householder<ComplexNumber> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Complex(int aDim) {
            this.vector = new ComplexNumber[aDim];
            this.beta = ComplexNumber.ZERO;
            this.first = 0;
        }

        private Complex() {
            this(0);
        }

        public final Complex copy(Householder<ComplexNumber> aSource) {
            this.first = aSource.first();
            ComplexNumber[] tmpVector = this.vector;
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                ComplexNumber tmpNmbr = (ComplexNumber)aSource.get(i);
                double tmpVal = tmpNmbr.norm();
                tmpVal2 += tmpVal * tmpVal;
                tmpVector[i] = tmpNmbr;
            }
            this.beta = ComplexNumber.valueOf(PrimitiveMath.TWO / tmpVal2);
            return this;
        }

        public final Complex copy(Householder<ComplexNumber> aSource, ComplexNumber precalculatedBeta) {
            this.first = aSource.first();
            ComplexNumber[] tmpVector = this.vector;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                tmpVector[i] = (ComplexNumber)aSource.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd].doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public ComplexNumber get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(ComplexNumber.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }

    public static final class Big
    implements Householder<BigDecimal> {
        public BigDecimal beta;
        public int first;
        public final BigDecimal[] vector;

        public Big(Householder<BigDecimal> aTransf) {
            this((int)aTransf.count());
            this.copy(aTransf);
        }

        public Big(int aDim) {
            this.vector = new BigDecimal[aDim];
            this.beta = BigMath.ZERO;
            this.first = 0;
        }

        private Big() {
            this(0);
        }

        public final Big copy(Householder<BigDecimal> aSource) {
            this.first = aSource.first();
            BigDecimal[] tmpVector = this.vector;
            BigDecimal tmpVal2 = BigMath.ZERO;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                BigDecimal tmpVal = (BigDecimal)aSource.get(i);
                tmpVal2 = BigFunction.ADD.invoke(tmpVal2, BigFunction.MULTIPLY.invoke(tmpVal, tmpVal));
                tmpVector[i] = tmpVal;
            }
            this.beta = BigFunction.DIVIDE.invoke(BigMath.TWO, tmpVal2);
            return this;
        }

        public final Big copy(Householder<BigDecimal> aSource, BigDecimal precalculatedBeta) {
            this.first = aSource.first();
            BigDecimal[] tmpVector = this.vector;
            int tmpSize = (int)aSource.count();
            for (int i = aSource.first(); i < tmpSize; ++i) {
                tmpVector[i] = (BigDecimal)aSource.get(i);
            }
            this.beta = precalculatedBeta;
            return this;
        }

        @Override
        public long count() {
            return this.vector.length;
        }

        @Override
        public double doubleValue(long anInd) {
            return this.vector[(int)anInd].doubleValue();
        }

        @Override
        public int first() {
            return this.first;
        }

        @Override
        public BigDecimal get(long index) {
            return this.vector[(int)index];
        }

        public String toString() {
            int i;
            StringBuilder retVal = new StringBuilder("{");
            int tmpFirst = this.first;
            int tmpLength = this.vector.length;
            for (i = 0; i < tmpFirst; ++i) {
                retVal.append(BigMath.ZERO);
                retVal.append(", ");
            }
            for (i = this.first; i < tmpLength; ++i) {
                retVal.append(this.vector[i]);
                if (i + 1 >= tmpLength) continue;
                retVal.append(", ");
            }
            retVal.append("}");
            return retVal.toString();
        }
    }
}

