/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.crypto.CryptoScheme;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;

public class CryptoCipher {
    static final CryptoCipher Null = new CryptoCipher(){};
    private final Cipher cipher;
    private final CryptoScheme scheme;
    private final SecretKey secreteKey;
    private final int cipherMode;

    private CryptoCipher() {
        this.cipher = new NullCipher();
        this.scheme = null;
        this.secreteKey = null;
        this.cipherMode = -1;
    }

    CryptoCipher(Cipher cipher, CryptoScheme scheme, SecretKey secreteKey, int cipherMode) {
        this.cipher = cipher;
        this.scheme = scheme;
        this.secreteKey = secreteKey;
        this.cipherMode = cipherMode;
    }

    CryptoCipher recreate() {
        return this.scheme.createCryptoCipher(this.secreteKey, this.cipher.getIV(), this.cipherMode, this.cipher.getProvider());
    }

    byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal();
    }

    byte[] update(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }
}

