/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class JsonSerDeser<T>
extends JsonSerialization<T> {
    public static final String E_NO_DATA = "No data at path";
    public static final String E_DATA_TOO_SHORT = "Data at path too short";
    public static final String E_MISSING_MARKER_STRING = "Missing marker string: ";

    public JsonSerDeser(Class<T> classType) {
        super(classType, false, false);
    }

    public T fromBytes(String path, byte[] bytes) throws IOException {
        return this.fromBytes(path, bytes, "");
    }

    public T fromBytes(String path, byte[] bytes, String marker) throws IOException {
        int len = bytes.length;
        if (len == 0) {
            throw new NoRecordException(path, E_NO_DATA);
        }
        if (StringUtils.isNotEmpty((CharSequence)marker) && len < marker.length()) {
            throw new NoRecordException(path, E_DATA_TOO_SHORT);
        }
        String json = new String(bytes, 0, len, StandardCharsets.UTF_8);
        if (StringUtils.isNotEmpty((CharSequence)marker) && !json.contains(marker)) {
            throw new NoRecordException(path, E_MISSING_MARKER_STRING + marker);
        }
        try {
            return (T)this.fromJson(json);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRecordException(path, e.toString(), e);
        }
    }
}

