/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.classes;

import java.util.Arrays;
import java.util.List;

public class ClassInstanceConfiguration<T> {
    private final Class<? extends T> clazz;
    private final List<Object> arguments;
    private final T instance;

    public ClassInstanceConfiguration(Class<? extends T> clazz, Object ... arguments) {
        this.clazz = clazz;
        this.arguments = Arrays.asList((Object[])arguments.clone());
        this.instance = null;
    }

    public ClassInstanceConfiguration(T instance) {
        this.instance = instance;
        Class<?> instanceClass = instance.getClass();
        this.clazz = instanceClass;
        this.arguments = null;
    }

    protected ClassInstanceConfiguration(ClassInstanceConfiguration<T> configuration) {
        this.instance = configuration.getInstance();
        this.clazz = configuration.getClazz();
        this.arguments = this.instance == null ? Arrays.asList(configuration.getArguments()) : null;
    }

    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    public T getInstance() {
        return this.instance;
    }
}

