/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintsUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.CircularIterator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.LocalAllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithm;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmInput;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmOutput;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmOutputCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.PlacedSchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.SchedulingRequestWithPlacementAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.BatchedRequests;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.NodeCandidateSelector;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlacementAlgorithm
implements ConstraintPlacementAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPlacementAlgorithm.class);
    private static final int RE_ATTEMPT_COUNT = 2;
    private LocalAllocationTagsManager tagsManager;
    private PlacementConstraintManager constraintManager;
    private NodeCandidateSelector nodeSelector;
    private ResourceCalculator resourceCalculator;

    @Override
    public void init(RMContext rmContext) {
        this.tagsManager = new LocalAllocationTagsManager(rmContext.getAllocationTagsManager());
        this.constraintManager = rmContext.getPlacementConstraintManager();
        this.resourceCalculator = rmContext.getScheduler().getResourceCalculator();
        this.nodeSelector = filter -> ((AbstractYarnScheduler)rmContext.getScheduler()).getNodes(filter);
    }

    boolean attemptPlacementOnNode(ApplicationId appId, Resource availableResources, SchedulingRequest schedulingRequest, SchedulerNode schedulerNode, boolean ignoreResourceCheck) throws InvalidAllocationTagsQueryException {
        boolean fitsInNode = ignoreResourceCheck || Resources.fitsIn((ResourceCalculator)this.resourceCalculator, (Resource)schedulingRequest.getResourceSizing().getResources(), (Resource)availableResources);
        boolean constraintsSatisfied = PlacementConstraintsUtil.canSatisfyConstraints(appId, schedulingRequest, schedulerNode, this.constraintManager, this.tagsManager);
        return fitsInNode && constraintsSatisfied;
    }

    @Override
    public void place(ConstraintPlacementAlgorithmInput input, ConstraintPlacementAlgorithmOutputCollector collector) {
        BatchedRequests requests = (BatchedRequests)input;
        int placementAttempt = requests.getPlacementAttempt();
        ConstraintPlacementAlgorithmOutput resp = new ConstraintPlacementAlgorithmOutput(requests.getApplicationId());
        List<SchedulerNode> allNodes = this.nodeSelector.selectNodes(null);
        ArrayList<Object> rejectedRequests = new ArrayList<SchedulingRequest>();
        HashMap<NodeId, Resource> availResources = new HashMap<NodeId, Resource>();
        for (int rePlacementCount = 2; rePlacementCount > 0; --rePlacementCount) {
            this.doPlacement(requests, resp, allNodes, rejectedRequests, availResources);
            this.validatePlacement(requests.getApplicationId(), resp, rejectedRequests, availResources);
            if (rejectedRequests.size() == 0 || rePlacementCount == 1) break;
            requests = new BatchedRequests(requests.getIteratorType(), requests.getApplicationId(), rejectedRequests, requests.getPlacementAttempt());
            rejectedRequests = new ArrayList();
        }
        resp.getRejectedRequests().addAll(rejectedRequests.stream().map(x -> new SchedulingRequestWithPlacementAttempt(placementAttempt, (SchedulingRequest)x)).collect(Collectors.toList()));
        collector.collect(resp);
        this.tagsManager.cleanTempContainers(requests.getApplicationId());
    }

    private void doPlacement(BatchedRequests requests, ConstraintPlacementAlgorithmOutput resp, List<SchedulerNode> allNodes, List<SchedulingRequest> rejectedRequests, Map<NodeId, Resource> availableResources) {
        Iterator<SchedulingRequest> requestIterator = requests.iterator();
        Iterator<SchedulerNode> nIter = allNodes.iterator();
        SchedulerNode lastSatisfiedNode = null;
        while (requestIterator.hasNext()) {
            if (allNodes.isEmpty()) {
                LOG.warn("No nodes available for placement at the moment !!");
                break;
            }
            SchedulingRequest schedulingRequest = requestIterator.next();
            PlacedSchedulingRequest placedReq = new PlacedSchedulingRequest(schedulingRequest);
            placedReq.setPlacementAttempt(requests.getPlacementAttempt());
            resp.getPlacedRequests().add(placedReq);
            CircularIterator<SchedulerNode> nodeIter = new CircularIterator<SchedulerNode>(lastSatisfiedNode, nIter, allNodes);
            int numAllocs = schedulingRequest.getResourceSizing().getNumAllocations();
            while (nodeIter.hasNext() && numAllocs > 0) {
                SchedulerNode node = nodeIter.next();
                try {
                    String tag = schedulingRequest.getAllocationTags() == null ? "" : (String)schedulingRequest.getAllocationTags().iterator().next();
                    Resource unallocatedResource = availableResources.computeIfAbsent(node.getNodeID(), x -> Resource.newInstance((Resource)node.getUnallocatedResource()));
                    if (requests.getBlacklist(tag).contains(node.getNodeID()) || !this.attemptPlacementOnNode(requests.getApplicationId(), unallocatedResource, schedulingRequest, node, false)) continue;
                    schedulingRequest.getResourceSizing().setNumAllocations(--numAllocs);
                    Resources.addTo((Resource)unallocatedResource, (Resource)schedulingRequest.getResourceSizing().getResources());
                    placedReq.getNodes().add(node);
                    numAllocs = schedulingRequest.getResourceSizing().getNumAllocations();
                    this.tagsManager.addTempTags(node.getNodeID(), requests.getApplicationId(), schedulingRequest.getAllocationTags());
                    lastSatisfiedNode = node;
                }
                catch (InvalidAllocationTagsQueryException e) {
                    LOG.warn("Got exception from TagManager !", (Throwable)((Object)e));
                }
            }
        }
        requests.getSchedulingRequests().stream().filter(sReq -> sReq.getResourceSizing().getNumAllocations() > 0).forEach(rejReq -> rejectedRequests.add(DefaultPlacementAlgorithm.cloneReq(rejReq)));
    }

    private void validatePlacement(ApplicationId applicationId, ConstraintPlacementAlgorithmOutput resp, List<SchedulingRequest> rejectedRequests, Map<NodeId, Resource> availableResources) {
        Iterator<PlacedSchedulingRequest> pReqIter = resp.getPlacedRequests().iterator();
        while (pReqIter.hasNext()) {
            PlacedSchedulingRequest pReq = pReqIter.next();
            Iterator<SchedulerNode> nodeIter = pReq.getNodes().iterator();
            int num = 0;
            while (nodeIter.hasNext()) {
                SchedulerNode node = nodeIter.next();
                try {
                    this.tagsManager.removeTempTags(node.getNodeID(), applicationId, pReq.getSchedulingRequest().getAllocationTags());
                    Resource availOnNode = availableResources.get(node.getNodeID());
                    if (!this.attemptPlacementOnNode(applicationId, availOnNode, pReq.getSchedulingRequest(), node, true)) {
                        nodeIter.remove();
                        ++num;
                        Resources.subtractFrom((Resource)availOnNode, (Resource)pReq.getSchedulingRequest().getResourceSizing().getResources());
                        continue;
                    }
                    this.tagsManager.addTempTags(node.getNodeID(), applicationId, pReq.getSchedulingRequest().getAllocationTags());
                }
                catch (InvalidAllocationTagsQueryException e) {
                    LOG.warn("Got exception from TagManager !", (Throwable)((Object)e));
                }
            }
            if (num > 0) {
                SchedulingRequest sReq = DefaultPlacementAlgorithm.cloneReq(pReq.getSchedulingRequest());
                sReq.getResourceSizing().setNumAllocations(num);
                rejectedRequests.add(sReq);
            }
            if (!pReq.getNodes().isEmpty()) continue;
            pReqIter.remove();
        }
    }

    private static SchedulingRequest cloneReq(SchedulingRequest sReq) {
        return SchedulingRequest.newInstance((long)sReq.getAllocationRequestId(), (Priority)sReq.getPriority(), (ExecutionTypeRequest)sReq.getExecutionType(), (Set)sReq.getAllocationTags(), (ResourceSizing)ResourceSizing.newInstance((int)sReq.getResourceSizing().getNumAllocations(), (Resource)sReq.getResourceSizing().getResources()), (PlacementConstraint)sReq.getPlacementConstraint());
    }
}

