/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="The kerberos principal of the service.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KerberosPrincipal
implements Serializable {
    private static final long serialVersionUID = -6431667195287650037L;
    @JsonProperty(value="principal_name")
    @XmlElement(name="principal_name")
    private String principalName = null;
    @JsonProperty(value="keytab")
    @XmlElement(name="keytab")
    private String keytab = null;

    public KerberosPrincipal principalName(String principalName) {
        this.principalName = principalName;
        return this;
    }

    @ApiModelProperty(value="The principal name of the service.")
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public KerberosPrincipal keytab(String keytab) {
        this.keytab = keytab;
        return this;
    }

    @ApiModelProperty(value="The URI of the kerberos keytab. It supports Hadoop supported filesystem types like \"hdfs\", \"file\", \"viewfs\", \"s3\" etc.If the URI starts with \"hdfs://\" scheme, it indicates the path on hdfs where the keytab is stored. The keytab will be localized by YARN and made available to AM in its local directory. If the URI starts with \"file://\" scheme, it indicates a path on the local host where the keytab is presumbaly installed by admins upfront. ")
    public String getKeytab() {
        return this.keytab;
    }

    public void setKeytab(String keytab) {
        this.keytab = keytab;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KerberosPrincipal kerberosPrincipal = (KerberosPrincipal)o;
        return Objects.equals(this.principalName, kerberosPrincipal.principalName) && Objects.equals(this.keytab, kerberosPrincipal.keytab);
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.keytab);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KerberosPrincipal {\n").append("    principalName: ").append(this.toIndentedString(this.principalName)).append("\n").append("    keytab: ").append(this.toIndentedString(this.keytab)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

