/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamenodeHeartbeatService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(NamenodeHeartbeatService.class);
    private Configuration conf;
    private final ActiveNamenodeResolver resolver;
    private final String nameserviceId;
    private final String namenodeId;
    private NNHAServiceTarget localTarget;
    private HAServiceProtocol localTargetHAProtocol;
    private NamenodeProtocol namenodeProtocol;
    private ClientProtocol clientProtocol;
    private String rpcAddress;
    private String serviceAddress;
    private String lifelineAddress;
    private String webAddress;
    private URLConnectionFactory connectionFactory;
    private String scheme;
    private long updateJmxIntervalMs;
    private long lastJmxUpdateAttempt;
    private JSONArray fsNamesystemMetrics;
    private JSONArray namenodeInfoMetrics;
    private String resolvedHost;
    private String originalNnId;
    private int healthMonitorTimeoutMs = (int)RBFConfigKeys.DFS_ROUTER_HEALTH_MONITOR_TIMEOUT_DEFAULT;

    public NamenodeHeartbeatService(ActiveNamenodeResolver resolver, String nsId, String nnId) {
        super(NamenodeHeartbeatService.class.getSimpleName() + (nsId == null ? "" : " " + nsId) + (nnId == null ? "" : " " + nnId));
        this.resolver = resolver;
        this.nameserviceId = nsId;
        this.namenodeId = nnId;
    }

    public NamenodeHeartbeatService(ActiveNamenodeResolver resolver, String nsId, String nnId, String resolvedHost) {
        super(NamenodeHeartbeatService.getNnHeartBeatServiceName(nsId, nnId));
        this.resolver = resolver;
        this.nameserviceId = nsId;
        this.namenodeId = nnId + "-" + resolvedHost;
        this.resolvedHost = resolvedHost;
        this.originalNnId = nnId;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = DFSHAAdmin.addSecurityConfiguration((Configuration)configuration);
        String nnDesc = this.nameserviceId;
        if (this.namenodeId != null && !this.namenodeId.isEmpty()) {
            nnDesc = nnDesc + "-" + this.namenodeId;
        } else {
            this.localTarget = null;
        }
        if (this.originalNnId == null) {
            this.originalNnId = this.namenodeId;
        }
        this.rpcAddress = NamenodeHeartbeatService.getRpcAddress(this.conf, this.nameserviceId, this.originalNnId);
        this.serviceAddress = DFSUtil.getNamenodeServiceAddr((Configuration)this.conf, (String)this.nameserviceId, (String)this.originalNnId);
        if (this.serviceAddress == null) {
            LOG.error("Cannot locate RPC service address for NN {}, using RPC address {}", (Object)nnDesc, (Object)this.rpcAddress);
            this.serviceAddress = this.rpcAddress;
        }
        this.lifelineAddress = DFSUtil.getNamenodeLifelineAddr((Configuration)this.conf, (String)this.nameserviceId, (String)this.originalNnId);
        if (this.lifelineAddress == null) {
            this.lifelineAddress = this.serviceAddress;
        }
        this.webAddress = DFSUtil.getNamenodeWebAddr((Configuration)this.conf, (String)this.nameserviceId, (String)this.originalNnId);
        if (this.resolvedHost != null) {
            this.rpcAddress = this.resolvedHost + ":" + NetUtils.getPortFromHostPortString((String)this.rpcAddress);
            this.serviceAddress = this.resolvedHost + ":" + NetUtils.getPortFromHostPortString((String)this.serviceAddress);
            this.lifelineAddress = this.resolvedHost + ":" + NetUtils.getPortFromHostPortString((String)this.lifelineAddress);
            this.webAddress = this.resolvedHost + ":" + NetUtils.getPortFromHostPortString((String)this.webAddress);
        }
        LOG.info("{} RPC address: {}", (Object)nnDesc, (Object)this.rpcAddress);
        LOG.info("{} Service RPC address: {}", (Object)nnDesc, (Object)this.serviceAddress);
        LOG.info("{} Lifeline RPC address: {}", (Object)nnDesc, (Object)this.lifelineAddress);
        LOG.info("{} Web address: {}", (Object)nnDesc, (Object)this.webAddress);
        if (this.namenodeId != null && !this.namenodeId.isEmpty()) {
            this.localTarget = new NNHAServiceTarget(this.conf, this.nameserviceId, this.namenodeId, this.serviceAddress, this.lifelineAddress);
        }
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)this.conf);
        this.scheme = DFSUtil.getHttpPolicy((Configuration)this.conf).isHttpEnabled() ? "http" : "https";
        this.setIntervalMs(this.conf.getLong("dfs.federation.router.heartbeat.interval", RBFConfigKeys.DFS_ROUTER_HEARTBEAT_INTERVAL_MS_DEFAULT));
        long timeoutMs = this.conf.getTimeDuration("dfs.federation.router.health.monitor.timeout", RBFConfigKeys.DFS_ROUTER_HEALTH_MONITOR_TIMEOUT_DEFAULT, TimeUnit.MILLISECONDS);
        if (timeoutMs < 0L) {
            LOG.warn("Invalid value {} configured for {} should be greater than or equal to 0. Using value of : 0ms instead.", (Object)timeoutMs, (Object)"dfs.federation.router.health.monitor.timeout");
            this.healthMonitorTimeoutMs = 0;
        } else {
            this.healthMonitorTimeoutMs = (int)timeoutMs;
        }
        this.updateJmxIntervalMs = this.conf.getTimeDuration("dfs.federation.router.namenode.heartbeat.jmx.interval", 0L, TimeUnit.MILLISECONDS);
        super.serviceInit(configuration);
    }

    @Override
    public void periodicInvoke() {
        try {
            SecurityUtil.doAsLoginUser(() -> {
                this.updateState();
                return null;
            });
        }
        catch (IOException e) {
            LOG.error("Cannot update namenode state", (Throwable)e);
        }
    }

    private static String getRpcAddress(Configuration conf, String nsId, String nnId) {
        String confKey = "dfs.namenode.rpc-address";
        String ret = conf.get(confKey);
        if ((nsId != null || nnId != null) && (ret = conf.get(confKey = DFSUtil.addKeySuffixes((String)confKey, (String[])new String[]{nsId, nnId}))) == null) {
            Map rpcAddresses = DFSUtil.getRpcAddressesForNameserviceId((Configuration)conf, (String)nsId, null);
            InetSocketAddress sockAddr = null;
            if (nnId != null) {
                sockAddr = (InetSocketAddress)rpcAddresses.get(nnId);
            } else if (rpcAddresses.size() == 1) {
                sockAddr = (InetSocketAddress)rpcAddresses.values().iterator().next();
            }
            if (sockAddr != null) {
                InetAddress addr = sockAddr.getAddress();
                ret = addr.getHostName() + ":" + sockAddr.getPort();
            }
        }
        return ret;
    }

    private void updateState() {
        NamenodeStatusReport report = this.getNamenodeStatusReport();
        if (!report.registrationValid()) {
            LOG.error("Namenode is not operational: {}", (Object)this.getNamenodeDesc());
        } else if (report.haStateValid()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received service state: {} from HA namenode: {}", (Object)report.getState(), (Object)this.getNamenodeDesc());
            }
        } else if (this.localTarget == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reporting non-HA namenode as operational: {}", (Object)this.getNamenodeDesc());
            }
        } else {
            return;
        }
        try {
            if (!this.resolver.registerNamenode(report)) {
                LOG.warn("Cannot register namenode {}", (Object)report);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot register namenode {} in the State Store", (Object)this.getNamenodeDesc(), (Object)e);
        }
    }

    protected NamenodeStatusReport getNamenodeStatusReport() {
        NamenodeStatusReport report = new NamenodeStatusReport(this.nameserviceId, this.namenodeId, this.rpcAddress, this.serviceAddress, this.lifelineAddress, this.scheme, this.webAddress);
        try {
            LOG.debug("Probing NN at service address: {}", (Object)this.serviceAddress);
            URI serviceURI = new URI("hdfs://" + this.serviceAddress);
            this.updateNameSpaceInfoParameters(serviceURI, report);
            if (!report.registrationValid()) {
                return report;
            }
            this.updateSafeModeParameters(serviceURI, report);
            this.updateJMXParameters(this.webAddress, report);
            this.updateHAStatusParameters(report);
        }
        catch (IOException e) {
            LOG.error("Cannot communicate with {}: {}", (Object)this.getNamenodeDesc(), (Object)e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception while communicating with {}: {}", new Object[]{this.getNamenodeDesc(), e.getMessage(), e});
        }
        return report;
    }

    @VisibleForTesting
    NNHAServiceTarget getLocalTarget() {
        return this.localTarget;
    }

    public String getNamenodeDesc() {
        if (this.namenodeId != null && !this.namenodeId.isEmpty()) {
            return this.nameserviceId + "-" + this.namenodeId + ":" + this.serviceAddress;
        }
        return this.nameserviceId + ":" + this.serviceAddress;
    }

    private static String getNnHeartBeatServiceName(String nsId, String nnId) {
        return NamenodeHeartbeatService.class.getSimpleName() + (nsId == null ? "" : " " + nsId) + (nnId == null ? "" : " " + nnId);
    }

    private void updateNameSpaceInfoParameters(URI serviceURI, NamenodeStatusReport report) throws IOException {
        try {
            NamespaceInfo info;
            if (this.namenodeProtocol == null) {
                this.namenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)this.conf, (URI)serviceURI, NamenodeProtocol.class).getProxy();
            }
            if (this.namenodeProtocol != null && (info = this.namenodeProtocol.versionRequest()) != null) {
                report.setNamespaceInfo(info);
            }
        }
        catch (IOException e) {
            this.namenodeProtocol = null;
            throw e;
        }
    }

    private void updateSafeModeParameters(URI serviceURI, NamenodeStatusReport report) {
        try {
            if (this.clientProtocol == null) {
                this.clientProtocol = (ClientProtocol)NameNodeProxies.createProxy((Configuration)this.conf, (URI)serviceURI, ClientProtocol.class).getProxy();
            }
            if (this.clientProtocol != null) {
                boolean isSafeMode = this.clientProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
                report.setSafeMode(isSafeMode);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot fetch safemode state for {}", (Object)this.getNamenodeDesc(), (Object)e);
            this.clientProtocol = null;
        }
    }

    private void updateJMXParameters(String address, NamenodeStatusReport report) {
        try {
            if (this.shouldUpdateJmx()) {
                this.lastJmxUpdateAttempt = Time.monotonicNow();
                this.getFsNamesystemMetrics(address);
                this.getNamenodeInfoMetrics(address);
            }
            this.populateFsNamesystemMetrics(this.fsNamesystemMetrics, report);
            this.populateNamenodeInfoMetrics(this.namenodeInfoMetrics, report);
        }
        catch (Exception e) {
            LOG.error("Cannot get stat from {} using JMX", (Object)this.getNamenodeDesc(), (Object)e);
        }
    }

    private void updateHAStatusParameters(NamenodeStatusReport report) {
        if (this.localTarget != null) {
            try {
                if (this.localTargetHAProtocol == null) {
                    this.localTargetHAProtocol = this.localTarget.getHealthMonitorProxy(this.conf, this.healthMonitorTimeoutMs);
                    LOG.debug("Get HA status with address {}", (Object)this.lifelineAddress);
                }
                HAServiceStatus status = this.localTargetHAProtocol.getServiceStatus();
                report.setHAServiceState(status.getState());
            }
            catch (Throwable e) {
                if (e.getMessage().startsWith("HA for namenode is not enabled")) {
                    LOG.error("HA for {} is not enabled", (Object)this.getNamenodeDesc());
                    this.localTarget = null;
                } else {
                    LOG.error("Cannot fetch HA status for {}", (Object)this.getNamenodeDesc(), (Object)e);
                }
                this.localTargetHAProtocol = null;
            }
        }
    }

    private boolean shouldUpdateJmx() {
        if (this.updateJmxIntervalMs < 0L) {
            return false;
        }
        return Time.monotonicNow() - this.lastJmxUpdateAttempt > this.updateJmxIntervalMs;
    }

    private void getNamenodeInfoMetrics(String address) {
        String query = "Hadoop:service=NameNode,name=NameNodeInfo";
        this.namenodeInfoMetrics = FederationUtil.getJmx(query, address, this.connectionFactory, this.scheme);
    }

    private void populateNamenodeInfoMetrics(JSONArray aux, NamenodeStatusReport report) throws JSONException {
        JSONObject jsonObject;
        String name;
        if (aux != null && aux.length() > 0 && (name = (jsonObject = aux.getJSONObject(0)).getString("name")).equals("Hadoop:service=NameNode,name=NameNodeInfo")) {
            report.setNamenodeInfo(jsonObject.optInt("CorruptFilesCount"), jsonObject.optLong("NumberOfMissingBlocksWithReplicationFactorOne"), jsonObject.optLong("HighestPriorityLowRedundancyReplicatedBlocks"), jsonObject.optLong("HighestPriorityLowRedundancyECBlocks"));
        }
    }

    private void getFsNamesystemMetrics(String address) {
        String query = "Hadoop:service=NameNode,name=FSNamesystem*";
        this.fsNamesystemMetrics = FederationUtil.getJmx(query, address, this.connectionFactory, this.scheme);
    }

    private void populateFsNamesystemMetrics(JSONArray aux, NamenodeStatusReport report) throws JSONException {
        if (aux != null) {
            for (int i = 0; i < aux.length(); ++i) {
                JSONObject jsonObject = aux.getJSONObject(i);
                String name = jsonObject.getString("name");
                if (name.equals("Hadoop:service=NameNode,name=FSNamesystemState")) {
                    report.setDatanodeInfo(jsonObject.getInt("NumLiveDataNodes"), jsonObject.getInt("NumDeadDataNodes"), jsonObject.getInt("NumStaleDataNodes"), jsonObject.getInt("NumDecommissioningDataNodes"), jsonObject.getInt("NumDecomLiveDataNodes"), jsonObject.getInt("NumDecomDeadDataNodes"), jsonObject.optInt("NumInMaintenanceLiveDataNodes"), jsonObject.optInt("NumInMaintenanceDeadDataNodes"), jsonObject.optInt("NumEnteringMaintenanceDataNodes"), jsonObject.optLong("ScheduledReplicationBlocks"));
                    continue;
                }
                if (!name.equals("Hadoop:service=NameNode,name=FSNamesystem")) continue;
                report.setNamesystemInfo(jsonObject.getLong("CapacityRemaining"), jsonObject.getLong("CapacityTotal"), jsonObject.getLong("FilesTotal"), jsonObject.getLong("BlocksTotal"), jsonObject.getLong("MissingBlocks"), jsonObject.getLong("PendingReplicationBlocks"), jsonObject.getLong("UnderReplicatedBlocks"), jsonObject.getLong("PendingDeletionBlocks"), jsonObject.optLong("ProvidedCapacityTotal"), jsonObject.getInt("PendingSPSPaths"));
            }
        }
    }

    @Override
    protected void serviceStop() throws Exception {
        LOG.info("Stopping NamenodeHeartbeat service for, NS {} NN {} ", (Object)this.nameserviceId, (Object)this.namenodeId);
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
        }
        super.serviceStop();
    }
}

