/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import java.io.IOException;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.DefaultLogicalIOImpl;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetPrefetcher;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class ParquetLogicalIOImpl
extends DefaultLogicalIOImpl {
    private final ParquetPrefetcher parquetPrefetcher;

    public ParquetLogicalIOImpl(@NonNull S3URI s3Uri, @NonNull PhysicalIO physicalIO, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull ParquetColumnPrefetchStore parquetColumnPrefetchStore) {
        super(s3Uri, physicalIO, telemetry);
        if (s3Uri == null) {
            throw new NullPointerException("s3Uri is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (parquetColumnPrefetchStore == null) {
            throw new NullPointerException("parquetColumnPrefetchStore is marked non-null but is null");
        }
        this.parquetPrefetcher = new ParquetPrefetcher(s3Uri, physicalIO, telemetry, logicalIOConfiguration, parquetColumnPrefetchStore);
        this.parquetPrefetcher.prefetchFooterAndBuildMetadata();
    }

    @Override
    public int read(byte[] buf, int off, int len, long position) throws IOException {
        this.parquetPrefetcher.prefetchRemainingColumnChunk(position, len);
        this.parquetPrefetcher.addToRecentColumnList(position, len);
        return super.read(buf, off, len, position);
    }
}

