/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.MapTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsView;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class HsTaskPage
extends HsView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:2}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"attempts"), this.attemptsTableInit());
        this.set(JQueryUI.postInitID((String)"ui.dataTables", (String)"attempts"), this.attemptsPostTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        } else {
            TaskId taskID = MRApps.toTaskID((String)this.$("task.id"));
            type = taskID.getTaskType();
        }
        StringBuilder b = JQueryUI.tableInit().append(", 'aaData': attemptsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n,aoColumnDefs:[\n").append("\n{'aTargets': [ 4 ]").append(", 'bSearchable': false }").append("\n, {'sType':'natural', 'aTargets': [ 0 ]").append(", 'mRender': parseHadoopID }").append("\n, {'sType':'numeric', 'aTargets': [ 5, 6").append(type == TaskType.REDUCE ? ", 7, 8" : "").append(" ], 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', 'aTargets': [").append(type == TaskType.REDUCE ? "9, 10, 11, 12" : "7").append(" ], 'mRender': renderHadoopElapsedTime }]").append("\n, aaSorting: [[0, 'asc']]").append("}");
        return b.toString();
    }

    private String attemptsPostTableInit() {
        return "var asInitVals = new Array();\n$('tfoot input').keyup( function () \n{  attemptsDataTable.fnFilter( this.value, $('tfoot input').index(this) );\n} );\n$('tfoot input').each( function (i) {\n  asInitVals[i] = this.value;\n} );\n$('tfoot input').focus( function () {\n  if ( this.className == 'search_init' )\n  {\n    this.className = '';\n    this.value = '';\n  }\n} );\n$('tfoot input').blur( function (i) {\n  if ( this.value == '' )\n  {\n    this.className = 'search_init';\n    this.value = asInitVals[$('tfoot input').index(this)];\n  }\n} );\n";
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;
        final Configuration conf;

        @Inject
        AttemptsBlock(App ctx, Configuration conf) {
            this.app = ctx;
            this.conf = conf;
        }

        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            TaskType type = null;
            String symbol = this.$("task.type");
            type = !symbol.isEmpty() ? MRApps.taskType((String)symbol) : this.app.getTask().getType();
            Hamlet.TR headRow = html.table("#attempts").thead().tr();
            headRow.th(".id", "Attempt").th(".state", "State").th(".status", "Status").th(".node", "Node").th(".logs", "Logs").th(".tsh", "Start Time");
            if (type == TaskType.REDUCE) {
                headRow.th("Shuffle Finish Time");
                headRow.th("Merge Finish Time");
            }
            headRow.th("Finish Time");
            if (type == TaskType.REDUCE) {
                headRow.th("Elapsed Time Shuffle");
                headRow.th("Elapsed Time Merge");
                headRow.th("Elapsed Time Reduce");
            }
            headRow.th("Elapsed Time").th(".note", "Note");
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)headRow.__()).__()).tbody();
            StringBuilder attemptsTableData = new StringBuilder("[\n");
            for (TaskAttempt attempt : this.getTaskAttempts()) {
                MapTaskAttemptInfo ta = new MapTaskAttemptInfo(attempt, Boolean.valueOf(false));
                String taid = ta.getId();
                String nodeHttpAddr = ta.getNode();
                String containerIdString = ta.getAssignedContainerIdStr();
                String nodeIdString = attempt.getAssignedContainerMgrAddress();
                String nodeRackName = ta.getRack();
                long attemptStartTime = ta.getStartTime();
                long shuffleFinishTime = -1L;
                long sortFinishTime = -1L;
                long attemptFinishTime = ta.getFinishTime();
                long elapsedShuffleTime = -1L;
                long elapsedSortTime = -1L;
                long elapsedReduceTime = -1L;
                if (type == TaskType.REDUCE) {
                    shuffleFinishTime = attempt.getShuffleFinishTime();
                    sortFinishTime = attempt.getSortFinishTime();
                    elapsedShuffleTime = Times.elapsed((long)attemptStartTime, (long)shuffleFinishTime, (boolean)false);
                    elapsedSortTime = Times.elapsed((long)shuffleFinishTime, (long)sortFinishTime, (boolean)false);
                    elapsedReduceTime = Times.elapsed((long)sortFinishTime, (long)attemptFinishTime, (boolean)false);
                }
                long attemptElapsed = Times.elapsed((long)attemptStartTime, (long)attemptFinishTime, (boolean)false);
                TaskId taskId = attempt.getID().getTaskId();
                attemptsTableData.append("[\"").append(this.getAttemptId(taskId, (TaskAttemptInfo)ta)).append("\",\"").append(ta.getState()).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)ta.getStatus()))).append("\",\"").append("<a class='nodelink' href='" + MRWebAppUtil.getYARNWebappScheme() + nodeHttpAddr + "'>").append(nodeRackName + "/" + nodeHttpAddr + "</a>\",\"");
                String logsUrl = this.url(new String[]{"logs", nodeIdString, containerIdString, taid, this.app.getJob().getUserName()});
                if (!this.conf.getBoolean("yarn.log-aggregation-enable", false)) {
                    logsUrl = this.url(new String[]{MRWebAppUtil.getYARNWebappScheme(), nodeHttpAddr, "node", "containerlogs", containerIdString, this.app.getJob().getUserName()});
                }
                attemptsTableData.append("<a class='logslink' href='").append(logsUrl).append("'>logs</a>\",\"");
                attemptsTableData.append(attemptStartTime).append("\",\"");
                if (type == TaskType.REDUCE) {
                    attemptsTableData.append(shuffleFinishTime).append("\",\"").append(sortFinishTime).append("\",\"");
                }
                attemptsTableData.append(attemptFinishTime).append("\",\"");
                if (type == TaskType.REDUCE) {
                    attemptsTableData.append(elapsedShuffleTime).append("\",\"").append(elapsedSortTime).append("\",\"").append(elapsedReduceTime).append("\",\"");
                }
                attemptsTableData.append(attemptElapsed).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)ta.getNote()))).append("\"],\n");
            }
            if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
                attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
            }
            attemptsTableData.append("]");
            html.script().$type("text/javascript").__(new Object[]{"var attemptsTableData=" + attemptsTableData}).__();
            Hamlet.TR footRow = ((Hamlet.TABLE)tbody.__()).tfoot().tr();
            ((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_name").$value("Attempt").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_state").$value("State").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_status").$value("Status").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_node").$value("Node").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_node").$value("Logs").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_start_time").$value("Start Time").__()).__();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("shuffle_time").$value("Shuffle Time").__()).__();
                ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("merge_time").$value("Merge Time").__()).__();
            }
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_finish").$value("Finish Time").__()).__();
            if (type == TaskType.REDUCE) {
                ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_shuffle_time").$value("Elapsed Shuffle Time").__()).__();
                ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_merge_time").$value("Elapsed Merge Time").__()).__();
                ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_reduce_time").$value("Elapsed Reduce Time").__()).__();
            }
            ((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_elapsed").$value("Elapsed Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("note").$value("Note").__()).__();
            ((Hamlet.TABLE)((Hamlet.TFOOT)footRow.__()).__()).__();
        }

        protected String getAttemptId(TaskId taskId, TaskAttemptInfo ta) {
            return ta.getId();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

