/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.series.MappedIndexSeries;
import org.ojalgo.series.TreeSeries;

public final class NumberSeries<N extends Number>
extends TreeSeries<N, N, NumberSeries<N>> {
    public NumberSeries() {
    }

    public NumberSeries(Map<? extends N, ? extends N> map) {
        super(map);
    }

    public NumberSeries(SortedMap<N, ? extends N> sortedMap) {
        super(sortedMap);
    }

    public Access1D<N> accessKeys() {
        return ArrayUtils.wrapAccess1D(new ArrayList(this.keySet()));
    }

    public Access1D<N> accessValues() {
        return ArrayUtils.wrapAccess1D(new ArrayList(this.values()));
    }

    @Override
    public N get(long key) {
        return (N)this.get(MappedIndexSeries.toKey(key));
    }

    @Override
    public N get(N key) {
        return (N)((Number)this.get(key));
    }

    public double invoke(double arg) {
        ProgrammingError.throwForIllegalInvocation();
        return Double.NaN;
    }

    public N invoke(N arg) {
        return this.get(arg);
    }

    @Override
    public double put(N key, double value) {
        Double tmpValue = value;
        Number tmpOldValue = super.put(key, tmpValue);
        if (tmpOldValue != null) {
            return tmpOldValue.doubleValue();
        }
        return Double.NaN;
    }
}

