/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.offheap.bytez.malloc;

import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.BasicBytez;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.Bytez;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.malloc.MallocBytezAllocator;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.onheap.HeapBytez;
import org.apache.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;
import sun.misc.Unsafe;

public class MallocBytez
implements Bytez {
    static Unsafe unsafe = FSTUtil.getUnsafe();
    static long byteoff = FSTUtil.bufoff;
    static long caoff = FSTUtil.choff;
    static long saoff = FSTUtil.choff;
    static long iaoff = FSTUtil.intoff;
    static long laoff = FSTUtil.longoff;
    static long daoff = FSTUtil.doubleoff;
    static long faoff = FSTUtil.floatoff;
    protected long baseAdress;
    protected long length;

    public MallocBytez(long adr, long len) {
        this.setBase(adr, len);
    }

    public void setBase(long adr, long len) {
        this.baseAdress = adr;
        this.length = len;
    }

    @Override
    public MallocBytez slice(long off, int len) {
        if (off + (long)len >= this.length) {
            throw new RuntimeException("invalid slice " + off + ":" + len + " mylen:" + this.length);
        }
        return new MallocBytez(this.baseAdress + off, len);
    }

    @Override
    public byte get(long byteIndex) {
        return unsafe.getByte(this.baseAdress + byteIndex);
    }

    @Override
    public boolean getBool(long byteIndex) {
        return unsafe.getByte(this.baseAdress + byteIndex) != 0;
    }

    @Override
    public char getChar(long byteIndex) {
        return unsafe.getChar(this.baseAdress + byteIndex);
    }

    @Override
    public short getShort(long byteIndex) {
        return unsafe.getShort(this.baseAdress + byteIndex);
    }

    @Override
    public int getInt(long byteIndex) {
        int res = unsafe.getInt(this.baseAdress + byteIndex);
        return res;
    }

    @Override
    public long getLong(long byteIndex) {
        return unsafe.getLong(this.baseAdress + byteIndex);
    }

    @Override
    public float getFloat(long byteIndex) {
        return unsafe.getFloat(this.baseAdress + byteIndex);
    }

    @Override
    public double getDouble(long byteIndex) {
        return unsafe.getDouble(this.baseAdress + byteIndex);
    }

    @Override
    public void put(long byteIndex, byte value) {
        unsafe.putByte(this.baseAdress + byteIndex, value);
    }

    @Override
    public void putBool(long byteIndex, boolean val) {
        this.put(byteIndex, (byte)(val ? 1 : 0));
    }

    @Override
    public void putChar(long byteIndex, char c) {
        unsafe.putChar(this.baseAdress + byteIndex, c);
    }

    @Override
    public void putShort(long byteIndex, short s) {
        unsafe.putShort(this.baseAdress + byteIndex, s);
    }

    @Override
    public void putInt(long byteIndex, int i) {
        unsafe.putInt(this.baseAdress + byteIndex, i);
    }

    @Override
    public void putLong(long byteIndex, long l) {
        unsafe.putLong(this.baseAdress + byteIndex, l);
    }

    @Override
    public void putFloat(long byteIndex, float f) {
        unsafe.putFloat(this.baseAdress + byteIndex, f);
    }

    @Override
    public void putDouble(long byteIndex, double d) {
        unsafe.putDouble(this.baseAdress + byteIndex, d);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, byteoff + (long)elemoff, numElems);
    }

    @Override
    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, caoff + (long)(elemoff * 2), numElems * 2);
    }

    @Override
    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, saoff + (long)(elemoff * 2), numElems * 2);
    }

    @Override
    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, iaoff + (long)(elemoff * 4), numElems * 4);
    }

    @Override
    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, laoff + (long)(elemoff * 8), numElems * 8);
    }

    @Override
    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, faoff + (long)(elemoff * 4), numElems * 4);
    }

    @Override
    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        unsafe.copyMemory(null, this.baseAdress + byteIndex, target, daoff + (long)(elemoff * 8), numElems * 8);
    }

    @Override
    public void getBooleanArr(long byteIndex, boolean[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getBool(byteIndex + (long)i);
        }
    }

    @Override
    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, byteoff + (long)elemoff, null, this.baseAdress + byteIndex, numElems);
    }

    @Override
    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + (long)(elemoff * 2), null, this.baseAdress + byteIndex, numElems * 2);
    }

    @Override
    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, caoff + (long)(elemoff * 2), null, this.baseAdress + byteIndex, numElems * 2);
    }

    @Override
    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, iaoff + (long)(elemoff * 4), null, this.baseAdress + byteIndex, numElems * 4);
    }

    @Override
    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, laoff + (long)(elemoff * 8), null, this.baseAdress + byteIndex, numElems * 8);
    }

    @Override
    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, faoff + (long)(elemoff * 4), null, this.baseAdress + byteIndex, numElems * 4);
    }

    @Override
    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        unsafe.copyMemory(source, daoff + (long)(elemoff * 8), null, this.baseAdress + byteIndex, numElems * 8);
    }

    @Override
    public void setBoolean(long byteIndex, boolean[] o, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + (long)i, (byte)(o[i + elemoff] ? 1 : 0));
        }
    }

    @Override
    public void copyTo(BasicBytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        if (other instanceof HeapBytez) {
            HeapBytez hp = (HeapBytez)other;
            unsafe.copyMemory(null, this.baseAdress + myByteIndex, hp.getBase(), hp.getOff() + otherByteIndex, lenBytes);
        } else {
            for (long i = 0L; i < lenBytes; ++i) {
                other.put(otherByteIndex + i, this.get(myByteIndex + i));
            }
        }
    }

    @Override
    public BasicBytez newInstance(long size) {
        return new MallocBytez(unsafe.allocateMemory(size), size);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expect, int newVal) {
        return unsafe.compareAndSwapInt(null, this.baseAdress + offset, expect, newVal);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expect, long newVal) {
        return unsafe.compareAndSwapLong(null, this.baseAdress + offset, expect, newVal);
    }

    @Override
    public byte[] toBytes(long startIndex, int len) {
        byte[] res = new byte[len];
        unsafe.copyMemory(null, this.baseAdress + startIndex, res, FSTUtil.bufoff, len);
        return res;
    }

    @Override
    public byte[] asByteArray() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    @Override
    public int getBAOffsetIndex() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    @Override
    public int getBALength() {
        throw new RuntimeException("malloc bytez do not support this");
    }

    public int hashCode() {
        return (int)(this.baseAdress ^ this.baseAdress >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MallocBytez) {
            return this.baseAdress == ((MallocBytez)obj).baseAdress && this.length == ((MallocBytez)obj).length;
        }
        return false;
    }

    @Override
    public boolean getBoolVolatile(long byteIndex) {
        return this.getVolatile(byteIndex) != 0;
    }

    @Override
    public byte getVolatile(long byteIndex) {
        return unsafe.getByteVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public char getCharVolatile(long byteIndex) {
        return unsafe.getCharVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public short getShortVolatile(long byteIndex) {
        return unsafe.getShortVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public int getIntVolatile(long byteIndex) {
        return unsafe.getIntVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public long getLongVolatile(long byteIndex) {
        return unsafe.getLongVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public float getFloatVolatile(long byteIndex) {
        return unsafe.getFloatVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public double getDoubleVolatile(long byteIndex) {
        return unsafe.getDoubleVolatile(null, this.baseAdress + byteIndex);
    }

    @Override
    public void putBoolVolatile(long byteIndex, boolean value) {
        this.putVolatile(byteIndex, (byte)(value ? 1 : 0));
    }

    @Override
    public void putVolatile(long byteIndex, byte value) {
        unsafe.putByteVolatile(null, this.baseAdress + byteIndex, value);
    }

    @Override
    public void putCharVolatile(long byteIndex, char c) {
        unsafe.putCharVolatile(null, this.baseAdress + byteIndex, c);
    }

    @Override
    public void putShortVolatile(long byteIndex, short s) {
        unsafe.putShortVolatile(null, this.baseAdress + byteIndex, s);
    }

    @Override
    public void putIntVolatile(long byteIndex, int i) {
        unsafe.putIntVolatile(null, this.baseAdress + byteIndex, i);
    }

    @Override
    public void putLongVolatile(long byteIndex, long l) {
        unsafe.putLongVolatile(null, this.baseAdress + byteIndex, l);
    }

    @Override
    public void putFloatVolatile(long byteIndex, float f) {
        unsafe.putFloatVolatile(null, this.baseAdress + byteIndex, f);
    }

    @Override
    public void putDoubleVolatile(long byteIndex, double d) {
        unsafe.putDoubleVolatile(null, this.baseAdress + byteIndex, d);
    }

    void free() {
        unsafe.freeMemory(this.baseAdress);
        MallocBytezAllocator.alloced.addAndGet(-this.length);
    }

    public long getBaseAdress() {
        return this.baseAdress;
    }

    public long getLength() {
        return this.length;
    }

    public void clear() {
        unsafe.setMemory(this.baseAdress, this.length, (byte)0);
    }
}

