/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.objenesis.instantiator.sun;

import java.io.NotSerializableException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.shaded.org.objenesis.ObjenesisException;
import org.apache.hadoop.shaded.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.hadoop.shaded.org.objenesis.instantiator.SerializationInstantiatorHelper;
import org.apache.hadoop.shaded.org.objenesis.instantiator.annotations.Instantiator;
import org.apache.hadoop.shaded.org.objenesis.instantiator.annotations.Typology;
import org.apache.hadoop.shaded.org.objenesis.instantiator.sun.SunReflectionFactoryHelper;

@Instantiator(value=Typology.SERIALIZATION)
public class SunReflectionFactorySerializationInstantiator<T>
implements ObjectInstantiator<T> {
    private final Constructor<T> mungedConstructor;

    public SunReflectionFactorySerializationInstantiator(Class<T> type) {
        Constructor<T> nonSerializableAncestorConstructor;
        Class<T> nonSerializableAncestor = SerializationInstantiatorHelper.getNonSerializableSuperClass(type);
        try {
            nonSerializableAncestorConstructor = nonSerializableAncestor.getDeclaredConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(new NotSerializableException(type + " has no suitable superclass constructor"));
        }
        this.mungedConstructor = SunReflectionFactoryHelper.newConstructorForSerialization(type, nonSerializableAncestorConstructor);
        this.mungedConstructor.setAccessible(true);
    }

    @Override
    public T newInstance() {
        try {
            return this.mungedConstructor.newInstance(null);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

