/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DefaultOOMHandler
implements Runnable {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultOOMHandler.class);
    private final Context context;
    private final String memoryStatFile;
    private final CGroupsHandler cgroups;

    public DefaultOOMHandler(Context context, boolean enforceVirtualMemory) {
        this.context = context;
        this.memoryStatFile = enforceVirtualMemory ? "memsw.usage_in_bytes" : "usage_in_bytes";
        this.cgroups = this.getCGroupsHandler();
    }

    @VisibleForTesting
    protected CGroupsHandler getCGroupsHandler() {
        return ResourceHandlerModule.getCGroupsHandler();
    }

    private boolean isContainerOutOfLimit(Container container) {
        boolean outOfLimit = false;
        String value = null;
        try {
            value = this.cgroups.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, container.getContainerId().toString(), this.memoryStatFile);
            long usage = Long.parseLong(value);
            long request = container.getResource().getMemorySize() * 1024L * 1024L;
            if (usage > request) {
                outOfLimit = true;
                String message = String.format("Container %s is out of its limits, using %d when requested only %d", container.getContainerId(), usage, request);
                LOG.warn(message);
            }
        }
        catch (ResourceHandlerException ex) {
            LOG.warn(String.format("Could not access memory resource for %s", container.getContainerId()), (Throwable)((Object)ex));
        }
        catch (NumberFormatException ex) {
            LOG.warn(String.format("Could not parse %s in %s", value, container.getContainerId()));
        }
        return outOfLimit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sigKill(Container container) {
        boolean containerKilled = false;
        boolean finished = false;
        block6: while (true) {
            try {
                while (!finished) {
                    String[] pids = this.cgroups.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, container.getContainerId().toString(), "cgroup.procs").split("\n");
                    finished = true;
                    for (String pid : pids) {
                        if (pid == null || pid.isEmpty()) continue;
                        LOG.debug(String.format("Terminating container %s Sending SIGKILL to -%s", container.getContainerId().toString(), pid));
                        finished = false;
                        try {
                            this.context.getContainerExecutor().signalContainer(new ContainerSignalContext.Builder().setContainer(container).setUser(container.getUser()).setPid(pid).setSignal(ContainerExecutor.Signal.KILL).build());
                        }
                        catch (IOException ex) {
                            LOG.warn(String.format("Cannot kill container %s pid -%s.", container.getContainerId(), pid), (Throwable)ex);
                        }
                    }
                    try {
                        Thread.sleep(10L);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Interrupted while waiting for processes to disappear");
                    }
                }
                return true;
            }
            catch (ResourceHandlerException ex) {
                LOG.warn(String.format("Cannot list more tasks in container %s to kill.", container.getContainerId()));
                return containerKilled;
            }
        }
    }

    @Override
    public void run() {
        try {
            String status;
            while ((status = this.cgroups.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, "", "oom_control")).contains("under_oom 1")) {
                boolean containerKilled = this.killContainer();
                if (containerKilled) continue;
                throw new YarnRuntimeException("Could not find any containers but CGroups reserved for containers ran out of memory. I am giving up");
            }
        }
        catch (ResourceHandlerException ex) {
            LOG.warn("Could not fetch OOM status. This is expected at shutdown. Exiting.", (Throwable)((Object)ex));
        }
    }

    protected boolean killContainer() {
        boolean containerKilled = false;
        ArrayList<ContainerCandidate> candidates = new ArrayList<ContainerCandidate>(0);
        for (Container container : this.context.getContainers().values()) {
            if (!container.isRunning()) continue;
            candidates.add(new ContainerCandidate(container, this.isContainerOutOfLimit(container)));
        }
        Collections.sort(candidates);
        if (candidates.isEmpty()) {
            LOG.warn("Found no running containers to kill in order to release memory");
        }
        for (int i = 0; !containerKilled && i < candidates.size(); ++i) {
            ContainerCandidate candidate = (ContainerCandidate)candidates.get(i);
            if (!this.sigKill(candidate.container)) continue;
            String message = String.format("container %s killed by elastic cgroups OOM handler.", candidate.container.getContainerId());
            LOG.warn(message);
            containerKilled = true;
        }
        return containerKilled;
    }

    private static class ContainerCandidate
    implements Comparable<ContainerCandidate> {
        private final boolean outOfLimit;
        final Container container;

        ContainerCandidate(Container container, boolean outOfLimit) {
            this.outOfLimit = outOfLimit;
            this.container = container;
        }

        @Override
        public int compareTo(ContainerCandidate o) {
            boolean isThisOpportunistic = ContainerCandidate.isOpportunistic(this.container);
            boolean isOtherOpportunistic = ContainerCandidate.isOpportunistic(o.container);
            int ret = Boolean.compare(isOtherOpportunistic, isThisOpportunistic);
            if (ret == 0) {
                int outOfLimitRet = Boolean.compare(o.outOfLimit, this.outOfLimit);
                ret = outOfLimitRet == 0 ? Long.compare(o.container.getContainerLaunchTime(), this.container.getContainerLaunchTime()) : outOfLimitRet;
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerCandidate other = (ContainerCandidate)obj;
            if (this.outOfLimit != other.outOfLimit) {
                return false;
            }
            if (this.container == null) {
                return other.container == null;
            }
            return this.container.equals(other.container);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.container).append(this.outOfLimit).toHashCode();
        }

        private static boolean isOpportunistic(Container container) {
            return container.getContainerTokenIdentifier() != null && ExecutionType.OPPORTUNISTIC.equals((Object)container.getContainerTokenIdentifier().getExecutionType());
        }
    }
}

