/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.records;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceFile;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuxServiceConfiguration {
    private Map<String, String> properties = new HashMap<String, String>();
    private List<AuxServiceFile> files = new ArrayList<AuxServiceFile>();

    public AuxServiceConfiguration properties(Map<String, String> props) {
        this.properties = props;
        return this;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public AuxServiceConfiguration files(List<AuxServiceFile> fileList) {
        this.files = fileList;
        return this;
    }

    @JsonProperty(value="files")
    public List<AuxServiceFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<AuxServiceFile> files) {
        this.files = files;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name.trim());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuxServiceConfiguration configuration = (AuxServiceConfiguration)o;
        return Objects.equals(this.properties, configuration.properties) && Objects.equals(this.files, configuration.files);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Configuration {\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

