/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.DurationInfo;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDurationInfo {
    private final Logger log = LoggerFactory.getLogger(TestDurationInfo.class);

    @Test
    public void testDurationInfoCreation() throws Exception {
        DurationInfo info = new DurationInfo(this.log, "test", new Object[0]);
        Assert.assertTrue((info.value() >= 0L ? 1 : 0) != 0);
        Thread.sleep(1000L);
        info.finished();
        Assert.assertTrue((info.value() > 0L ? 1 : 0) != 0);
        info = new DurationInfo(this.log, true, "test format %s", new Object[]{"value"});
        Assert.assertEquals((Object)"test format value: duration 0:00.000s", (Object)info.toString());
        info = new DurationInfo(this.log, false, "test format %s", new Object[]{"value"});
        Assert.assertEquals((Object)"test format value: duration 0:00.000s", (Object)info.toString());
    }

    @Test
    public void testDurationInfoWithMultipleClose() throws Exception {
        DurationInfo info = new DurationInfo(this.log, "test", new Object[0]);
        Thread.sleep(1000L);
        info.close();
        info.close();
        Assert.assertTrue((info.value() > 0L ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testDurationInfoCreationWithNullMsg() {
        DurationInfo info = new DurationInfo(this.log, null, new Object[0]);
        info.close();
    }
}

