/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapoint;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;

public abstract class TelemetryDatapointMeasurement {
    @NonNull
    private final TelemetryDatapoint datapoint;
    private final long epochTimestampNanos;

    public double getValue() {
        return this.getValueCore();
    }

    protected abstract double getValueCore();

    public abstract String toString(@NonNull TelemetryFormat var1, @NonNull EpochFormatter var2);

    @NonNull
    @Generated
    public TelemetryDatapoint getDatapoint() {
        return this.datapoint;
    }

    @Generated
    public long getEpochTimestampNanos() {
        return this.epochTimestampNanos;
    }

    @Generated
    protected TelemetryDatapointMeasurement(@NonNull TelemetryDatapoint datapoint, long epochTimestampNanos) {
        if (datapoint == null) {
            throw new NullPointerException("datapoint is marked non-null but is null");
        }
        this.datapoint = datapoint;
        this.epochTimestampNanos = epochTimestampNanos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryDatapointMeasurement)) {
            return false;
        }
        TelemetryDatapointMeasurement other = (TelemetryDatapointMeasurement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpochTimestampNanos() != other.getEpochTimestampNanos()) {
            return false;
        }
        TelemetryDatapoint this$datapoint = this.getDatapoint();
        TelemetryDatapoint other$datapoint = other.getDatapoint();
        return !(this$datapoint == null ? other$datapoint != null : !((Object)this$datapoint).equals(other$datapoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TelemetryDatapointMeasurement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epochTimestampNanos = this.getEpochTimestampNanos();
        result = result * 59 + (int)($epochTimestampNanos >>> 32 ^ $epochTimestampNanos);
        TelemetryDatapoint $datapoint = this.getDatapoint();
        result = result * 59 + ($datapoint == null ? 43 : ((Object)$datapoint).hashCode());
        return result;
    }

    public static abstract class TelemetryDatapointMeasurementBuilder<T extends TelemetryDatapointMeasurement, TBuilder extends TelemetryDatapointMeasurementBuilder<T, TBuilder>> {
        protected static final long UNSET_NANOS = Long.MIN_VALUE;
        private long epochTimestampNanos = Long.MIN_VALUE;

        public TBuilder epochTimestampNanos(long epochTimestampNanos) {
            this.epochTimestampNanos = epochTimestampNanos;
            return this.self();
        }

        protected TBuilder self() {
            return (TBuilder)this;
        }

        public T build() {
            Preconditions.checkArgument(this.epochTimestampNanos >= 0L, "The `epochTimestampNanos` must be set and non-negative.");
            return this.buildCore();
        }

        protected abstract T buildCore();

        @Generated
        protected long getEpochTimestampNanos() {
            return this.epochTimestampNanos;
        }
    }
}

