/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WorkerAssigner
implements ServerListener {
    private final Map<ServerName, Integer> currentWorkers = new HashMap<ServerName, Integer>();
    private final MasterServices master;
    private final ProcedureEvent<?> event;
    private final int maxTasks;

    public WorkerAssigner(MasterServices master, int maxTasks, ProcedureEvent<?> event) {
        this.maxTasks = maxTasks;
        this.master = master;
        this.event = event;
        ServerManager sm = this.master.getServerManager();
        if (sm != null) {
            sm.registerListener(this);
        }
    }

    public synchronized ServerName acquire(Procedure<?> proc) throws ProcedureSuspendedException {
        List<ServerName> serverList = this.master.getServerManager().getOnlineServersList();
        Collections.shuffle(serverList);
        Optional<ServerName> worker = serverList.stream().filter(serverName -> !this.currentWorkers.containsKey(serverName) || this.currentWorkers.get(serverName) > 0).findAny();
        if (worker.isPresent()) {
            ServerName sn = worker.get();
            this.currentWorkers.compute(sn, (serverName, availableWorker) -> availableWorker == null ? this.maxTasks - 1 : availableWorker - 1);
            return sn;
        }
        this.event.suspend();
        this.event.suspendIfNotReady(proc);
        throw new ProcedureSuspendedException();
    }

    public synchronized void release(ServerName serverName) {
        this.currentWorkers.compute(serverName, (k, v) -> v == null ? null : Integer.valueOf(v + 1));
        if (!this.event.isReady()) {
            this.event.wake((AbstractProcedureScheduler)((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()).getProcedureScheduler());
        }
    }

    @Override
    public synchronized void serverAdded(ServerName worker) {
        if (!this.event.isReady()) {
            this.event.wake((AbstractProcedureScheduler)((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment()).getProcedureScheduler());
        }
    }

    public synchronized void addUsedWorker(ServerName worker) {
        this.currentWorkers.compute(worker, (serverName, availableWorker) -> availableWorker == null ? this.maxTasks - 1 : availableWorker - 1);
    }

    public Integer getAvailableWorker(ServerName serverName) {
        return this.currentWorkers.get(serverName);
    }
}

