/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerManager;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerStateStore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorker;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public final class RegionNormalizerFactory {
    private RegionNormalizerFactory() {
    }

    public static RegionNormalizerManager createNormalizerManager(Configuration conf, MasterRegion masterRegion, ZKWatcher zkWatcher, HMaster master) throws DeserializationException, IOException, KeeperException {
        RegionNormalizer regionNormalizer = RegionNormalizerFactory.getRegionNormalizer(conf);
        regionNormalizer.setMasterServices(master);
        RegionNormalizerStateStore stateStore = new RegionNormalizerStateStore(masterRegion, zkWatcher);
        RegionNormalizerChore chore = master.isInMaintenanceMode() ? null : new RegionNormalizerChore(master);
        RegionNormalizerWorkQueue<TableName> workQueue = master.isInMaintenanceMode() ? null : new RegionNormalizerWorkQueue<TableName>();
        RegionNormalizerWorker worker = master.isInMaintenanceMode() ? null : new RegionNormalizerWorker(conf, master, regionNormalizer, workQueue);
        return new RegionNormalizerManager(stateStore, chore, workQueue, worker);
    }

    private static RegionNormalizer getRegionNormalizer(Configuration conf) {
        Class balancerKlass = conf.getClass("hbase.master.normalizer.class", SimpleRegionNormalizer.class, RegionNormalizer.class);
        return (RegionNormalizer)ReflectionUtils.newInstance((Class)balancerKlass, (Configuration)conf);
    }
}

