/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.test.IntegrationTestBigLinkedList;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestReplication
extends IntegrationTestBigLinkedList {
    protected String sourceClusterIdString;
    protected String sinkClusterIdString;
    protected int numIterations;
    protected int numMappers;
    protected long numNodes;
    protected String outputDir;
    protected int numReducers;
    protected int generateVerifyGap;
    protected Integer width;
    protected Integer wrapMultiplier;
    protected boolean noReplicationSetup = false;
    private final String SOURCE_CLUSTER_OPT = "sourceCluster";
    private final String DEST_CLUSTER_OPT = "destCluster";
    private final String ITERATIONS_OPT = "iterations";
    private final String NUM_MAPPERS_OPT = "numMappers";
    private final String OUTPUT_DIR_OPT = "outputDir";
    private final String NUM_REDUCERS_OPT = "numReducers";
    private final String NO_REPLICATION_SETUP_OPT = "noReplicationSetup";
    private final String GENERATE_VERIFY_GAP_OPT = "generateVerifyGap";
    private final String WIDTH_OPT = "width";
    private final String WRAP_MULTIPLIER_OPT = "wrapMultiplier";
    private final String NUM_NODES_OPT = "numNodes";
    private final int DEFAULT_NUM_MAPPERS = 1;
    private final int DEFAULT_NUM_REDUCERS = 1;
    private final int DEFAULT_NUM_ITERATIONS = 1;
    private final int DEFAULT_GENERATE_VERIFY_GAP = 60;
    private final int DEFAULT_WIDTH = 1000000;
    private final int DEFAULT_WRAP_MULTIPLIER = 25;
    private final int DEFAULT_NUM_NODES = 25000000;

    @Override
    protected void addOptions() {
        super.addOptions();
        this.addRequiredOptWithArg("s", "sourceCluster", "Cluster ID of the source cluster (e.g. localhost:2181:/hbase)");
        this.addRequiredOptWithArg("r", "destCluster", "Cluster ID of the sink cluster (e.g. localhost:2182:/hbase)");
        this.addRequiredOptWithArg("d", "outputDir", "Temporary directory where to write keys for the test");
        this.addOptWithArg("nm", "numMappers", "Number of mappers (default: 1)");
        this.addOptWithArg("nr", "numReducers", "Number of reducers (default: 1)");
        this.addOptNoArg("nrs", "noReplicationSetup", "Don't setup tables or configure replication before starting test");
        this.addOptWithArg("n", "numNodes", "Number of nodes. This should be a multiple of width * wrapMultiplier. (default: 25000000)");
        this.addOptWithArg("i", "iterations", "Number of iterations to run (default: 1)");
        this.addOptWithArg("t", "generateVerifyGap", "Gap between generate and verify steps in seconds (default: 60)");
        this.addOptWithArg("w", "width", "Width of the linked list chain (default: 1000000)");
        this.addOptWithArg("wm", "wrapMultiplier", "How many times to wrap around (default: 25)");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.processBaseOptions(cmd);
        this.sourceClusterIdString = cmd.getOptionValue("sourceCluster");
        this.sinkClusterIdString = cmd.getOptionValue("destCluster");
        this.outputDir = cmd.getOptionValue("outputDir");
        this.numMappers = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("numMappers", Integer.toString(1)), (int)1, (int)Integer.MAX_VALUE);
        this.numReducers = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("numReducers", Integer.toString(1)), (int)1, (int)Integer.MAX_VALUE);
        this.numNodes = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("numNodes", Integer.toString(25000000)), (int)1, (int)Integer.MAX_VALUE);
        this.generateVerifyGap = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("generateVerifyGap", Integer.toString(60)), (int)1, (int)Integer.MAX_VALUE);
        this.numIterations = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("iterations", Integer.toString(1)), (int)1, (int)Integer.MAX_VALUE);
        this.width = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("width", Integer.toString(1000000)), (int)1, (int)Integer.MAX_VALUE);
        this.wrapMultiplier = IntegrationTestReplication.parseInt((String)cmd.getOptionValue("wrapMultiplier", Integer.toString(25)), (int)1, (int)Integer.MAX_VALUE);
        if (cmd.hasOption("noReplicationSetup")) {
            this.noReplicationSetup = true;
        }
        if (this.numNodes % (long)(this.width * this.wrapMultiplier) != 0L) {
            throw new RuntimeException("numNodes must be a multiple of width and wrap multiplier");
        }
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        VerifyReplicationLoop tool = new VerifyReplicationLoop();
        tool.integrationTestBigLinkedList = this;
        return ToolRunner.run((Configuration)this.getConf(), (Tool)tool, null);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestReplication(), (String[])args);
        System.exit(ret);
    }

    protected class VerifyReplicationLoop
    extends Configured
    implements Tool {
        private final Logger LOG = LoggerFactory.getLogger(VerifyReplicationLoop.class);
        protected ClusterID source;
        protected ClusterID sink;
        IntegrationTestBigLinkedList integrationTestBigLinkedList;

        protected VerifyReplicationLoop() {
        }

        protected void setupTablesAndReplication() throws Exception {
            ClusterID[] clusters;
            TableName tableName = IntegrationTestBigLinkedList.getTableName(this.source.getConfiguration());
            for (ClusterID cluster : clusters = new ClusterID[]{this.source, this.sink}) {
                Admin admin = cluster.getConnection().getAdmin();
                if (!admin.tableExists(tableName)) continue;
                if (admin.isTableEnabled(tableName)) {
                    admin.disableTable(tableName);
                }
                TreeSet<ServerName> regionServers = new TreeSet<ServerName>();
                for (HRegionLocation rl : cluster.getConnection().getRegionLocator(tableName).getAllRegionLocations()) {
                    regionServers.add(rl.getServerName());
                }
                for (ServerName server : regionServers) {
                    this.source.getConnection().getAdmin().rollWALWriter(server);
                }
                admin.deleteTable(tableName);
            }
            IntegrationTestBigLinkedList.Generator generator = new IntegrationTestBigLinkedList.Generator();
            generator.setConf(this.source.getConfiguration());
            generator.createSchema();
            if (!this.source.equals(this.sink)) {
                try (Admin admin = this.source.getConnection().getAdmin();){
                    for (ReplicationPeerDescription peer : admin.listReplicationPeers()) {
                        admin.removeReplicationPeer(peer.getPeerId());
                    }
                    HashMap toReplicate = new HashMap();
                    toReplicate.put(tableName, Collections.emptyList());
                    ReplicationPeerConfig peerConfig = ReplicationPeerConfig.newBuilder().setClusterKey(this.sink.toString()).setReplicateAllUserTables(false).setTableCFsMap(toReplicate).build();
                    admin.addReplicationPeer("TestPeer", peerConfig);
                    admin.enableTableReplication(tableName);
                }
            }
            for (ClusterID cluster : clusters) {
                cluster.closeConnection();
            }
        }

        protected void waitForReplication() throws Exception {
            Thread.sleep(IntegrationTestReplication.this.generateVerifyGap * 1000);
        }

        protected void runGenerator() throws Exception {
            Path outputPath = new Path(IntegrationTestReplication.this.outputDir);
            IntegrationTestReplication.this.util;
            UUID uuid = IntegrationTestingUtility.getRandomUUID();
            Path generatorOutput = new Path(outputPath, uuid.toString());
            IntegrationTestBigLinkedList.Generator generator = new IntegrationTestBigLinkedList.Generator();
            generator.setConf(this.source.getConfiguration());
            int retCode = generator.run(IntegrationTestReplication.this.numMappers, IntegrationTestReplication.this.numNodes, generatorOutput, IntegrationTestReplication.this.width, IntegrationTestReplication.this.wrapMultiplier, 0);
            if (retCode > 0) {
                throw new RuntimeException("Generator failed with return code: " + retCode);
            }
        }

        protected void runVerify(long expectedNumNodes) throws Exception {
            Path outputPath = new Path(IntegrationTestReplication.this.outputDir);
            IntegrationTestReplication.this.util;
            UUID uuid = IntegrationTestingUtility.getRandomUUID();
            Path iterationOutput = new Path(outputPath, uuid.toString());
            IntegrationTestBigLinkedList.Verify verify = new IntegrationTestBigLinkedList.Verify();
            verify.setConf(this.sink.getConfiguration());
            int retCode = verify.run(iterationOutput, IntegrationTestReplication.this.numReducers);
            if (retCode > 0) {
                throw new RuntimeException("Verify.run failed with return code: " + retCode);
            }
            if (!verify.verify(expectedNumNodes)) {
                throw new RuntimeException("Verify.verify failed");
            }
            this.LOG.info("Verify finished with success. Total nodes=" + expectedNumNodes);
        }

        public int run(String[] args) throws Exception {
            this.source = new ClusterID(this.getConf(), IntegrationTestReplication.this.sourceClusterIdString);
            this.sink = new ClusterID(this.getConf(), IntegrationTestReplication.this.sinkClusterIdString);
            if (!IntegrationTestReplication.this.noReplicationSetup) {
                this.setupTablesAndReplication();
            }
            long expectedNumNodes = 0L;
            for (int i = 0; i < IntegrationTestReplication.this.numIterations; ++i) {
                this.LOG.info("Starting iteration = " + i);
                this.runGenerator();
                this.waitForReplication();
                this.runVerify(expectedNumNodes += (long)IntegrationTestReplication.this.numMappers * IntegrationTestReplication.this.numNodes);
            }
            return 0;
        }
    }

    protected static class ClusterID {
        private final Configuration configuration;
        private Connection connection = null;

        public ClusterID(Configuration base, String key) {
            this.configuration = new Configuration(base);
            Iterator iter = Splitter.on((char)':').split((CharSequence)key).iterator();
            this.configuration.set("hbase.zookeeper.quorum", (String)iter.next());
            this.configuration.set("hbase.zookeeper.property.clientPort", (String)iter.next());
            this.configuration.set("zookeeper.znode.parent", (String)iter.next());
        }

        public String toString() {
            return Joiner.on((String)":").join((Object)this.configuration.get("hbase.zookeeper.quorum"), (Object)this.configuration.get("hbase.zookeeper.property.clientPort"), new Object[]{this.configuration.get("zookeeper.znode.parent")});
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Connection getConnection() throws Exception {
            if (this.connection == null) {
                this.connection = ConnectionFactory.createConnection((Configuration)this.configuration);
            }
            return this.connection;
        }

        public void closeConnection() throws Exception {
            this.connection.close();
            this.connection = null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClusterID)) {
                return false;
            }
            return this.toString().equalsIgnoreCase(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

