/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Random;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Tags(value={@Tag(value="org.apache.hadoop.hbase.testclassification.MiscTests"), @Tag(value="org.apache.hadoop.hbase.testclassification.SmallTests")})
public class TestPortAllocator {
    @Test
    public void testResolvePortConflict() throws Exception {
        Random random = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)random.nextInt(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<Integer>(){
            int[] numbers = new int[]{1, 1, 2};
            int count = 0;

            public Integer answer(InvocationOnMock invocation) {
                int ret = this.numbers[this.count];
                ++this.count;
                return ret;
            }
        });
        HBaseCommonTestingUtility.PortAllocator.AvailablePortChecker portChecker = (HBaseCommonTestingUtility.PortAllocator.AvailablePortChecker)Mockito.mock(HBaseCommonTestingUtility.PortAllocator.AvailablePortChecker.class);
        Mockito.when((Object)portChecker.available(ArgumentMatchers.anyInt())).thenReturn((Object)true);
        HBaseCommonTestingUtility.PortAllocator portAllocator = new HBaseCommonTestingUtility.PortAllocator(random, portChecker);
        int port1 = portAllocator.randomFreePort();
        int port2 = portAllocator.randomFreePort();
        Assertions.assertNotEquals((int)port1, (int)port2);
        ((Random)Mockito.verify((Object)random, (VerificationMode)Mockito.times((int)3))).nextInt(ArgumentMatchers.anyInt());
    }
}

