/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SecureBulkLoadClient;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestReplicaWithCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicaWithCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicaWithCluster.class);
    private static final int NB_SERVERS = 3;
    private static final byte[] row = TestReplicaWithCluster.class.getName().getBytes();
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static HBaseTestingUtility HTU2;
    private static final byte[] f;
    private static final int REFRESH_PERIOD = 1000;
    private static final int META_SCAN_TIMEOUT_IN_MILLISEC = 200;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        HTU.getConfiguration().setFloat("hbase.regionserver.logroll.multiplier", 1.0E-4f);
        HTU.getConfiguration().setInt("replication.source.size.capacity", 10240);
        HTU.getConfiguration().setLong("replication.source.sleepforretries", 100L);
        HTU.getConfiguration().setInt("hbase.regionserver.maxlogs", 2);
        HTU.getConfiguration().setLong("hbase.master.logcleaner.ttl", 10L);
        HTU.getConfiguration().setInt("zookeeper.recovery.retry", 1);
        HTU.getConfiguration().setInt("zookeeper.recovery.retry.intervalmill", 10);
        HTU.getConfiguration().setInt("hbase.client.primaryCallTimeout.get", 1000000);
        HTU.getConfiguration().setInt("hbase.client.primaryCallTimeout.scan", 1000000);
        HTU.getConfiguration().set("hbase.balancer.tablesOnMaster", "none");
        HTU.getConfiguration().set("hbase.coprocessor.region.classes", RegionServerHostingPrimayMetaRegionSlowOrStopCopro.class.getName());
        HTU.getConfiguration().setInt("hbase.client.meta.replica.scan.timeout", 200000);
        HTU.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(HTU.getAdmin(), TableName.META_TABLE_NAME, 2);
        HTU.getHBaseCluster().startMaster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (HTU2 != null) {
            HTU2.shutdownMiniCluster();
        }
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDeleteTable() throws IOException {
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        Table table = HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
        Put p = new Put(row);
        p.addColumn(f, row, row);
        table.put(p);
        Get g = new Get(row);
        Result r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            SlowMeCopro.cdl.get().countDown();
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        HTU.getAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeTable() throws Exception {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setRegionReplication(3).setCoprocessor(SlowMeCopro.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])f)).build();
        HTU.getAdmin().createTable(td);
        Table table = HTU.getConnection().getTable(td.getTableName());
        Put p = new Put(row);
        p.addColumn(f, row, row);
        table.put(p);
        Get g = new Get(row);
        Result r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        TableDescriptor bHdt = HTU.getAdmin().getDescriptor(td.getTableName());
        td = TableDescriptorBuilder.newBuilder((TableDescriptor)td).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])row)).build();
        HTU.getAdmin().disableTable(td.getTableName());
        HTU.getAdmin().modifyTable(td);
        HTU.getAdmin().enableTable(td.getTableName());
        TableDescriptor nHdt = HTU.getAdmin().getDescriptor(td.getTableName());
        Assert.assertEquals((String)("fams=" + Arrays.toString(nHdt.getColumnFamilies())), (long)(bHdt.getColumnFamilyCount() + 1), (long)nHdt.getColumnFamilyCount());
        p = new Put(row);
        p.addColumn(row, row, row);
        table.put(p);
        g = new Get(row);
        r = table.get(g);
        Assert.assertFalse((boolean)r.isStale());
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        Admin admin = HTU.getAdmin();
        nHdt = admin.getDescriptor(td.getTableName());
        Assert.assertEquals((String)("fams=" + Arrays.toString(nHdt.getColumnFamilies())), (long)(bHdt.getColumnFamilyCount() + 1), (long)nHdt.getColumnFamilyCount());
        admin.disableTable(td.getTableName());
        admin.deleteTable(td.getTableName());
        admin.close();
    }

    @Test
    public void testReplicaAndReplication() throws Exception {
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        HColumnDescriptor fam = new HColumnDescriptor(row);
        fam.setScope(1);
        hdt.addFamily(fam);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        HTU.getAdmin().createTable((TableDescriptor)hdt, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        Configuration conf2 = HBaseConfiguration.create((Configuration)HTU.getConfiguration());
        conf2.set("hbase.client.instance.id", String.valueOf(-1));
        conf2.set("zookeeper.znode.parent", "/2");
        MiniZooKeeperCluster miniZK = HTU.getZkCluster();
        HTU2 = new HBaseTestingUtility(conf2);
        HTU2.setZkCluster(miniZK);
        HTU2.startMiniCluster(3);
        LOG.info("Setup second Zk");
        HTU2.getAdmin().createTable((TableDescriptor)hdt, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(HTU2.getClusterKey());
        admin.addPeer("2", rpc, null);
        admin.close();
        Put p = new Put(row);
        p.addColumn(row, row, row);
        final Table table = HTU.getConnection().getTable(hdt.getTableName());
        table.put(p);
        HTU.getAdmin().flush(table.getName());
        LOG.info("Put & flush done on the first cluster. Now doing a get on the same cluster.");
        Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate() throws Exception {
                try {
                    SlowMeCopro.cdl.set(new CountDownLatch(1));
                    Get g = new Get(row);
                    g.setConsistency(Consistency.TIMELINE);
                    Result r = table.get(g);
                    Assert.assertTrue((boolean)r.isStale());
                    boolean bl = !r.isEmpty();
                    return bl;
                }
                finally {
                    SlowMeCopro.cdl.get().countDown();
                    SlowMeCopro.sleepTime.set(0L);
                }
            }
        });
        table.close();
        LOG.info("stale get on the first cluster done. Now for the second.");
        final Table table2 = HTU.getConnection().getTable(hdt.getTableName());
        Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluate() throws Exception {
                try {
                    SlowMeCopro.cdl.set(new CountDownLatch(1));
                    Get g = new Get(row);
                    g.setConsistency(Consistency.TIMELINE);
                    Result r = table2.get(g);
                    Assert.assertTrue((boolean)r.isStale());
                    boolean bl = !r.isEmpty();
                    return bl;
                }
                finally {
                    SlowMeCopro.cdl.get().countDown();
                    SlowMeCopro.sleepTime.set(0L);
                }
            }
        });
        table2.close();
        HTU.getAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
        HTU2.getAdmin().disableTable(hdt.getTableName());
        HTU2.deleteTable(hdt.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkLoad() throws IOException {
        Result r;
        Get g;
        byte[] row;
        int i;
        LOG.debug("Creating test table");
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        Table table = HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
        LOG.debug("Creating test data");
        Path dir = HTU.getDataTestDirOnTestFS(this.name.getMethodName());
        int numRows = 10;
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"val");
        final ArrayList<Pair> famPaths = new ArrayList<Pair>();
        for (HColumnDescriptor col : hdt.getColumnFamilies()) {
            Path hfile = new Path(dir, col.getNameAsString());
            TestHRegionServerBulkLoad.createHFile(HTU.getTestFileSystem(), hfile, col.getName(), qual, val, 10);
            famPaths.add(new Pair((Object)col.getName(), (Object)hfile.toString()));
        }
        LOG.debug("Loading test data");
        final ClusterConnection conn = (ClusterConnection)HTU.getAdmin().getConnection();
        table = conn.getTable(hdt.getTableName());
        final String bulkToken = new SecureBulkLoadClient(HTU.getConfiguration(), table).prepareBulkLoad((Connection)conn);
        ClientServiceCallable<Void> callable = new ClientServiceCallable<Void>((Connection)conn, hdt.getTableName(), TestHRegionServerBulkLoad.rowkey(0), (RpcController)new RpcControllerFactory(HTU.getConfiguration()).newController(), -1, Collections.emptyMap()){

            protected Void rpcCall() throws Exception {
                LOG.debug("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow()));
                SecureBulkLoadClient secureClient = null;
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                try (Table table = conn.getTable(this.getTableName());){
                    secureClient = new SecureBulkLoadClient(HTU.getConfiguration(), table);
                    secureClient.secureBulkLoadHFiles((ClientProtos.ClientService.BlockingInterface)this.getStub(), famPaths, regionName, true, null, bulkToken);
                }
                return null;
            }
        };
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(HTU.getConfiguration(), conn.getConnectionConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        caller.callWithRetries((RetryingCallable)callable, 10000);
        LOG.debug("Verifying data load");
        for (i = 0; i < 10; ++i) {
            row = TestHRegionServerBulkLoad.rowkey(i);
            g = new Get(row);
            r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        LOG.debug("Verifying replica queries");
        try {
            SlowMeCopro.cdl.set(new CountDownLatch(1));
            for (i = 0; i < 10; ++i) {
                row = TestHRegionServerBulkLoad.rowkey(i);
                g = new Get(row);
                g.setConsistency(Consistency.TIMELINE);
                r = table.get(g);
                Assert.assertTrue((boolean)r.isStale());
            }
            SlowMeCopro.cdl.get().countDown();
        }
        finally {
            SlowMeCopro.cdl.get().countDown();
            SlowMeCopro.sleepTime.set(0L);
        }
        HTU.getAdmin().disableTable(hdt.getTableName());
        HTU.deleteTable(hdt.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaGetWithPrimaryDown() throws IOException {
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        hdt.addCoprocessor(RegionServerStoppedCopro.class.getName());
        try {
            Table table = HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            table.put(p);
            HTU.flush(table.getName());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                LOG.error(e1.toString(), (Throwable)e1);
            }
            Get g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            Result r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            HTU.getAdmin().disableTable(hdt.getTableName());
            HTU.deleteTable(hdt.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaScanWithPrimaryDown() throws IOException {
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        hdt.addCoprocessor(RegionServerStoppedCopro.class.getName());
        try {
            Table table = HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            table.put(p);
            HTU.flush(table.getName());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                LOG.error(e1.toString(), (Throwable)e1);
            }
            Scan scan = new Scan();
            scan.addFamily(f);
            scan.setConsistency(Consistency.TIMELINE);
            ResultScanner scanner = table.getScanner(scan);
            Result r = scanner.next();
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            HTU.getAdmin().disableTable(hdt.getTableName());
            HTU.deleteTable(hdt.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaGetWithAsyncRpcClientImpl() throws IOException {
        HTU.getConfiguration().setBoolean("hbase.ipc.client.specificThreadForWriting", true);
        HTU.getConfiguration().set("hbase.rpc.client.impl", "org.apache.hadoop.hbase.ipc.AsyncRpcClient");
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(3);
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        try {
            Table table = HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
            Put p = new Put(row);
            p.addColumn(f, row, row);
            table.put(p);
            HTU.flush(table.getName());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                LOG.error(e1.toString(), (Throwable)e1);
            }
            try {
                Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
                Table t = connection.getTable(hdt.getTableName());
                SlowMeCopro.cdl.set(new CountDownLatch(1));
                Get g = new Get(row);
                g.setConsistency(Consistency.TIMELINE);
                Result r = t.get(g);
                Assert.assertTrue((boolean)r.isStale());
                SlowMeCopro.cdl.get().countDown();
            }
            finally {
                SlowMeCopro.cdl.get().countDown();
                SlowMeCopro.sleepTime.set(0L);
            }
        }
        finally {
            HTU.getConfiguration().unset("hbase.ipc.client.specificThreadForWriting");
            HTU.getConfiguration().unset("hbase.rpc.client.impl");
            HTU.getAdmin().disableTable(hdt.getTableName());
            HTU.deleteTable(hdt.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRegionLocationFromPrimaryMetaRegion() throws IOException, InterruptedException {
        HTU.getAdmin().setBalancerRunning(false, true);
        Configuration conf = new Configuration(HTU.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(2);
        try {
            HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
            RegionServerHostingPrimayMetaRegionSlowOrStopCopro.slowDownPrimaryMetaScan = true;
            RegionLocations regionLocations = ((ClusterConnection)conn).locateRegion(hdt.getTableName(), row, false, false);
        }
        finally {
            RegionServerHostingPrimayMetaRegionSlowOrStopCopro.slowDownPrimaryMetaScan = false;
            HTU.getAdmin().setBalancerRunning(true, true);
            HTU.getAdmin().disableTable(hdt.getTableName());
            HTU.deleteTable(hdt.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaGetWithPrimaryAndMetaDown() throws IOException, InterruptedException {
        HTU.getAdmin().setBalancerRunning(false, true);
        Configuration conf = new Configuration(HTU.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        HTableDescriptor hdt = HTU.createTableDescriptor(this.name.getMethodName());
        hdt.setRegionReplication(2);
        try {
            HTU.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{f}, null);
            Table table = conn.getTable(TableName.valueOf((String)this.name.getMethodName()));
            RegionLocations mrl = ((ClusterConnection)conn).locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
            RegionLocations url = ((ClusterConnection)conn).locateRegion(hdt.getTableName(), row, false, false);
            if (!url.getDefaultRegionLocation().getServerName().equals((Object)mrl.getDefaultRegionLocation().getServerName())) {
                HTU.moveRegionAndWait((RegionInfo)url.getDefaultRegionLocation().getRegionInfo(), mrl.getDefaultRegionLocation().getServerName());
            }
            if (url.getRegionLocation(1).getServerName().equals((Object)mrl.getDefaultRegionLocation().getServerName())) {
                HTU.moveRegionAndWait((RegionInfo)url.getRegionLocation(1).getRegionInfo(), url.getDefaultRegionLocation().getServerName());
            }
            while (true) {
                mrl = ((ClusterConnection)conn).locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
                url = ((ClusterConnection)conn).locateRegion(hdt.getTableName(), row, false, true);
                LOG.info("meta locations " + mrl);
                LOG.info("table locations " + url);
                ServerName a = url.getDefaultRegionLocation().getServerName();
                ServerName b = mrl.getDefaultRegionLocation().getServerName();
                if (a.equals((Object)b)) break;
                LOG.info("Waiting for new region info to be updated in meta table");
                Thread.sleep(100L);
            }
            Put p = new Put(row);
            p.addColumn(f, row, row);
            table.put(p);
            HTU.flush(table.getName());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                LOG.error(e1.toString(), (Throwable)e1);
            }
            RegionServerHostingPrimayMetaRegionSlowOrStopCopro.throwException = true;
            Get g = new Get(row);
            g.setConsistency(Consistency.TIMELINE);
            Result r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            RegionServerHostingPrimayMetaRegionSlowOrStopCopro.throwException = false;
            HTU.getAdmin().setBalancerRunning(true, true);
            HTU.getAdmin().disableTable(hdt.getTableName());
            HTU.deleteTable(hdt.getTableName());
        }
    }

    static {
        f = HConstants.CATALOG_FAMILY;
    }

    public static class RegionServerHostingPrimayMetaRegionSlowOrStopCopro
    implements RegionCoprocessor,
    RegionObserver {
        static boolean slowDownPrimaryMetaScan = false;
        static boolean throwException = false;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            int replicaId = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId();
            if (throwException) {
                if (!((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().isMetaRegion() && replicaId == 0) {
                    LOG.info("Get, throw Region Server Stopped Exceptoin for region " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo());
                    throw new RegionServerStoppedException("Server " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getServerName() + " not running");
                }
            } else {
                LOG.info("Get, We're replica region " + replicaId);
            }
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            int replicaId = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId();
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().isMetaRegion() && replicaId == 0) {
                if (slowDownPrimaryMetaScan) {
                    LOG.info("Scan with primary meta region, slow down a bit");
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (throwException) {
                    LOG.info("Scan, throw Region Server Stopped Exceptoin for replica " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo());
                    throw new RegionServerStoppedException("Server " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getServerName() + " not running");
                }
                LOG.info("Scan, We're replica region " + replicaId);
            } else {
                LOG.info("Scan, We're replica region " + replicaId);
            }
        }
    }

    @CoreCoprocessor
    public static class RegionServerStoppedCopro
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            int replicaId = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId();
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() <= 1) {
                LOG.info("Throw Region Server Stopped Exceptoin for replica id " + replicaId);
                throw new RegionServerStoppedException("Server " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getServerName() + " not running");
            }
            LOG.info("We're replica region " + replicaId);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            int replicaId = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId();
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() <= 1) {
                LOG.info("Throw Region Server Stopped Exceptoin for replica id " + replicaId);
                throw new RegionServerStoppedException("Server " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getServerName() + " not running");
            }
            LOG.info("We're replica region " + replicaId);
        }
    }

    public static class SlowMeCopro
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(0L);
        static final AtomicReference<CountDownLatch> cdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() == 0) {
                CountDownLatch latch = cdl.get();
                try {
                    if (sleepTime.get() > 0L) {
                        LOG.info("Sleeping for " + sleepTime.get() + " ms");
                        Thread.sleep(sleepTime.get());
                    } else if (latch.getCount() > 0L) {
                        LOG.info("Waiting for the counterCountDownLatch");
                        latch.await(2L, TimeUnit.MINUTES);
                        if (latch.getCount() > 0L) {
                            throw new RuntimeException("Can't wait more");
                        }
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error(e1.toString(), (Throwable)e1);
                }
            } else {
                LOG.info("We're not the primary replicas.");
            }
        }
    }
}

