/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterFileSystemWithWALDir {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFileSystemWithWALDir.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().createWALDir(true).build());
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFsUriSetProperly() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        Path masterRoot = CommonFSUtils.getRootDir((Configuration)fs.getConfiguration());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)fs.getFileSystem().getConf());
        Assert.assertEquals((Object)masterRoot, (Object)rootDir);
        Assert.assertEquals((Object)CommonFSUtils.getWALRootDir((Configuration)UTIL.getConfiguration()), (Object)fs.getWALRootDir());
    }
}

