/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ReloadQuotasProcedure;
import org.apache.hadoop.hbase.master.procedure.TestServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReloadQuotasProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestReloadQuotasProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReloadQuotasProcedure.class);
    @Rule
    public TestName name = new TestName();
    private HBaseTestingUtility util;
    private MockMasterServices master;
    private TestServerRemoteProcedure.MockRSProcedureDispatcher rsDispatcher;

    @Before
    public void setUp() throws Exception {
        this.util = new HBaseTestingUtility();
        this.master = new MockMasterServices(this.util.getConfiguration());
        this.rsDispatcher = new TestServerRemoteProcedure.MockRSProcedureDispatcher(this.master);
        this.master.start(2, this.rsDispatcher);
    }

    @After
    public void tearDown() throws Exception {
        this.master.stop("tearDown");
    }

    @Test
    public void itHandlesClassNotFoundExceptionGracefully() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        ClassNotFoundException classNotFound = new ClassNotFoundException("ReloadQuotasCallable not found");
        IOException wrappedException = new IOException("Remote call failed", classNotFound);
        boolean result = procedure.complete((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), (Throwable)wrappedException);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void itReturnsFailureForOtherExceptions() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        IOException otherException = new IOException("Some other error");
        boolean result = procedure.complete((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), (Throwable)otherException);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void itReturnsSuccessForNoError() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        boolean result = procedure.complete((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), null);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void itCorrectlyDetectsCauseClass() {
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure();
        ClassNotFoundException classNotFound = new ClassNotFoundException("test");
        IOException wrappedException = new IOException("wrapper", classNotFound);
        RuntimeException outerWrapper = new RuntimeException("outer", wrappedException);
        Assert.assertTrue((boolean)procedure.containsCause((Throwable)outerWrapper, ClassNotFoundException.class));
        Assert.assertFalse((boolean)procedure.containsCause((Throwable)outerWrapper, IllegalArgumentException.class));
        Assert.assertTrue((boolean)procedure.containsCause((Throwable)classNotFound, ClassNotFoundException.class));
    }

    @Test
    public void itValidatesServerNameInRemoteCallBuild() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ServerName wrongServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(1);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        Optional result = procedure.remoteCallBuild(env, targetServer);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof RSProcedureDispatcher.ServerOperation));
        Assert.assertThrows(IllegalArgumentException.class, () -> procedure.remoteCallBuild(env, wrongServer));
    }

    @Test
    public void itCreatesCorrectRemoteOperation() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        Optional operation = procedure.remoteCallBuild(env, targetServer);
        Assert.assertTrue((boolean)operation.isPresent());
        RSProcedureDispatcher.ServerOperation serverOp = (RSProcedureDispatcher.ServerOperation)operation.get();
        Assert.assertEquals((Object)serverOp.getRemoteProcedure(), (Object)procedure);
        Assert.assertEquals((long)serverOp.buildRequest().getProcId(), (long)procedure.getProcId());
    }

    @Test
    public void itThrowsUnsupportedOperationExceptionOnRollback() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        Assert.assertThrows(UnsupportedOperationException.class, () -> procedure.rollback(env));
    }

    @Test
    public void itReturnsFalseOnAbort() throws Exception {
        ServerName targetServer = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ReloadQuotasProcedure procedure = new ReloadQuotasProcedure(targetServer);
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        boolean result = procedure.abort(env);
        Assert.assertFalse((boolean)result);
    }

    private Future<byte[]> submitProcedure(ReloadQuotasProcedure procedure) {
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), (Procedure)procedure);
    }
}

